/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "utils.h"
#include "browserthread.h"

#include <QMap>
#include <QUrl>


using namespace std;

/******************************************************************************
    ParseQuotedStrings
******************************************************************************/
void
CUtils::ParseQuotedStrings(
    const string&   sCompound,
    vector<string>& separated)
{
    string sCopy(sCompound);

    string::size_type nIdxNext = 0;

    while (nIdxNext < sCopy.size())
    {
        string::size_type nIdxStart = sCopy.find_first_of('\"', nIdxNext);

        if (nIdxStart == string::npos)
        {
            // Not found
            return;
        }

        nIdxStart++;
        if (nIdxStart >= sCopy.size())
        {
            // Buggered string
            return;
        }

        string::size_type nIdxStop = nIdxStart;
        bool bStopFound = false;
        do
        {
            nIdxStop = sCopy.find_first_of('\"', nIdxStop);
            if (nIdxStop == string::npos)
            {
                // Buggered string
                return;
            }
            nIdxStop++;
            if (nIdxStop >= sCopy.size())
            {
                // True stop at end of string
                bStopFound = true;
                break;
            }

            // Check if escaped
            if (sCopy[nIdxStop] == '\"')
            {
                // Remove dupe
                sCopy.erase(nIdxStop, 1);
            }
            else
            {
                // Not escape, true stop
                bStopFound = true;
            }

        } while (!bStopFound);

        string sQuoted = sCopy.substr(nIdxStart, (nIdxStop - 1) - nIdxStart);
        separated.push_back(sQuoted);

        // Position next just after the closing "
        nIdxNext = nIdxStop;

    } // end while

}
        
/******************************************************************************
    Trim
******************************************************************************/
void
CUtils::Trim(
    string& str)
{
    string::size_type pos1 = str.find_first_not_of(" \t\n\f\r");

    if (pos1 == string::npos)
    {
        return;
    }

    string::size_type pos2 = str.find_last_not_of(" \t");

    str = str.substr(pos1, pos2 - pos1 + 1);
}

/******************************************************************************
    StripBBCode
******************************************************************************/
void
CUtils::StripBBCode(
    std::string& str)
{
    string::size_type nIdxNext = 0;

    while (nIdxNext < str.size())
    {
        string::size_type nIdxStart = str.find_first_of('[', nIdxNext);

        if (nIdxStart == string::npos)
        {
            // Not found
            return;
        }

        nIdxStart++;
        if (nIdxStart >= str.size())
        {
            // Buggered string
            return;
        }

        string::size_type nIdxStop = str.find_first_of(']', nIdxStart);
        if (nIdxStop == string::npos)
        {
            // Buggered string
            return;
        }

        // Remove BBCode section
        size_t numRemove = nIdxStop - nIdxStart + 2;
        str.erase(nIdxStart - 1, numRemove);

        nIdxNext = nIdxStop + 1 - numRemove;
    }

}

/******************************************************************************
    StripBBCode
******************************************************************************/
void
CUtils::StripBBCode(
    QString& str)
{
    int nIdxNext = 0;

    while (nIdxNext < str.size())
    {
        int nIdxStart = str.indexOf('[', nIdxNext);

        if (nIdxStart == -1)
        {
            // Not found
            return;
        }

        nIdxStart++;
        if (nIdxStart >= str.size())
        {
            // Buggered string
            return;
        }

        int nIdxStop = str.indexOf(']', nIdxStart);
        if (nIdxStop == -1)
        {
            // Buggered string
            return;
        }

        // Remove BBCode section
        int numRemove = nIdxStop - nIdxStart + 2;
        str.remove(nIdxStart - 1, numRemove);

        nIdxNext = nIdxStop + 1 - numRemove;
    }
    
}    

/******************************************************************************
    UrlEncodeItem
******************************************************************************/
QString
CUtils::UrlEncodeItem( QString item )
{
    UrlEncodeSpecialChars( item );
    item = QUrl::toPercentEncoding( item );
    
    return item;
}

/******************************************************************************
    UrlEncodeSpecialChars
******************************************************************************/
QString&
CUtils::UrlEncodeSpecialChars(
    QString& str)
{
    str.replace( "&", "%26" );
    str.replace( "/", "%2F" );
    str.replace( ";", "%3B" );
    str.replace( "+", "%2B" );
    str.replace( "#", "%23" );
    
    return str;
}

/******************************************************************************
    radioState2String
******************************************************************************/
QString
CUtils::radioState2String( RadioState state )
{
    switch ( state )
    {
        case State_Uninitialised: return "State_Uninitialised";
        case State_Handshaking: return "State_Handshaking";
        case State_Handshaken: return "State_Handshaken";
        case State_ChangingStation: return "State_ChangingStation";
        case State_FetchingPlaylist: return "State_FetchingPlaylist";
        case State_FetchingStream: return "State_FetchingStream";
        case State_StreamFetched: return "State_StreamFetched";
        case State_Buffering: return "State_Buffering";
        case State_Streaming: return "State_Streaming";
        case State_Skipping: return "State_Skipping";
        case State_Stopping: return "State_Stopping";
        case State_Stopped: return "State_Stopped";
        default: Q_ASSERT( !"Unhandled state" ); return "";
    }
}

