#ifndef LASTFMTOOLS_COMMON
#define LASTFMTOOLS_COMMON

// When we compile the tools header as part of liblastfmtools, we need
// dllexport for the functions to be exported. When including the header
// as part of the client modules, we want dllimport so that the compiler
// can do some optimisations. LASTFMTOOLS_EXP should only be defined in
// the tools .pro.
#if defined(_WIN32) || defined(WIN32)
    #ifdef LASTFMTOOLS_EXP
        #define MCEXP __declspec(dllexport)
    #else
        #define MCEXP __declspec(dllimport)
    #endif
#else
    #define MCEXP
#endif

  
class Container;
class MetaData;
class Settings;
class UserSettings;
class WebService;


namespace The
{
    Settings &settings();
    WebService *webService();
}


enum UserIconColour
{
    eNone = -1,
    eRed = 0,
    eBlue,
    eGreen,
    eOrange,
    eBlack
};

#endif // LASTFMTOOLS_COMMON
