/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "imagebutton.h"
#include <QMouseEvent>


ImageButton::ImageButton( QWidget *parent ) :
        QLabel( parent ),
        m_enabled( true )
{}


void
ImageButton::setImages( QString prefix,
                        QString normal,
                        QString down,
                        QString hover,
                        QString disabled )
{
    m_normal.load( prefix + normal );
    m_down.load( prefix + down );
    m_hover.load( prefix + hover );
    m_disabled.load( prefix + disabled );

    setPixmap( m_normal );
}


void
ImageButton::setImages( QPixmap normal,
                        QPixmap down,
                        QPixmap hover,
                        QPixmap disabled )
{
    m_normal = normal;
    m_down = down;
    m_hover = hover;
    m_disabled = disabled;

    setPixmap( m_normal );
}


void
ImageButton::setEnabled( bool enabled )
{
    m_enabled = enabled;
    setPixmap( enabled ? m_normal : m_disabled );
}

void
ImageButton::setHoverCursor( QCursor cursor )
{
    setCursor( cursor );
}

void
ImageButton::mousePressEvent( QMouseEvent *e )
{
    if (e->button() == Qt::LeftButton && m_enabled)
        setPixmap( m_down );
}


void
ImageButton::mouseReleaseEvent( QMouseEvent * e )
{
    if (e->button() == Qt::LeftButton && m_enabled)
    {
        setPixmap( m_normal );
        emit clicked();
    }
}


void
ImageButton::enterEvent( QEvent* /*e*/ )
{
    if (m_enabled)
    {
        this->setPixmap( m_hover );
        //setCursor( m_hoverCursor );
    }
}


void
ImageButton::leaveEvent( QEvent* /*e*/ )
{
    if ( m_enabled )
    {
        this->setPixmap( m_normal );
        //setCursor( Qt::ArrowCursor );
    }

}

