/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef CONFIRMDIALOG_H
#define CONFIRMDIALOG_H

#include "lastfmtools_common.h"
#include <QPixmap>
#include <QDialog>
#include "ui_confirmdialog.h"


class MCEXP ConfirmDialog : public QDialog
{
    Q_OBJECT

    public:

        enum Operation
        {
            Tag,
            Recommend,
            Love,
            Ban,
            Quit
			#ifdef Q_WS_MAC
				,
				DockRestart
			#endif
        };

        ConfirmDialog( Operation op,
                       QString text,
                       QWidget *parent = 0 );
            
        ~ConfirmDialog();

    public slots:
        void setIcon( const QPixmap& icon );
        void setIcon( const QString& file );
        void setText( const QString& text );

        bool isDontAskChecked();

        int exec();
        virtual void accept();
        virtual void reject();

    private:
        Ui::ConfirmDialog ui;

        Operation m_op;
        QString m_opString;

        void saveCheckState();
};

#endif // CONFIRMDIALOG_H
