/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Erik Jalevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "StreamBufferMonitor.h"
#include "AudioController.h"

StreamBufferMonitor::StreamBufferMonitor( QWidget* parent ) :
    QDialog( parent ),
    m_ac( 0 )
{
    ui.setupUi( this );
    ui.httpBuf->setTextVisible( false );
    ui.decodedBuf->setTextVisible( false );
    ui.outputBuf->setTextVisible( false );

    // 300K for all
    ui.httpBuf->setMaximum( 300000 ); 
    ui.decodedBuf->setMaximum( 300000 ); 
    ui.outputBuf->setMaximum( 300000 ); 

}

void
StreamBufferMonitor::run()
{
    connect( &m_ac->m_thread, SIGNAL( httpBufferSizeChanged( int) ),
             this,            SLOT( onHttpBufferSizeChanged( int ) ),
             Qt::QueuedConnection );
    connect( &m_ac->m_thread, SIGNAL( decodedBufferSizeChanged( int) ),
             this,            SLOT( onDecodedBufferSizeChanged( int ) ),
             Qt::QueuedConnection );
    connect( &m_ac->m_thread, SIGNAL( outputBufferSizeChanged( int) ),
             this,            SLOT( onOutputBufferSizeChanged( int ) ),
             Qt::QueuedConnection );
}


void
StreamBufferMonitor::onHttpBufferSizeChanged( int size )
{
    ui.httpBuf->setValue( size );
    ui.httpSize->setText( QString::number( size / 1000.0f, 'f', 1 ) );
}

void
StreamBufferMonitor::onDecodedBufferSizeChanged( int size )
{
    ui.decodedBuf->setValue( size );
    ui.decodedSize->setText( QString::number( size / 1000.0f, 'f', 1 ) );
}

void
StreamBufferMonitor::onOutputBufferSizeChanged( int size )
{
    ui.outputBuf->setValue( size );
    ui.outputSize->setText( QString::number( size / 1000.0f, 'f', 1 ) );
}
