/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "MediaDeviceConfirmDialog.h"
#include "container.h"
#include "containerutils.h"
#include "logger.h"

#include <QtGui>
#include <QString>
#include <QtDebug>

MediaDeviceConfirmDialog::MediaDeviceConfirmDialog( QString user, QWidget *parent )
        : QDialog( parent, Qt::Sheet )
        , m_user( user )
{
    ui.setupUi( this );

    QStringList headers;
    headers.append( tr( "Artist" ) );
    headers.append( tr( "Track" ) );
    headers.append( tr( "Time" ) );
    headers.append( tr( "Sort" ) );
    headers.append( tr( "Plays" ) );
    ui.tracksWidget->setHeaderLabels( headers );
    ui.tracksWidget->setColumnCount( 5 );
    ui.tracksWidget->setColumnHidden( 3, true );
    ui.tracksWidget->setSelectionMode( QAbstractItemView::NoSelection );

    readSubmitQueue( savePath( user + "_mediadevice.xml" ) );
    setIcon( dataPath( "app_55.png" ) );

////// this magnificent hack bought to you by teh mxcl
    // @short set the dialog's width to avoid horizontal scrollbars
    struct NoProtection : QAbstractItemView
    {
        using QAbstractItemView::sizeHintForColumn;
    };

    int w = 0, desiredwidth = 0;
    for (int x = 0; x < ui.tracksWidget->columnCount(); ++x) {
        desiredwidth = reinterpret_cast<NoProtection*>(ui.tracksWidget)->sizeHintForColumn( x );
        desiredwidth = qMin( 200, desiredwidth ); //don't be extreme!
        w += desiredwidth;
    }

    //make us always the right size
    adjustSize();

///////

    connect( ui.yesButton, SIGNAL( clicked() ),
             this,         SLOT  ( accept() ) );
    connect( ui.noButton,  SIGNAL( clicked() ),
             this,         SLOT  ( reject() ) );
}


void
MediaDeviceConfirmDialog::readSubmitQueue( QString path )
{
    QFile file( path );
    if ( !file.open( QIODevice::ReadOnly | QIODevice::Text ) )
    {
        return;
    }

    QTextStream stream( &file );
    stream.setCodec( "UTF-8" );

    QDomDocument d;
    QString errmsg;
    int errline;
    int errcol;
    if ( !d.setContent( stream.readAll(), false, &errmsg, &errline, &errcol ) )
    {
        LOG( 1, "Couldn't read file: " << path << errmsg << errline << errcol << "\n" );
        return;
    }

    const QString ITEM( "item" ); //so we don't construct these QStrings all the time
    QList<QTreeWidgetItem *> items;
    for( QDomNode n = d.namedItem( "submissions" ).firstChild(); !n.isNull() && n.nodeName() == ITEM; n = n.nextSibling() )
    {
        TrackInfo t( n.toElement() );

        QDateTime dt = QDateTime::fromTime_t( t.timeStamp() );
        QStringList tokens;

        tokens.append( t.artist() );
        tokens.append( t.track() );
        tokens.append( dt.toString( "dd/MM/yy hh:mm" ) );
        tokens.append( QString::number( t.timeStamp() ) );
        tokens.append( QString::number( t.playCount() ) );

        items.append( new QTreeWidgetItem( (QTreeWidget*)0, tokens ) );
    }

    ui.tracksWidget->insertTopLevelItems( 0, items );
    ui.tracksWidget->resizeColumnToContents( 0 );
    ui.tracksWidget->resizeColumnToContents( 1 );
    ui.tracksWidget->resizeColumnToContents( 2 );
    ui.tracksWidget->resizeColumnToContents( 4 );

    ui.tracksWidget->setSortingEnabled( true );
    ui.tracksWidget->sortByColumn( 3, Qt::DescendingOrder );

    QString text = tr( "You have just synced your iPod.\n\n"
        "Last.fm found %n new track(s) since the last time you synced. "
        "Do you want to scrobble these?", "", items.count() );
    ui.messageLabel->setText( text );

    file.close();
}


void
MediaDeviceConfirmDialog::setIcon( const QPixmap& icon )
{
    ui.iconLabel->setPixmap( icon );
}


void
MediaDeviceConfirmDialog::setIcon( const QString& file )
{
    ui.iconLabel->setPixmap( QPixmap( file ).scaled( 32, 32, Qt::IgnoreAspectRatio, Qt::SmoothTransformation ) );
}


int
MediaDeviceConfirmDialog::exec()
{
    if ( ui.tracksWidget->topLevelItemCount() > 0 )
    {
        activateWindow();
        return QDialog::exec();
    }
    else
        return QDialog::Rejected;
}
