/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }



#if defined(SWIGRUBY) || defined (PHP_VERSION)
/* Ruby and PHP pollute the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif


#include <lasso/lasso_config.h>
#include <lasso/lasso.h>
/* FIXME: IMHO, Lasso errors should not be defined in lasso/xml/ */
/*        and should be included in lasso.h. */
#include <lasso/xml/errors.h>


/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif



#define bool int
#define false 0
#define true 1



int get_exception_type(int errorCode) {
	int exceptionType;

	switch(errorCode) {
	case LASSO_PROFILE_ERROR_INVALID_QUERY:
		exceptionType = SWIG_SyntaxError;
		break;
	default:
		exceptionType = SWIG_UnknownError;
		break;
	}
	return exceptionType;
}




/* Constructors, destructors & static methods implementations */

#define new_LassoAssertion lasso_assertion_new

void delete_LassoAssertion(LassoAssertion *self) {
	lasso_node_destroy(LASSO_NODE(self));
}

/* Methods implementations */

gchar* LassoAssertion_dump(LassoAssertion *self) {
	return lasso_node_export(LASSO_NODE(self));
}




/* Attributes Implementations */

/* affiliationId */
#define LassoAuthnRequest_get_affiliationId LassoAuthnRequest_affiliationId_get
xmlChar *LassoAuthnRequest_affiliationId_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_affiliationId LassoAuthnRequest_affiliationId_set
void LassoAuthnRequest_affiliationId_set(LassoAuthnRequest *self, xmlChar *affiliationId) {
	 lasso_lib_authn_request_set_affiliationID(LASSO_LIB_AUTHN_REQUEST(self), affiliationId);
}

/* assertionConsumerServiceId */
#define LassoAuthnRequest_get_assertionConsumerServiceId LassoAuthnRequest_assertionConsumerServiceId_get
xmlChar *LassoAuthnRequest_assertionConsumerServiceId_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_assertionConsumerServiceId LassoAuthnRequest_assertionConsumerServiceId_set
void LassoAuthnRequest_assertionConsumerServiceId_set(LassoAuthnRequest *self,
						      xmlChar *assertionConsumerServiceId) {
	lasso_lib_authn_request_set_assertionConsumerServiceID(LASSO_LIB_AUTHN_REQUEST(self),
							       assertionConsumerServiceId);
}

/* consent */
#define LassoAuthnRequest_get_consent LassoAuthnRequest_consent_get
xmlChar *LassoAuthnRequest_consent_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_consent LassoAuthnRequest_consent_set
void LassoAuthnRequest_consent_set(LassoAuthnRequest *self, xmlChar *consent) {
	 lasso_lib_authn_request_set_consent(LASSO_LIB_AUTHN_REQUEST(self), consent);
}

/* forceAuthn */
#define LassoAuthnRequest_get_forceAuthn LassoAuthnRequest_forceAuthn_get
gboolean LassoAuthnRequest_forceAuthn_get(LassoAuthnRequest *self) {
	return 0; /* FIXME */
}
#define LassoAuthnRequest_set_forceAuthn LassoAuthnRequest_forceAuthn_set
void LassoAuthnRequest_forceAuthn_set(LassoAuthnRequest *self, gboolean forceAuthn) {
	 lasso_lib_authn_request_set_forceAuthn(LASSO_LIB_AUTHN_REQUEST(self), forceAuthn);
}

/* isPassive */
#define LassoAuthnRequest_get_isPassive LassoAuthnRequest_isPassive_get
gboolean LassoAuthnRequest_isPassive_get(LassoAuthnRequest *self) {
	return 0; /* FIXME */
}
#define LassoAuthnRequest_set_isPassive LassoAuthnRequest_isPassive_set
void LassoAuthnRequest_isPassive_set(LassoAuthnRequest *self, gboolean isPassive) {
	 lasso_lib_authn_request_set_isPassive(LASSO_LIB_AUTHN_REQUEST(self), isPassive);
}

/* nameIdPolicy */
#define LassoAuthnRequest_get_nameIdPolicy LassoAuthnRequest_nameIdPolicy_get
xmlChar *LassoAuthnRequest_nameIdPolicy_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_nameIdPolicy LassoAuthnRequest_nameIdPolicy_set
void LassoAuthnRequest_nameIdPolicy_set(LassoAuthnRequest *self, xmlChar *nameIdPolicy) {
	 lasso_lib_authn_request_set_nameIDPolicy(LASSO_LIB_AUTHN_REQUEST(self), nameIdPolicy);
}

/* protocolProfile */
#define LassoAuthnRequest_get_protocolProfile LassoAuthnRequest_protocolProfile_get
xmlChar *LassoAuthnRequest_protocolProfile_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_protocolProfile LassoAuthnRequest_protocolProfile_set
void LassoAuthnRequest_protocolProfile_set(LassoAuthnRequest *self, xmlChar *protocolProfile) {
	 lasso_lib_authn_request_set_protocolProfile(LASSO_LIB_AUTHN_REQUEST(self),
						     protocolProfile);
}

/* providerId */
#define LassoAuthnRequest_get_providerId LassoAuthnRequest_providerId_get
xmlChar *LassoAuthnRequest_providerId_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_providerId LassoAuthnRequest_providerId_set
void LassoAuthnRequest_providerId_set(LassoAuthnRequest *self, xmlChar *providerId) {
	 lasso_lib_authn_request_set_providerID(LASSO_LIB_AUTHN_REQUEST(self), providerId);
}

/* relayState */
#define LassoAuthnRequest_get_relayState LassoAuthnRequest_relayState_get
xmlChar *LassoAuthnRequest_relayState_get(LassoAuthnRequest *self) {
	return NULL; /* FIXME */
}
#define LassoAuthnRequest_set_relayState LassoAuthnRequest_relayState_set
void LassoAuthnRequest_relayState_set(LassoAuthnRequest *self, xmlChar *relayState) {
	 lasso_lib_authn_request_set_relayState(LASSO_LIB_AUTHN_REQUEST(self), relayState);
}




/* Attributes Implementations */

/* relayState */
#define LassoLogoutRequest_get_relayState LassoLogoutRequest_relayState_get
xmlChar *LassoLogoutRequest_relayState_get(LassoLogoutRequest *self) {
	return NULL; /* FIXME */
}
#define LassoLogoutRequest_set_relayState LassoLogoutRequest_relayState_set
void LassoLogoutRequest_relayState_set(LassoLogoutRequest *self, xmlChar *relayState) {
	 lasso_lib_logout_request_set_relayState(LASSO_LIB_LOGOUT_REQUEST(self), relayState);
}




/* Attributes implementations */

/* providerId */
#define LassoServer_get_providerId LassoServer_providerId_get
gchar *LassoServer_providerId_get(LassoServer *self) {
	return self->providerID;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoServer lasso_server_new
#define delete_LassoServer lasso_server_destroy
#ifdef PHP_VERSION
#define LassoServer_newFromDump lasso_server_new_from_dump
#else
#define Server_newFromDump lasso_server_new_from_dump
#endif

/* Methods implementations */

#define LassoServer_addProvider lasso_server_add_provider
#define LassoServer_dump lasso_server_dump




/* Attributes implementations */

/* isDirty */
#define LassoIdentity_get_isDirty LassoIdentity_isDirty_get
gboolean LassoIdentity_isDirty_get(LassoIdentity *self) {
	return self->is_dirty;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoIdentity lasso_identity_new
#define delete_LassoIdentity lasso_identity_destroy
#ifdef PHP_VERSION
#define LassoIdentity_newFromDump lasso_identity_new_from_dump
#else
#define Identity_newFromDump lasso_identity_new_from_dump
#endif

/* Methods implementations */

#define LassoIdentity_dump lasso_identity_dump




/* Attributes implementations */

/* isDirty */
#define LassoSession_get_isDirty LassoSession_isDirty_get
gboolean LassoSession_isDirty_get(LassoSession *self) {
	return self->is_dirty;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoSession lasso_session_new
#define delete_LassoSession lasso_session_destroy
#ifdef PHP_VERSION
#define LassoSession_newFromDump lasso_session_new_from_dump
#else
#define Session_newFromDump lasso_session_new_from_dump
#endif

/* Methods implementations */

#define LassoSession_dump lasso_session_dump
#define LassoSession_getAuthenticationMethod lasso_session_get_authentication_method




/* Attributes inherited from LassoProfile implementations */

/* identity */
#define LassoDefederation_get_identity LassoDefederation_identity_get
LassoIdentity *LassoDefederation_identity_get(LassoDefederation *self) {
	return lasso_profile_get_identity(LASSO_PROFILE(self));
}
#define LassoDefederation_set_identity LassoDefederation_identity_set
gint LassoDefederation_identity_set(LassoDefederation *self, LassoIdentity *identity) {
	return lasso_profile_set_identity(LASSO_PROFILE(self), identity);
}

/* isIdentityDirty */
#define LassoDefederation_get_isIdentityDirty LassoDefederation_isIdentityDirty_get
gboolean LassoDefederation_isIdentityDirty_get(LassoDefederation *self) {
	return lasso_profile_is_identity_dirty(LASSO_PROFILE(self));
}

/* isSessionDirty */
#define LassoDefederation_get_isSessionDirty LassoDefederation_isSessionDirty_get
gboolean LassoDefederation_isSessionDirty_get(LassoDefederation *self) {
	return lasso_profile_is_session_dirty(LASSO_PROFILE(self));
}

/* msgBody */
#define LassoDefederation_get_msgBody LassoDefederation_msgBody_get
gchar *LassoDefederation_msgBody_get(LassoDefederation *self) {
	return LASSO_PROFILE(self)->msg_body;
}

/* msgRelayState */
#define LassoDefederation_get_msgRelayState LassoDefederation_msgRelayState_get
gchar *LassoDefederation_msgRelayState_get(LassoDefederation *self) {
	return LASSO_PROFILE(self)->msg_relayState;
}

/* msgUrl */
#define LassoDefederation_get_msgUrl LassoDefederation_msgUrl_get
gchar *LassoDefederation_msgUrl_get(LassoDefederation *self) {
	return LASSO_PROFILE(self)->msg_url;
}

/* nameIdentifier */
#define LassoDefederation_get_nameIdentifier LassoDefederation_nameIdentifier_get
gchar *LassoDefederation_nameIdentifier_get(LassoDefederation *self) {
	return LASSO_PROFILE(self)->nameIdentifier;
}

/* remoteProviderId */
#define LassoDefederation_get_remoteProviderId LassoDefederation_remoteProviderId_get
gchar *LassoDefederation_remoteProviderId_get(LassoDefederation *self) {
	return NULL; /* FIXME */
}
#define LassoDefederation_set_remoteProviderId LassoDefederation_remoteProviderId_set
void LassoDefederation_remoteProviderId_set(LassoDefederation *self, gchar *remoteProviderId) {
	lasso_profile_set_remote_providerID(LASSO_PROFILE(self), remoteProviderId);
}

/* request */
#define LassoDefederation_get_request LassoDefederation_request_get
LassoFederationTerminationNotification *LassoDefederation_request_get(LassoDefederation *self) {
	return LASSO_FEDERATION_TERMINATION_NOTIFICATION(LASSO_PROFILE(self)->request);
}

/* responseStatus */
#define LassoDefederation_get_responseStatus LassoDefederation_responseStatus_get
gchar *LassoDefederation_responseStatus_get(LassoDefederation *self) {
	return NULL; /* FIXME */
}
#define LassoDefederation_set_responseStatus LassoDefederation_responseStatus_set
void LassoDefederation_responseStatus_set(LassoDefederation *self, gchar *responseStatus) {
	lasso_profile_set_response_status(LASSO_PROFILE(self), responseStatus);
}

/* session */
#define LassoDefederation_get_session LassoDefederation_session_get
LassoSession *LassoDefederation_session_get(LassoDefederation *self) {
	return lasso_profile_get_session(LASSO_PROFILE(self));
}
#define LassoDefederation_set_session LassoDefederation_session_set
gint LassoDefederation_session_set(LassoDefederation *self, LassoSession *session) {
	return lasso_profile_set_session(LASSO_PROFILE(self), session);
}

/* Constructors, destructors & static methods implementations */

#define new_LassoDefederation lasso_defederation_new
#define delete_LassoDefederation lasso_defederation_destroy

/* Methods inherited from LassoProfile implementations */

gint LassoDefederation_setIdentityFromDump(LassoDefederation *self, gchar *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

gint LassoDefederation_setSessionFromDump(LassoDefederation *self, gchar *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoDefederation_buildNotificationMsg lasso_defederation_build_notification_msg
#define LassoDefederation_initNotification lasso_defederation_init_notification
#define LassoDefederation_processNotificationMsg lasso_defederation_process_notification_msg
#define LassoDefederation_validateNotification lasso_defederation_validate_notification




/* Attributes inherited from LassoProfile implementations */

/* authnRequest */
#define LassoLogin_get_authnRequest LassoLogin_authnRequest_get
LassoAuthnRequest *LassoLogin_authnRequest_get(LassoLogin *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->request_type == lassoMessageTypeAuthnRequest)
		return LASSO_AUTHN_REQUEST(profile->request);
	else
		return NULL;
}

/* authnResponse */
#define LassoLogin_get_authnResponse LassoLogin_authnResponse_get
LassoAuthnResponse *LassoLogin_authnResponse_get(LassoLogin *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->response_type == lassoMessageTypeAuthnResponse)
		return LASSO_AUTHN_RESPONSE(profile->response);
	else
		return NULL;
}

/* identity */
#define LassoLogin_get_identity LassoLogin_identity_get
LassoIdentity *LassoLogin_identity_get(LassoLogin *self) {
	return lasso_profile_get_identity(LASSO_PROFILE(self));
}
#define LassoLogin_set_identity LassoLogin_identity_set
gint LassoLogin_identity_set(LassoLogin *self, LassoIdentity *identity) {
	return lasso_profile_set_identity(LASSO_PROFILE(self), identity);
}

/* isIdentityDirty */
#define LassoLogin_get_isIdentityDirty LassoLogin_isIdentityDirty_get
gboolean LassoLogin_isIdentityDirty_get(LassoLogin *self) {
	return lasso_profile_is_identity_dirty(LASSO_PROFILE(self));
}

/* isSessionDirty */
#define LassoLogin_get_isSessionDirty LassoLogin_isSessionDirty_get
gboolean LassoLogin_isSessionDirty_get(LassoLogin *self) {
	return lasso_profile_is_session_dirty(LASSO_PROFILE(self));
}

/* msgBody */
#define LassoLogin_get_msgBody LassoLogin_msgBody_get
gchar *LassoLogin_msgBody_get(LassoLogin *self) {
	return LASSO_PROFILE(self)->msg_body;
}

/* msgRelayState */
#define LassoLogin_get_msgRelayState LassoLogin_msgRelayState_get
gchar *LassoLogin_msgRelayState_get(LassoLogin *self) {
	return LASSO_PROFILE(self)->msg_relayState;
}

/* msgUrl */
#define LassoLogin_get_msgUrl LassoLogin_msgUrl_get
gchar *LassoLogin_msgUrl_get(LassoLogin *self) {
	return LASSO_PROFILE(self)->msg_url;
}

/* nameIdentifier */
#define LassoLogin_get_nameIdentifier LassoLogin_nameIdentifier_get
gchar *LassoLogin_nameIdentifier_get(LassoLogin *self) {
	return LASSO_PROFILE(self)->nameIdentifier;
}

/* remoteProviderId */
#define LassoLogin_get_remoteProviderId LassoLogin_remoteProviderId_get
gchar *LassoLogin_remoteProviderId_get(LassoLogin *self) {
	return NULL; /* FIXME */
}
#define LassoLogin_set_remoteProviderId LassoLogin_remoteProviderId_set
void LassoLogin_remoteProviderId_set(LassoLogin *self, gchar *remoteProviderId) {
	lasso_profile_set_remote_providerID(LASSO_PROFILE(self), remoteProviderId);
}

/* request */
#define LassoLogin_get_request LassoLogin_request_get
LassoRequest *LassoLogin_request_get(LassoLogin *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->request_type == lassoMessageTypeRequest)
		return LASSO_REQUEST(profile->request);
	else
		return NULL;
}

/* response */
#define LassoLogin_get_response LassoLogin_response_get
LassoResponse *LassoLogin_response_get(LassoLogin *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->response_type == lassoMessageTypeResponse)
		return LASSO_RESPONSE(profile->response);
	else
		return NULL;
}

/* responseStatus */
#define LassoLogin_get_responseStatus LassoLogin_responseStatus_get
gchar *LassoLogin_responseStatus_get(LassoLogin *self) {
	return NULL; /* FIXME */
}
#define LassoLogin_set_responseStatus LassoLogin_responseStatus_set
void LassoLogin_responseStatus_set(LassoLogin *self, gchar *responseStatus) {
	lasso_profile_set_response_status(LASSO_PROFILE(self), responseStatus);
}

/* session */
#define LassoLogin_get_session LassoLogin_session_get
LassoSession *LassoLogin_session_get(LassoLogin *self) {
	return lasso_profile_get_session(LASSO_PROFILE(self));
}
#define LassoLogin_set_session LassoLogin_session_set
gint LassoLogin_session_set(LassoLogin *self, LassoSession *session) {
	return lasso_profile_set_session(LASSO_PROFILE(self), session);
}

/* Attributes from LassoLogin implementations */

/* assertion */
#define LassoLogin_get_assertion LassoLogin_assertion_get
LassoAssertion *LassoLogin_assertion_get(LassoLogin *self) {
	return lasso_login_get_assertion(self);
}
#define LassoLogin_set_assertion LassoLogin_assertion_set
gint LassoLogin_assertion_set(LassoLogin *self, LassoAssertion *assertion) {
	return lasso_login_set_assertion(self, assertion);
}

/* Constructors, destructors & static methods implementations */

#define new_LassoLogin lasso_login_new
#define delete_LassoLogin lasso_login_destroy
#ifdef PHP_VERSION
#define LassoLogin_newFromDump lasso_login_new_from_dump
#else
#define Login_newFromDump lasso_login_new_from_dump
#endif

/* Methods inherited from LassoProfile implementations */

gint LassoLogin_setIdentityFromDump(LassoLogin *self, gchar *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

gint LassoLogin_setSessionFromDump(LassoLogin *self, gchar *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods */

/* assertion */
gint LassoLogin_setAssertionFromDump(LassoLogin *self, gchar *dump) {
	return lasso_login_set_assertion_from_dump(self, dump);
}

/* Methods implementations */

#define LassoLogin_acceptSso lasso_login_accept_sso
#define LassoLogin_buildArtifactMsg lasso_login_build_artifact_msg
#define LassoLogin_buildAuthnRequestMsg lasso_login_build_authn_request_msg
#define LassoLogin_buildAuthnResponseMsg lasso_login_build_authn_response_msg
#define LassoLogin_buildRequestMsg lasso_login_build_request_msg
#define LassoLogin_buildResponseMsg lasso_login_build_response_msg
#define LassoLogin_dump lasso_login_dump
#define LassoLogin_initAuthnRequest lasso_login_init_authn_request
#define LassoLogin_initFromAuthnRequestMsg lasso_login_init_from_authn_request_msg
#define LassoLogin_initRequest lasso_login_init_request
#define LassoLogin_mustAuthenticate lasso_login_must_authenticate
#define LassoLogin_processAuthnResponseMsg lasso_login_process_authn_response_msg
#define LassoLogin_processRequestMsg lasso_login_process_request_msg
#define LassoLogin_processResponseMsg lasso_login_process_response_msg




/* Attributes inherited from LassoProfile implementations */

/* identity */
#define LassoLogout_get_identity LassoLogout_identity_get
LassoIdentity *LassoLogout_identity_get(LassoLogout *self) {
	return lasso_profile_get_identity(LASSO_PROFILE(self));
}
#define LassoLogout_set_identity LassoLogout_identity_set
gint LassoLogout_identity_set(LassoLogout *self, LassoIdentity *identity) {
	return lasso_profile_set_identity(LASSO_PROFILE(self), identity);
}

/* isIdentityDirty */
#define LassoLogout_get_isIdentityDirty LassoLogout_isIdentityDirty_get
gboolean LassoLogout_isIdentityDirty_get(LassoLogout *self) {
	return lasso_profile_is_identity_dirty(LASSO_PROFILE(self));
}

/* isSessionDirty */
#define LassoLogout_get_isSessionDirty LassoLogout_isSessionDirty_get
gboolean LassoLogout_isSessionDirty_get(LassoLogout *self) {
	return lasso_profile_is_session_dirty(LASSO_PROFILE(self));
}

/* msgBody */
#define LassoLogout_get_msgBody LassoLogout_msgBody_get
gchar *LassoLogout_msgBody_get(LassoLogout *self) {
	return LASSO_PROFILE(self)->msg_body;
}

/* msgRelayState */
#define LassoLogout_get_msgRelayState LassoLogout_msgRelayState_get
gchar *LassoLogout_msgRelayState_get(LassoLogout *self) {
	return LASSO_PROFILE(self)->msg_relayState;
}

/* msgUrl */
#define LassoLogout_get_msgUrl LassoLogout_msgUrl_get
gchar *LassoLogout_msgUrl_get(LassoLogout *self) {
	return LASSO_PROFILE(self)->msg_url;
}

/* nameIdentifier */
#define LassoLogout_get_nameIdentifier LassoLogout_nameIdentifier_get
gchar *LassoLogout_nameIdentifier_get(LassoLogout *self) {
	return LASSO_PROFILE(self)->nameIdentifier;
}

/* remoteProviderId */
#define LassoLogout_get_remoteProviderId LassoLogout_remoteProviderId_get
gchar *LassoLogout_remoteProviderId_get(LassoLogout *self) {
	return NULL; /* FIXME */
}
#define LassoLogout_set_remoteProviderId LassoLogout_remoteProviderId_set
void LassoLogout_remoteProviderId_set(LassoLogout *self, gchar *remoteProviderId) {
	lasso_profile_set_remote_providerID(LASSO_PROFILE(self), remoteProviderId);
}

/* request */
#define LassoLogout_get_request LassoLogout_request_get
LassoLogoutRequest *LassoLogout_request_get(LassoLogout *self) {
	return LASSO_LOGOUT_REQUEST(LASSO_PROFILE(self)->request);
}

/* response */
#define LassoLogout_get_response LassoLogout_response_get
LassoLogoutResponse *LassoLogout_response_get(LassoLogout *self) {
	return LASSO_LOGOUT_RESPONSE(LASSO_PROFILE(self)->response);
}

/* responseStatus */
#define LassoLogout_get_responseStatus LassoLogout_responseStatus_get
gchar *LassoLogout_responseStatus_get(LassoLogout *self) {
	return NULL; /* FIXME */
}
#define LassoLogout_set_responseStatus LassoLogout_responseStatus_set
void LassoLogout_responseStatus_set(LassoLogout *self, gchar *responseStatus) {
	lasso_profile_set_response_status(LASSO_PROFILE(self), responseStatus);
}

/* session */
#define LassoLogout_get_session LassoLogout_session_get
LassoSession *LassoLogout_session_get(LassoLogout *self) {
	return lasso_profile_get_session(LASSO_PROFILE(self));
}
#define LassoLogout_set_session LassoLogout_session_set
gint LassoLogout_session_set(LassoLogout *self, LassoSession *session) {
	return lasso_profile_set_session(LASSO_PROFILE(self), session);
}

/* Constructors, destructors & static methods implementations */

#define new_LassoLogout lasso_logout_new
#define delete_LassoLogout lasso_logout_destroy
#ifdef PHP_VERSION
#define LassoLogout_newFromDump lasso_logout_new_from_dump
#else
#define Logout_newFromDump lasso_logout_new_from_dump
#endif

/* Methods inherited from LassoProfile implementations */

gint LassoLogout_setIdentityFromDump(LassoLogout *self, gchar *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

gint LassoLogout_setSessionFromDump(LassoLogout *self, gchar *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLogout_buildRequestMsg lasso_logout_build_request_msg
#define LassoLogout_buildResponseMsg lasso_logout_build_response_msg
#define LassoLogout_dump lasso_logout_dump
#define LassoLogout_getNextProviderId lasso_logout_get_next_providerID
#define LassoLogout_initRequest lasso_logout_init_request
#define LassoLogout_processRequestMsg lasso_logout_process_request_msg
#define LassoLogout_processResponseMsg lasso_logout_process_response_msg
#define LassoLogout_resetProviderIdIndex lasso_logout_reset_providerID_index
#define LassoLogout_validateRequest lasso_logout_validate_request




/* Attributes inherited from LassoProfile implementations */

/* authnRequest */
#define LassoLecp_get_authnRequest LassoLecp_authnRequest_get
LassoAuthnRequest *LassoLecp_authnRequest_get(LassoLecp *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->request_type == lassoMessageTypeAuthnRequest)
		return LASSO_AUTHN_REQUEST(profile->request);
	else
		return NULL;
}

/* authnResponse */
#define LassoLecp_get_authnResponse LassoLecp_authnResponse_get
LassoAuthnResponse *LassoLecp_authnResponse_get(LassoLecp *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->response_type == lassoMessageTypeAuthnResponse)
		return LASSO_AUTHN_RESPONSE(profile->response);
	else
		return NULL;
}

/* identity */
#define LassoLecp_get_identity LassoLecp_identity_get
LassoIdentity *LassoLecp_identity_get(LassoLecp *self) {
	return lasso_profile_get_identity(LASSO_PROFILE(self));
}
#define LassoLecp_set_identity LassoLecp_identity_set
gint LassoLecp_identity_set(LassoLecp *self, LassoIdentity *identity) {
	return lasso_profile_set_identity(LASSO_PROFILE(self), identity);
}

/* isIdentityDirty */
#define LassoLecp_get_isIdentityDirty LassoLecp_isIdentityDirty_get
gboolean LassoLecp_isIdentityDirty_get(LassoLecp *self) {
	return lasso_profile_is_identity_dirty(LASSO_PROFILE(self));
}

/* isSessionDirty */
#define LassoLecp_get_isSessionDirty LassoLecp_isSessionDirty_get
gboolean LassoLecp_isSessionDirty_get(LassoLecp *self) {
	return lasso_profile_is_session_dirty(LASSO_PROFILE(self));
}

/* msgBody */
#define LassoLecp_get_msgBody LassoLecp_msgBody_get
gchar *LassoLecp_msgBody_get(LassoLecp *self) {
	return LASSO_PROFILE(self)->msg_body;
}

/* msgRelayState */
#define LassoLecp_get_msgRelayState LassoLecp_msgRelayState_get
gchar *LassoLecp_msgRelayState_get(LassoLecp *self) {
	return LASSO_PROFILE(self)->msg_relayState;
}

/* msgUrl */
#define LassoLecp_get_msgUrl LassoLecp_msgUrl_get
gchar *LassoLecp_msgUrl_get(LassoLecp *self) {
	return LASSO_PROFILE(self)->msg_url;
}

/* nameIdentifier */
#define LassoLecp_get_nameIdentifier LassoLecp_nameIdentifier_get
gchar *LassoLecp_nameIdentifier_get(LassoLecp *self) {
	return LASSO_PROFILE(self)->nameIdentifier;
}

/* remoteProviderId */
#define LassoLecp_get_remoteProviderId LassoLecp_remoteProviderId_get
gchar *LassoLecp_remoteProviderId_get(LassoLecp *self) {
	return NULL; /* FIXME */
}
#define LassoLecp_set_remoteProviderId LassoLecp_remoteProviderId_set
void LassoLecp_remoteProviderId_set(LassoLecp *self, gchar *remoteProviderId) {
	lasso_profile_set_remote_providerID(LASSO_PROFILE(self), remoteProviderId);
}

/* request */
#define LassoLecp_get_request LassoLecp_request_get
LassoRequest *LassoLecp_request_get(LassoLecp *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->request_type == lassoMessageTypeRequest)
		return LASSO_REQUEST(profile->request);
	else
		return NULL;
}

/* response */
#define LassoLecp_get_response LassoLecp_response_get
LassoResponse *LassoLecp_response_get(LassoLecp *self) {
	LassoProfile *profile = LASSO_PROFILE(self);
	if (profile->response_type == lassoMessageTypeResponse)
		return LASSO_RESPONSE(profile->response);
	else
		return NULL;
}

/* responseStatus */
#define LassoLecp_get_responseStatus LassoLecp_responseStatus_get
gchar *LassoLecp_responseStatus_get(LassoLecp *self) {
	return NULL; /* FIXME */
}
#define LassoLecp_set_responseStatus LassoLecp_responseStatus_set
void LassoLecp_responseStatus_set(LassoLecp *self, gchar *responseStatus) {
	lasso_profile_set_response_status(LASSO_PROFILE(self), responseStatus);
}

/* session */
#define LassoLecp_get_session LassoLecp_session_get
LassoSession *LassoLecp_session_get(LassoLecp *self) {
	return lasso_profile_get_session(LASSO_PROFILE(self));
}
#define LassoLecp_set_session LassoLecp_session_set
gint LassoLecp_session_set(LassoLecp *self, LassoSession *session) {
	return lasso_profile_set_session(LASSO_PROFILE(self), session);
}

/* Constructors, destructors & static methods implementations */

#define new_LassoLecp lasso_lecp_new
#define delete_LassoLecp lasso_lecp_destroy

/* Methods inherited from LassoProfile implementations */

gint LassoLecp_setIdentityFromDump(LassoLecp *self, gchar *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

gint LassoLecp_setSessionFromDump(LassoLecp *self, gchar *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLecp_buildAuthnRequestEnvelopeMsg lasso_lecp_build_authn_request_envelope_msg
#define LassoLecp_buildAuthnRequestMsg lasso_lecp_build_authn_request_msg
#define LassoLecp_buildAuthnResponseEnvelopeMsg lasso_lecp_build_authn_response_envelope_msg
#define LassoLecp_buildAuthnResponseMsg lasso_lecp_build_authn_response_msg
#define LassoLecp_initAuthnRequest lasso_lecp_init_authn_request
#define LassoLecp_initFromAuthnRequestMsg lasso_lecp_init_from_authn_request_msg
#define LassoLecp_processAuthnRequestEnvelopeMsg lasso_lecp_process_authn_request_envelope_msg
#define LassoLecp_processAuthnResponseEnvelopeMsg lasso_lecp_process_authn_response_envelope_msg



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_init(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lasso_init();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_shutdown(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lasso_shutdown();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1httpMethodAny(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoHttpMethodAny;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1httpMethodGet(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoHttpMethodGet;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1httpMethodPost(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoHttpMethodPost;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1httpMethodRedirect(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoHttpMethodRedirect;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1httpMethodSoap(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoHttpMethodSoap;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libConsentObtained(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:obtained";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libConsentUnavailable(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:unavailable";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libConsentInapplicable(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:liberty:consent:inapplicable";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libNameIdPolicyTypeNone(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "none";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libNameIdPolicyTypeOneTime(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "onetime";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libNameIdPolicyTypeFederated(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "federated";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libNameIdPolicyTypeAny(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "any";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileBrwsArt(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/brws-art";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileBrwsPost(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/brws-post";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileFedTermIdpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileFedTermIdpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileFedTermSpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileFedTermSpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/fedterm-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileRniIdpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileRniIdpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileRniSpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileRniSpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/rni-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileSloIdpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-idp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileSloIdpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-idp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileSloSpHttp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-sp-http";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1libProtocolProfileSloSpSoap(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "http://projectliberty.org/profiles/slo-sp-soap";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1loginProtocolProfileBrwsArt(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoLoginProtocolProfileBrwsArt;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1loginProtocolProfileBrwsPost(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoLoginProtocolProfileBrwsPost;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeNone(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeNone;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeAuthnRequest(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeAuthnRequest;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeAuthnResponse(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeAuthnResponse;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeRequest(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeRequest;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeResponse(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeResponse;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1messageTypeArtifact(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoMessageTypeArtifact;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1providerTypeNone(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoProviderTypeNone;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1providerTypeSp(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoProviderTypeSp;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1providerTypeIdp(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoProviderTypeIdp;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeInvalid(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeInvalid;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeLogin(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeLogin;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeLogout(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeLogout;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeDefederation(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeDefederation;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeRegisterNameIdentifier(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeRegisterNameIdentifier;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeNameIdentifierMapping(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeNameIdentifierMapping;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1requestTypeLecp(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoRequestTypeLecp;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodPassword(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:password";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodKerberos(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:1510";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodSecureRemotePassword(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:2945";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodHardwareToken(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodSmartcardPki(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:2246";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodSoftwarePki(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodPgp(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:PGP";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodSpki(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:SPKI";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodXkms(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:XKMS";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodXmlDsig(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:ietf:rfc:3075";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1samlAuthenticationMethodUnspecified(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "urn:oasis:names:tc:SAML:1.0:am:unspecified";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1signatureMethodRsaSha1(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoSignatureMethodRsaSha1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1signatureMethodDsaSha1(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)lassoSignatureMethodDsaSha1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1NODE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1NODE_1CONTENT_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -11;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1ATTR_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -12;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1XML_1ERROR_1ATTR_1VALUE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -13;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1TMPL_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -101;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1CONTEXT_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -102;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1PUBLIC_1KEY_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -103;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1PRIVATE_1KEY_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -104;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1CERTIFICATE_1LOAD_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -105;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -106;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -107;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1KEYS_1MNGR_1CREATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -108;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1KEYS_1MNGR_1INIT_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -109;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1SIGNATURE_1VERIFICATION_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -110;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1DS_1ERROR_1INVALID_1SIGNATURE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -111;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SERVER_1ERROR_1PROVIDER_1NOT_1FOUND(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -201;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1SERVER_1ERROR_1ADD_1PROVIDER_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -202;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LOGOUT_1ERROR_1UNSUPPORTED_1PROFILE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -301;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1INVALID_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -401;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PROFILE_1ERROR_1MISSING_1REQUEST(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -402;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PARAM_1ERROR_1BADTYPE_1OR_1NULL_1OBJ(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -501;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PARAM_1ERROR_1INVALID_1VALUE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -502;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1PARAM_1ERROR_1ERR_1CHECK_1FAILED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -503;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1ERROR_1UNDEFINED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) -999;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Assertion(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    char *arg1 ;
    char *arg2 ;
    LassoAssertion *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoAssertion *)new_LassoAssertion(arg1,arg2);
    
    *(LassoAssertion **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Assertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoAssertion *arg1 = (LassoAssertion *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAssertion **)&jarg1; 
    delete_LassoAssertion(arg1);
    
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Assertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAssertion *arg1 = (LassoAssertion *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAssertion **)&jarg1; 
    result = (char *)LassoAssertion_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1affiliationId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_affiliationId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1affiliationId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_affiliationId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1assertionConsumerServiceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_assertionConsumerServiceId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1assertionConsumerServiceId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_assertionConsumerServiceId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_consent(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1consent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_consent(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1forceAuthn(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    LassoAuthnRequest_set_forceAuthn(arg1,arg2);
    
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1forceAuthn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (bool)LassoAuthnRequest_get_forceAuthn(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1isPassive(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    arg2 = jarg2 ? true : false; 
    LassoAuthnRequest_set_isPassive(arg1,arg2);
    
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1isPassive(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (bool)LassoAuthnRequest_get_isPassive(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1nameIdPolicy(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_nameIdPolicy(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1nameIdPolicy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_nameIdPolicy(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_protocolProfile(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_protocolProfile(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_providerId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_providerId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1AuthnRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoAuthnRequest_set_relayState(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1AuthnRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoAuthnRequest *arg1 = (LassoAuthnRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoAuthnRequest **)&jarg1; 
    result = (char *)LassoAuthnRequest_get_relayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1LogoutRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogoutRequest *arg1 = (LassoLogoutRequest *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogoutRequest **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogoutRequest_set_relayState(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1LogoutRequest_1relayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogoutRequest *arg1 = (LassoLogoutRequest *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogoutRequest **)&jarg1; 
    result = (char *)LassoLogoutRequest_get_relayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Server_1providerId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_get_providerId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Server(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
    jlong jresult = 0 ;
    char *arg1 = (char *) NULL ;
    char *arg2 = (char *) NULL ;
    char *arg3 = (char *) NULL ;
    char *arg4 = (char *) NULL ;
    int arg5 = (int) lassoSignatureMethodRsaSha1 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = (int)jarg5; 
    result = (LassoServer *)new_LassoServer(arg1,arg2,arg3,arg4,(lassoSignatureMethod )arg5);
    
    *(LassoServer **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    delete_LassoServer(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    LassoServer *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoServer *)Server_newFromDump(arg1);
    
    *(LassoServer **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1addProvider(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 ;
    char *arg3 = (char *) NULL ;
    char *arg4 = (char *) NULL ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoServer_addProvider(arg1,arg2,arg3,arg4);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (char *)LassoServer_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Identity_1isDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    result = (bool)LassoIdentity_get_isDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Identity(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoIdentity *)new_LassoIdentity();
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    delete_LassoIdentity(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoIdentity *)Identity_newFromDump(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoIdentity *arg1 = (LassoIdentity *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoIdentity **)&jarg1; 
    result = (char *)LassoIdentity_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Session_1isDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    result = (bool)LassoSession_get_isDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Session(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    result = (LassoSession *)new_LassoSession();
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoSession *arg1 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    delete_LassoSession(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (LassoSession *)Session_newFromDump(arg1);
    
    *(LassoSession **)&jresult = result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    result = (char *)LassoSession_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1getAuthenticationMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    LassoSession *arg1 = (LassoSession *) 0 ;
    char *arg2 = (char *) NULL ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoSession **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)LassoSession_getAuthenticationMethod(arg1,arg2);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_getRequestTypeFromSoapMsg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jint jresult = 0 ;
    char *arg1 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (int)lasso_profile_get_request_type_from_soap_msg(arg1);
    
    jresult = (jint)result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoDefederation_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoIdentity *)LassoDefederation_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (bool)LassoDefederation_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (bool)LassoDefederation_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_nameIdentifier(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoDefederation_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (char *)LassoDefederation_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoFederationTerminationNotification *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoFederationTerminationNotification *)LassoDefederation_get_request(arg1);
    
    *(LassoFederationTerminationNotification **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Defederation_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoDefederation_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Defederation_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    result = (LassoSession *)LassoDefederation_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    int arg2 ;
    LassoDefederation *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (LassoDefederation *)new_LassoDefederation(arg1,(lassoProviderType )arg2);
    
    *(LassoDefederation **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    delete_LassoDefederation(arg1);
    
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoDefederation_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoDefederation_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1buildNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoDefederation_buildNotificationMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1initNotification(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 ;
    int arg3 = (int) lassoHttpMethodAny ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoDefederation_initNotification(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1processNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    char *arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoDefederation_processNotificationMsg(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1validateNotification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoDefederation *arg1 = (LassoDefederation *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoDefederation **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoDefederation_validateNotification(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1assertionArtifact(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *) ((arg1)->assertionArtifact);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1protocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (int) ((arg1)->protocolProfile);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1authnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoAuthnRequest *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoAuthnRequest *)LassoLogin_get_authnRequest(arg1);
    
    *(LassoAuthnRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1authnResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoAuthnResponse *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoAuthnResponse *)LassoLogin_get_authnResponse(arg1);
    
    *(LassoAuthnResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLogin_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoIdentity *)LassoLogin_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_nameIdentifier(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogin_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoRequest *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoRequest *)LassoLogin_get_request(arg1);
    
    *(LassoRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoResponse *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoResponse *)LassoLogin_get_response(arg1);
    
    *(LassoResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogin_set_responseStatus(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_get_responseStatus(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLogin_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoSession *)LassoLogin_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Login_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoAssertion *arg2 = (LassoAssertion *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = *(LassoAssertion **)&jarg2; 
    LassoLogin_set_assertion(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Login_1assertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    LassoAssertion *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (LassoAssertion *)LassoLogin_get_assertion(arg1);
    
    *(LassoAssertion **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoLogin *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoLogin *)new_LassoLogin(arg1);
    
    *(LassoLogin **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    delete_LassoLogin(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 ;
    LassoLogin *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoLogin *)Login_newFromDump(arg1,arg2);
    
    *(LassoLogin **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setAssertionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_setAssertionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1acceptSso(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogin_acceptSso(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildArtifactMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int arg2 ;
    char *arg3 ;
    char *arg4 ;
    int arg5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    arg5 = (int)jarg5; 
    {
        int errorCode;
        errorCode = LassoLogin_buildArtifactMsg(arg1,arg2,arg3,arg4,(lassoHttpMethod )arg5);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_buildAuthnRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int arg2 ;
    char *arg3 ;
    char *arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_buildAuthnResponseMsg(arg1,arg2,arg3,arg4);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogin_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogin_buildResponseMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (char *)LassoLogin_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        int errorCode;
        errorCode = LassoLogin_initAuthnRequest(arg1,(lassoHttpMethod )arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initFromAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLogin_initFromAuthnRequestMsg(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    int arg3 = (int) lassoHttpMethodRedirect ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLogin_initRequest(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1mustAuthenticate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    result = (bool)LassoLogin_mustAuthenticate(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_processAuthnResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_processRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogin *arg1 = (LassoLogin *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogin **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogin_processResponseMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLogout_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoIdentity *)LassoLogout_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (bool)LassoLogout_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (bool)LassoLogout_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_nameIdentifier(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogout_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoLogoutRequest *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoLogoutRequest *)LassoLogout_get_request(arg1);
    
    *(LassoLogoutRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoLogoutResponse *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoLogoutResponse *)LassoLogout_get_response(arg1);
    
    *(LassoLogoutResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLogout_set_responseStatus(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_get_responseStatus(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Logout_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLogout_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Logout_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (LassoSession *)LassoLogout_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    int arg2 ;
    LassoLogout *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    arg2 = (int)jarg2; 
    result = (LassoLogout *)new_LassoLogout(arg1,(lassoProviderType )arg2);
    
    *(LassoLogout **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    delete_LassoLogout(arg1);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    char *arg2 ;
    LassoLogout *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (LassoLogout *)Logout_newFromDump(arg1,arg2);
    
    *(LassoLogout **)&jresult = result; 
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogout_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLogout_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogout_buildRequestMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogout_buildResponseMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_dump(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1getNextProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    result = (char *)LassoLogout_getNextProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    xmlFree(result);
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 = (char *) NULL ;
    int arg3 = (int) lassoHttpMethodAny ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLogout_initRequest(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLogout_processRequestMsg(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    char *arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLogout_processResponseMsg(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1resetProviderIdIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogout_resetProviderIdIndex(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLogout *arg1 = (LassoLogout *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLogout **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLogout_validateRequest(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1authnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoAuthnRequest *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoAuthnRequest *)LassoLecp_get_authnRequest(arg1);
    
    *(LassoAuthnRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1authnResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoAuthnResponse *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoAuthnResponse *)LassoLecp_get_authnResponse(arg1);
    
    *(LassoAuthnResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoIdentity *arg2 = (LassoIdentity *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoIdentity **)&jarg2; 
    LassoLecp_set_identity(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoIdentity *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoIdentity *)LassoLecp_get_identity(arg1);
    
    *(LassoIdentity **)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1isIdentityDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (bool)LassoLecp_get_isIdentityDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1isSessionDirty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (bool)LassoLecp_get_isSessionDirty(arg1);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgBody(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgBody(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgRelayState(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgRelayState(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1msgUrl(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_msgUrl(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1nameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_nameIdentifier(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLecp_set_remoteProviderId(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1remoteProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_remoteProviderId(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1request(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoRequest *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoRequest *)LassoLecp_get_request(arg1);
    
    *(LassoRequest **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoResponse *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoResponse *)LassoLecp_get_response(arg1);
    
    *(LassoResponse **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    LassoLecp_set_responseStatus(arg1,arg2);
    
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1responseStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (char *)LassoLecp_get_responseStatus(arg1);
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_set_1Lecp_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSession *arg2 = (LassoSession *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = *(LassoSession **)&jarg2; 
    LassoLecp_set_session(arg1,arg2);
    
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_get_1Lecp_1session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    LassoSession *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    result = (LassoSession *)LassoLecp_get_session(arg1);
    
    *(LassoSession **)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    LassoServer *arg1 = (LassoServer *) 0 ;
    LassoLecp *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoServer **)&jarg1; 
    result = (LassoLecp *)new_LassoLecp(arg1);
    
    *(LassoLecp **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    delete_LassoLecp(arg1);
    
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_setIdentityFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_setSessionFromDump(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLecp_buildAuthnRequestEnvelopeMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_buildAuthnRequestMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    int arg2 ;
    char *arg3 ;
    char *arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_buildAuthnResponseEnvelopeMsg(arg1,arg2,arg3,arg4);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLecp_buildAuthnResponseMsg(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        int errorCode;
        errorCode = LassoLecp_initAuthnRequest(arg1);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1initFromAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    int arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (int)jarg3; 
    {
        int errorCode;
        errorCode = LassoLecp_initFromAuthnRequestMsg(arg1,arg2,(lassoHttpMethod )arg3);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_processAuthnRequestEnvelopeMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    LassoLecp *arg1 = (LassoLecp *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(LassoLecp **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        int errorCode;
        errorCode = LassoLecp_processAuthnResponseEnvelopeMsg(arg1,arg2);
        
        if (errorCode) {
            char errorMessage[256];
            sprintf(errorMessage, "%d / Lasso Error", errorCode);
            SWIG_exception(get_exception_type(errorCode), errorMessage);
        }
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


#ifdef __cplusplus
}
#endif

