/* -*-C-*-

$Id: ifmon.h,v 1.2 2003/07/08 03:26:38 cph Exp $

Copyright 2003 Massachusetts Institute of Technology

This file is part of autonet.

Autonet is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Autonet is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with autonet; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef AUTONET_IFMON_H
#define AUTONET_IFMON_H

#define IFMON_STATUS_INVALID	0x00
#define IFMON_STATUS_VALID	0x01
#define IFMON_STATUS_AVAILABLE	0x02
#define IFMON_STATUS_UP		0x04
#define IFMON_STATUS_CONNECTED	0x08
#define IFMON_STATUS_CONNVALID	0x10

typedef int ifmon_loop_t (void *);
typedef void ifmon_proc_t (void *, const char *, unsigned int, unsigned int);
typedef int ifmon_managed_t (void *, const char *);

extern int ifmon_use_old_mii_p;

extern int run_ifmon
  (ifmon_loop_t *, ifmon_proc_t *, ifmon_managed_t *, void *);

#endif /* not AUTONET_IFMON_H */
