

# Create LAMMPS input files this way:
cd moltemplate_files

  # run moltemplate

  moltemplate.sh -a "@atom:WatMW/mW 1" system.lt

  # Each atom type (eg "mW") must be assigned to an integer (because LAMMPS
  # does not understand descriptive names).  Normally LAMMPS does not care what
  # these numbers are, however many-body force-fields (used in this example)
  # are an exception.  Here we just want to make sure that the "mW" atom
  # type is assigned to number "1" so we use -a "@atom:WatMW/mW 1"
  # (The full-name of the atom is "WatMW/mW", not "mW", because it is part
  #  of the "WatMW" molecule-object.  See "watmw.lt" for details.)


  # This will generate various files with names ending in *.in* and *.data.
  # These files are the input files directly read by LAMMPS.  Move them to
  # the parent directory (or wherever you plan to run the simulation).

  mv -f system.in* system.data ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

cd ../
