/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: getversion.c,v 6.5 2002/12/11 19:15:11 jsquyres Exp $
 *
 *	Function:	- MPI library version
 *	Accepts:	- version (out)
 *			- sub version (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
   MPI_Get_version - obtain the version number of MPI that LAM/MPI supports

Output Parameters:
+ version - version number
- subversion - subversion number

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N WEB
@*/
int
MPI_Get_version(int *version, int *subversion)
{
	lam_initerr();
	lam_setfunc(BLKMPIGETVERSION);

	if (version == 0 || subversion == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGETVERSION, lam_mkerr(MPI_ERR_ARG, EINVAL)));
	}

	*version = MPI_VERSION;
	*subversion = MPI_SUBVERSION;
	
	lam_resetfunc(BLKMPIGETVERSION);
	return(MPI_SUCCESS);
}
