/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>

#include <ladcca/types.h>
#include <ladcca/internal.h>
#include <ladcca/xmalloc.h>
#include <ladcca/event.h>


cca_event_t *
cca_event_new ()
{
  cca_event_t * event;
  event = cca_malloc0 (sizeof (cca_event_t));
  uuid_clear (event->client_id);
  return event;
}

cca_event_t *
cca_event_new_with_type (enum CCA_Event_Type type)
{
  cca_event_t * event;
  event = cca_event_new ();
  cca_event_set_type (event, type);
  return event;
}

cca_event_t *
cca_event_new_with_all (enum CCA_Event_Type type, const char * string)
{
  cca_event_t * event;
  event = cca_event_new ();
  cca_event_set_type (event, type);
  cca_event_set_string (event, string);
  return event;
}

void
cca_event_free (cca_event_t * event)
{
  event->type = 0;
  cca_event_set_string  (event, NULL);
  cca_event_set_project (event, NULL);
}

void
cca_event_destroy (cca_event_t * event)
{
  cca_event_free (event);
  free (event);
}

enum CCA_Event_Type
cca_event_get_type (const cca_event_t * event)
{
  return event->type;
}

void
cca_event_set_type (cca_event_t * event, enum CCA_Event_Type type)
{
  event->type = type;
}

const char *
cca_event_get_string (const cca_event_t * event)
{
  return event->string;
}

void
cca_event_set_string (cca_event_t * event, const char * string)
{
  set_string_property (event->string, string);
}

const char *
cca_event_get_project (const cca_event_t *event)
{
  return event->project;
}

void
cca_event_set_project (cca_event_t *event, const char *project)
{
  set_string_property (event->project, project);
}

void
cca_event_get_client_id (const cca_event_t * event, uuid_t id)
{
  uuid_copy (id, event->client_id);
}

void
cca_event_set_client_id (cca_event_t * event, uuid_t id)
{
  uuid_copy (event->client_id, id);
}

void
cca_event_set_alsa_client_id (cca_event_t * event, unsigned char alsa_id)
{
  char id[2];
  
  cca_str_set_alsa_client_id (id, alsa_id);
  
  cca_event_set_type   (event, CCA_Alsa_Client_ID);
  cca_event_set_string (event, id);
}

unsigned char
cca_event_get_alsa_client_id (const cca_event_t * event)
{
  return cca_str_get_alsa_client_id (cca_event_get_string (event));
}

void
cca_str_set_alsa_client_id (char * str, unsigned char alsa_id)
{
  str[0] = (char) alsa_id;
  str[1] = '\0';
}

unsigned
char cca_str_get_alsa_client_id (const char * str)
{
  return (unsigned char) *str;
}


/* EOF */

