% lacme-accountd(1)
% [Guilhem Moulin](mailto:guilhem@fripost.org)
% March 2016

Name
====

lacme-accountd - [ACME] client written with process isolation and
minimal privileges in mind (account key manager)

Synopsis
========

`lacme-accountd` [`--config=FILENAME`] [`--privkey=ARG`] [`--socket=PATH`] [`--quiet`]

Description
===========

`lacme-accountd` is the account key manager component of [`lacme`(1)], a
small [ACME] client written with process isolation and minimal
privileges in mind.  No other [`lacme`(1)] component needs access to the
account key; in fact the account key could as well be stored on another
host or a smartcard.

`lacme-accountd` binds to a UNIX-domain socket (specified with
`--socket=`), which [ACME] clients can connect to in order to request
data signatures.
As a consequence, `lacme-accountd` needs to be up and running before
using [`lacme`(1)] to issue [ACME] commands.  Also, the process does not
automatically terminate after the last signature request: instead, one
sends an `INT` or `TERM` [`signal`(7)] to bring the server down.

Furthermore, one can use the UNIX-domain socket forwarding facility of
[OpenSSH] 6.7 and later to run `lacme-accountd` and [`lacme`(1)] on
different hosts.  For instance one could store the account key on a
machine that is not exposed to the internet.  See the
**[examples](#examples)** section below.

Options
=======

`--config=`*filename*

:   Use *filename* as configuration file.  See the **[configuration
    file](#configuration-file)** section below for the configuration
    options.

`--privkey=`*arg*

:   Specify the (private) account key to use for signing requests.
    Currently supported *arg*uments are:

    * `file:`*FILE*, to specify an encrypted private key (in PEM
      format); and
    * `gpg:`*FILE*, to specify a [`gpg`(1)]-encrypted private key (in
      PEM format).

    The following command can be used to generate a new 4096-bits RSA
    key in PEM format with mode 0600:

        openssl genrsa 4096 | install -m0600 /dev/stdin /path/to/priv.key

`-socket=`*path*

:   Use *path* as the UNIX-domain socket to bind against for signature
    requests from the [ACME] client.  `lacme-accountd` aborts if *path*
    exists or if its parent directory is writable by other users.

`-?`, `--help`

:   Display a brief help and exit.

`-q`, `--quiet`

:   Be quiet.

`--debug`

:   Turn on debug mode.

Configuration file
==================

If `--config=` is not given, `lacme-accountd` uses the first existing
configuration file among *./lacme-accountd.conf*,
*$XDG_CONFIG_HOME/lacme/lacme-accountd.conf* (or
*~/.config/lacme/lacme-accountd.conf* if the `XDG_CONFIG_HOME`
environment variable is not set), and */etc/lacme/lacme-accountd.conf*.

When given on the command line, the `--privkey=`, `--socket=` and
`--quiet` options take precedence over their counterpart (without
leading `--`) in the configuration file.  Valid options are:

*privkey*

:   See `--privkey=`.  This option is required when `--privkey=` is not
    specified on the command line.

*gpg*

:   For a [`gpg`(1)]-encrypted private account key, specify the binary
    [`gpg`(1)] to use, as well as some default options.
    Default: `gpg --quiet`.

*socket*

:   See `--socket=`.
    Default: *$XDG_RUNTIME_DIR/S.lacme* if the `XDG_RUNTIME_DIR`
    environment variable is set.

*quiet*

:   Be quiet. Possible values: `Yes`/`No`.

Examples
========

Run `lacme-accountd` in a first terminal:

    ~$ lacme-accountd --privkey=file:/path/to/priv.key --socket=/run/user/1000/S.lacme

Then, while `lacme-accountd` is running, execute locally [`lacme`(1)] in
another terminal:

    ~$ sudo lacme --socket=/run/user/1000/S.lacme new-cert

Alternatively, use [OpenSSH] 6.7 or later to forward the socket and
execute [`lacme`(1)] remotely:

    ~$ ssh -oExitOnForwardFailure=yes -tt -R /path/to/remote.sock:/run/user/1000/S.lacme user@example.org \
       sudo lacme --socket=/path/to/remote.sock new-cert

See also
========

[`lacme`(1)], [`ssh`(1)]

[ACME]: https://tools.ietf.org/html/draft-ietf-acme-acme-02
[`lacme`(1)]: lacme.1.html
[`signal`(7)]: http://linux.die.net/man/7/signal
[`gpg`(1)]: https://www.gnupg.org/documentation/manpage.en.html
[OpenSSH]: http://www.openssh.com/
[`ssh`(1)]: http://man.openbsd.org/ssh
