#ifndef WORKSHEET_H
#define WORKSHEET_H

#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include "MainWin.h"
#include "Plot.h"
#include "Label.h"
#include "Line.h"
#include "Rect.h"
#include "Ellipse.h"
#include "Image.h"

#define NR_PLOTS 16
#define NR_OBJECTS 10

class MainWin;

class Worksheet: public QWidget
{
	Q_OBJECT
private:
	MainWin *mw;					// reference to the main window (for plotlist & messages)
	class Plot *plot[NR_PLOTS];		// list of plots
	QPrinter *qprinter;				// printer for printing
	QString title;					// title of Worksheet
	bool title_enabled;
	QDateTime timestamp;			// time stamp
	bool timestamp_enabled;
	QColor bgcolor;
	Label *label[NR_OBJECTS];
	Line line[NR_OBJECTS];
	Rect rect[NR_OBJECTS];
	Ellipse ellipse[NR_OBJECTS];
	Image image[NR_OBJECTS];
	int X, Y;						// window dimension
	int lx, ly;						// temp. legend position
	int ax, ay, anumber;				// temp. axis position and axis number
	int tx, ty;						// temp. title position
	int bx, by;						// temp. border position
	int tlx, tly;						// temp. tic label position
	int tmagx, tmagy,tmagx2,tmagy2;	// temp. maglens position
	double tpanx, tpany;			// temp. pan zoom value (real data point)
	int linesx,linesy,lineex,lineey,labelx,labely,rectx,recty;
	int ellipsex,ellipsey,imagex,imagey;
	bool moving_cornerF1, moving_cornerF2;
	bool moving_cornerB1, moving_cornerB2;
	bool moving_borderx1, moving_borderx2;
	bool moving_bordery1, moving_bordery2;
	bool moving_center;
	int object_index;	// index of moving object
	int tmp_object_index;	// index when defining object
	unsigned int api, nr_plots;	// active plot index and number of plots
public:
	Worksheet(QWidget *parent, MainWin *mw, const char *name);
	MainWin *getMainWin() { return mw; }	// for project dialog
	void New();
	class Plot *getPlot(int i) { return plot[i]; }
	void newPlot(PType type);
	void deleteActivePlot();
	void updateWorksheetList();
	void Print(QString filename);
	void save(QTextStream *t);
	void open(QTextStream *t,int version, PType oldtype);
	void Export(QString filename, QString format);
	void ExportSVG();
	void ExportPIC();

	int getNrObjects() { return NR_OBJECTS; }
	Line getLine(int i) { return line[i]; }
	void setLine(int i, Line l) { line[i]=l; }
	Label *getLabel(int i) { return label[i]; }
	void setLabel(int i, Label *l) { label[i]=l; }
	Rect getRect(int i) { return rect[i]; }
	void setRect(int i, Rect r) { rect[i]=r; }
	Ellipse getEllipse(int i) { return ellipse[i]; }
	void setEllipse(int i, Ellipse e) { ellipse[i]=e; }
	Image getImage(int i) { return image[i]; }
	void setImage(int i, Image im) { image[i]=im; }

	// TODO : add to which plot ? -> check this
	void addGraph2D(Graph2D *g,PType type=P2D);
	void addGraph3D(Graph3D *g);
	void addGraphM(GraphM *g);
	void addGraphGRASS(GraphGRASS *g);
	void addGraphVTK(GraphVTK *g);
	void addGraph4D(Graph4D *g);
	
	int getAPI() { return api; }
	unsigned int getNrPlots() { return nr_plots; }

	QString getTitle() { return title; }
	void setTitle(QString t) { title = t; }
	bool getTitleEnabled() { return title_enabled; }
	void setTitleEnabled(bool e) { title_enabled = e; }
	void setBackground(QColor c) { bgcolor = c; }
	QColor Background() { return bgcolor; }
	QDateTime getTimeStamp() { return timestamp; }
	void setTimeStamp(QDateTime ts) { timestamp = ts; }
	bool getTimeStampEnabled() { return timestamp_enabled; }
	void setTimeStampEnabled(bool e) { timestamp_enabled = e; }

	void resetRanges();
protected:
	void resizeEvent( QResizeEvent * );
	void paintEvent( QPaintEvent * );
	void mousePressEvent( QMouseEvent *);
	void mouseReleaseEvent( QMouseEvent *);
	void mouseDoubleClickEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void closeEvent(QCloseEvent *);
	void Draw(QPainter *,int w, int h);
	double getXCoordinate(double x, double xmin, double xmax);
	double getYCoordinate(double y, double ymin, double ymax);
};

#endif //WORKSHEET
