//LabPlot : TitleDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qdatetime.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include "TitleDialog.h"

using namespace std;

TitleDialog::TitleDialog(Worksheet *p, const char *name)
	: Dialog(p, name)
{
	setCaption(i18n("Title Settings")+i18n(" : ")+QString(name));

	title = p->getPlot(p->getAPI())->getTitle();

	rtw = new RichTextWidget((QWidget *)vbox,title,0);

	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	
	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

void TitleDialog::apply_clicked() {
	
	title = rtw->label();
	
	p->updateWorksheetList();
	p->repaint();
}

void TitleDialog::ok_clicked() {
	apply_clicked();
	accept();	
}
