//LabPlot : SmoothListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include "SmoothListDialog.h"

SmoothListDialog::SmoothListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Smooth Dialog"));
	
	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Smooth over n points :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nle = new KLineEdit(QString("3"),hb);
	nle->setValidator(new QIntValidator(nle));

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void SmoothListDialog::apply_clicked() {
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/18);

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);
	
	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->getData();

		// do the smooth
		int n = (nle->text()).toInt();
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx-n;i++) {
			double x = a[(int) (i+n/2)].X();
			double y = 0;
			for (int j=0;j<n;j++) {
				y+=a[i+j].Y();
			}
			y = y/n;

			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("smooth (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
		Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,g->Number()-n);
		p->addGraph2D(ng);	
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();
}
