//LabPlot : ProjectDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "ProjectDialog.h"

using namespace std;

ProjectDialog::ProjectDialog(Worksheet *p, const char *name)
	: Dialog(p, name),mw(p->getMainWin())
{
	setCaption(i18n("Project Settings"));

	project = mw->getProject();

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("file name : "),hb);
	new QLabel(project->Filename(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("project version : "),hb);
	new QLabel(QString::number(project->Version()),hb);
	new QLabel(i18n(" LabPlot version : "),hb);
	new QLabel(project->LabPlot(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("title : "),hb);
	titlele = new KLineEdit(project->Title(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("author : "),hb);
	authorle = new KLineEdit(project->Author(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("created : "),hb);
	new QLabel(i18n(project->Created().toString()),hb);
	new QLabel(i18n(" last modified : "),hb);
	new QLabel(i18n(project->Modified().toString()),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n(" comment : "),hb);
	commentle = new KLineEdit(project->Comment(),hb);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

void ProjectDialog::apply_clicked() {
	project->setTitle(titlele->text());
	project->setAuthor(authorle->text());
	project->setComment(commentle->text());

	mw->setProject(project);
}
