//LabPlot : PlotSettingsDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "PlotSettingsDialog.h"
#include "Plot2DSurface.h"

//! for general plot settings
PlotSettingsDialog::PlotSettingsDialog(Worksheet *p, const char *name)
	: Dialog(p, name)
{
	plot = p->getPlot(p->getAPI());
	type = plot->getType();
	setCaption(i18n("Plot Settings")+i18n(" : ")+QString(name));

	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
	QHBox *hb = new QHBox(gb);
	new QLabel(i18n("Plot Position : "),hb);
	posx = new KLineEdit(QString::number(plot->getPosition().X()),hb);
	posx->setValidator(new QDoubleValidator(0,1,3,posx));
	new QLabel(i18n(" , "),hb);
	posy = new KLineEdit(QString::number(plot->getPosition().Y()),hb);
	posy->setValidator(new QDoubleValidator(0,1,3,posy));
	hb = new QHBox(gb);
	new QLabel(i18n("Plot Size : "),hb);
	sizex = new KLineEdit(QString::number(plot->getSize().X()),hb);
	sizex->setValidator(new QDoubleValidator(0,1,3,sizex));
	new QLabel(i18n(" , "),hb);
	sizey = new KLineEdit(QString::number(plot->getSize().Y()),hb);
	sizey->setValidator(new QDoubleValidator(0,1,3,sizey));

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Ranges"),vbox);
	hb = new QHBox(gb);
	KPushButton *asx = new KPushButton(i18n("Autoscale x"),hb);
	QObject::connect(asx,SIGNAL(clicked()),SLOT(autoscalex()));
	KPushButton *asy = new KPushButton(i18n("Autoscale y"),hb);
	QObject::connect(asy,SIGNAL(clicked()),SLOT(autoscaley()));
	if (type == P3D) {
		KPushButton *asz = new KPushButton(i18n("Autoscale z"),hb);
		QObject::connect(asz,SIGNAL(clicked()),SLOT(autoscalez()));
	}
	LRange *r = plot->getActRanges();
	hb = new QHBox(gb);
	new QLabel(i18n("x = "),hb);
	xmin = new KLineEdit(QString::number(r[0].Min()),hb);
	xmin->setValidator(new QDoubleValidator(xmin));
	new QLabel(i18n(" .. "),hb);
	xmax = new KLineEdit(QString::number(r[0].Max()),hb);
	xmax->setValidator(new QDoubleValidator(xmax));
	hb = new QHBox(gb);
	new QLabel(i18n("y = "),hb);
	ymin = new KLineEdit(QString::number(r[1].Min()),hb);
	ymin->setValidator(new QDoubleValidator(ymin));
	new QLabel(i18n(" .. "),hb);
	ymax = new KLineEdit(QString::number(r[1].Max()),hb);
	ymax->setValidator(new QDoubleValidator(ymax));

	if (type == P3D) {
		hb = new QHBox(gb);
		new QLabel(i18n("z = "),hb);
		zmin = new KLineEdit(QString::number(r[2].Min()),hb);
		zmin->setValidator(new QDoubleValidator(zmin));
		new QLabel(i18n(" .. "),hb);
		zmax = new KLineEdit(QString::number(r[2].Max()),hb);
		zmax->setValidator(new QDoubleValidator(zmax));

	}

	hb = new QHBox(gb);
	new QLabel(i18n("clipping offset : "),hb);
	cliple = new KLineEdit(QString::number(plot->getClipOffset()),hb);
	cliple->setValidator(new QIntValidator(cliple));

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
	hb = new QHBox(gb);
	transparentcb = new QCheckBox(i18n("transparent plot"),hb);
	transparentcb->setChecked(plot->getTransparent());

	hb = new QHBox(gb);
	new QLabel(i18n("Background Color : "),hb);
	bgcolor = new KColorButton(plot->Background(),hb);

	hb = new QHBox(gb);
	new QLabel(i18n("Graph Background Color : "),hb);
	gbgcolor = new KColorButton(plot->graphBackground(),hb);

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString(""),vbox);
	hb = new QHBox(gb);
	baselinecb = new QCheckBox(i18n("draw Baseline "),hb);
	baselinecb->setChecked(plot->baselineEnabled());
	new QLabel(i18n("Baseline @ y = "),hb);
	baselinele = new KLineEdit(QString::number(plot->Baseline()),hb);
	baselinele->setValidator(new QDoubleValidator(baselinele));

	hb = new QHBox(gb);
	regioncb = new QCheckBox(i18n("draw Region "),hb);
	regioncb->setChecked(plot->regionEnabled());
	new QLabel(i18n("x = "),hb);
	regionminle = new KLineEdit(QString::number(plot->getRegionMin()),hb);
	regionminle->setValidator(new QDoubleValidator(regionminle));
	new QLabel(i18n(" .. "),hb);
	regionmaxle = new KLineEdit(QString::number(plot->getRegionMax()),hb);
	regionmaxle->setValidator(new QDoubleValidator(regionmaxle));

	if (type == PSURFACE) {
		// TODO
		//surfaceStyle();
	}
	else {
		// TODO : simpleStyle(...); ?
	}

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

void PlotSettingsDialog::apply_clicked() {
	plot->setPosition(posx->text().toDouble(),posy->text().toDouble());
	plot->setSize(sizex->text().toDouble(),sizey->text().toDouble());

	plot->setBackground(bgcolor->color());
	plot->setGraphBackground(gbgcolor->color());
	plot->setTransparent(transparentcb->isChecked());
	plot->setClipOffset(cliple->text().toInt());
	plot->setXRange(xmin->text().toDouble(),xmax->text().toDouble());
	plot->setYRange(ymin->text().toDouble(),ymax->text().toDouble());
	if (type == P3D)
		plot->setZRange(zmin->text().toDouble(),zmax->text().toDouble());

	if (type == PSURFACE) {
		((Plot2DSurface * )plot)->enableDensity(dcb->isChecked());
		((Plot2DSurface * )plot)->enableContour(ccb->isChecked());
		((Plot2DSurface * )plot)->setNumber(numberle->text().toInt());
		((Plot2DSurface * )plot)->setPalette(pcb->currentItem());
	}

	plot->setBaseline(baselinele->text().toDouble());
	plot->setBaselineEnabled(baselinecb->isChecked());
	
	plot->setRegionMin(regionminle->text().toDouble());
	plot->setRegionMax(regionmaxle->text().toDouble());
	plot->setRegionEnabled(regioncb->isChecked());

	p->repaint();
}

void PlotSettingsDialog::autoscalex() { 
	plot->autoScaleX();
	LRange *r = plot->getRanges();
	xmin->setText(QString::number(r[0].Min()));
	xmax->setText(QString::number(r[0].Max()));
	p->repaint();
}
void PlotSettingsDialog::autoscaley() { 
	plot->autoScaleY();
	LRange *r = plot->getRanges();
	ymin->setText(QString::number(r[1].Min()));
	ymax->setText(QString::number(r[1].Max()));
	p->repaint();
}
void PlotSettingsDialog::autoscalez() { 
	plot->autoScaleZ();
	LRange *r = plot->getRanges();
	zmin->setText(QString::number(r[2].Min()));
	zmax->setText(QString::number(r[2].Max()));
	p->repaint();
}
