//LabPlot : IntegrationListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#ifdef HAVE_GSL
#endif
#include "IntegrationListDialog.h"

using namespace std;

IntegrationListDialog::IntegrationListDialog(Worksheet *p,const char *name)
	: ListDialog(p, name)
{
	setCaption(i18n("Integration Dialog"));

	Plot *plot = p->getPlot(p->getAPI());

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	regioncb = new QCheckBox(i18n("use Region "),hb);
	if(plot->getRegionMin() != plot->getRegionMax() )
		regioncb->setChecked(true);
	else
		regioncb->setChecked(false);
	new QLabel(i18n("( From "),hb);
	regionminle = new KLineEdit(QString::number(plot->getRegionMin()),hb);
	regionminle->setValidator(new QDoubleValidator(regionminle));
	new QLabel(i18n(" To "),hb);
	regionmaxle = new KLineEdit(QString::number(plot->getRegionMax()),hb);
	regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
	new QLabel(i18n(" )"),hb);

	hb = new QHBox(tab1);
	areacb = new QCheckBox(i18n("Sum absolute values (area)"),hb);
	areacb->setChecked(false);
	hb = new QHBox(tab1);
	baselinecb = new QCheckBox(i18n("Use Baseline @ y = "),hb);
	baselinecb->setChecked(false);
	baselinele = new KLineEdit(QString::number(plot->Baseline()),hb);
	baselinele->setValidator(new QDoubleValidator(baselinele));

	hb = new QHBox(tab1);
	addgraph = new QCheckBox(i18n("Add Graph"),hb);
	addgraph->setChecked(true);
	infocb = new QCheckBox(i18n("Show Info"),hb);
	infocb->setChecked(true);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	int sizex = vbox->minimumSizeHint().width();
	int sizey = vbox->minimumSizeHint().height()+gbox->minimumSizeHint().height()+
		tw->minimumSizeHint().height();
	setMinimumSize(sizex,sizey);
	resize(sizex,sizey);
}

void IntegrationListDialog::apply_clicked() {
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/18);

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);
	double sum=0, baseline = baselinele->text().toDouble();
	
	if (baselinecb->isChecked()) {
		p->getPlot(p->getAPI())->setBaseline(baseline);
	}
	
	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->getData();
		int n=0;

		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx-1;i++) {
			if (regioncb->isChecked() && 
				(a[i].X()<regionminle->text().toDouble() ||
				a[i+1].X()>regionmaxle->text().toDouble() )) {
				continue;
			}
			double y1 = a[i].Y(), y2 = a[i+1].Y();
			if (baselinecb->isChecked()) {
				y1 -= baseline;
				y2 -= baseline;
			}	
			double area = (y1+y2)/2.0*(a[i+1].X()-a[i].X());
			
			if (areacb->isChecked())
				sum += fabs(area);
			else
				sum += area;
			
			double x = (a[i].X()+a[i+1].X())/2;
			double y = sum;
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[n++].setPoint(x,y);
		}

		if (addgraph->isChecked()) {
			LRange range[2];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);

			QString fun = QString("integration of "+g->Label());

			Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color());
			Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),
				ssize->text().toInt(),(FType)symbolfillcb->currentItem(),sfcolor->color());
			Graph2D *ng = new Graph2D(fun,fun,range,P2D,style,symbol,ptr,n);
			p->addGraph2D(ng);
		}
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();

	QString info(" cummulative sum : "+QString::number(sum));
	if(baselinecb->isChecked())
		info += "\nwith baseline y = "+QString::number(baseline);
	if(regioncb->isChecked()) {
		double minx = regionminle->text().toDouble();
		double maxx = regionmaxle->text().toDouble();
		info += "\nwith region x = "+QString::number(minx)+
			" .. "+ QString::number(maxx);

		p->getPlot(p->getAPI())->setRegionMin(minx);
		p->getPlot(p->getAPI())->setRegionMax(maxx);
	}

	if (infocb->isChecked())
		KMessageBox::information(0,info);

}
