//LabPlot : Graph4D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph4D.h"

using namespace std;

Graph4D::Graph4D(QString n, QString l, LRange r[4],int t, Style st, 
		Symbol sy, Point4D *p, int nr,bool ty, bool s)
	: Graph(n,l,t,st,sy,nr,s)
{
	range = new LRange[4];
	if(r) {
		for(int i=0;i<4;i++) {
			range[i]=r[i];
		}
	}

	ptr = new Point4D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];
	
	gtype = ty;
}

void Graph4D::save(QTextStream *t) {
	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].Min()<<' '<<range[0].Max()<<' '<<range[1].Min()<<' '<<range[1].Max()<<' ';
	*t<<range[2].Min()<<' '<<range[2].Max()<<' '<<range[3].Min()<<' '<<range[4].Max()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< number;i++)
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<' '<<ptr[i].T()<<endl;
	*t<<gtype<<endl;
}

void Graph4D::open(QTextStream *t, int version) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1)
		*t>>name>>label>>number;
	else
		*t>>name>>number;

	double xmin, xmax, ymin, ymax, zmin, zmax, tmin, tmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax>>tmin>>tmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	range[3].setMin(tmin);
	range[3].setMax(tmax);
	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	double x, y, z, tt;
	ptr = new Point4D[number];
	for (int i=0;i< number;i++) {
		*t>>x>>y>>z>>tt;
		ptr[i].setPoint(x,y,z,tt);

		kdDebug()<<x<<' '<<y<<' '<<z<<' '<<tt<<endl;
	}
	*t>>tt;
	gtype = (bool)tt;
}

QStringList Graph4D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)		// only possible type
		t=i18n("2D");
	
	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");
	
	// TODO : bool gtype ???
	s << name << t << sh;
	s << QString::number(number) << QString::number(1);
	s << QString::number(range[0].Min()) + " .. " + QString::number(range[0].Max());
	s << QString::number(range[1].Min())+ " .. " + QString::number(range[1].Max());
	s << QString::number(range[2].Min())+ " .. " + QString::number(range[2].Max());
	s << QString::number(range[3].Min())+ " .. " + QString::number(range[3].Max());
	
	return s;
}
