//LabPlot : Graph3D.cc

#include <iostream>
#include <kdebug.h>
#include "Graph3D.h"

using namespace std;

Graph3D::Graph3D(QString n, QString l, LRange r[3],int t, Style st, 
		Symbol sy, Point3D *p, int nrx, int nry, bool b)
	: Graph(n,l,t,st,sy,nrx*nry,b)
{
	//kdDebug()<<"TYPE : "<<t<<endl;
	//kdDebug()<<"TYPE : "<<type<<endl;
	//kdDebug()<<"NAME : "<<name<<endl;

	range = new LRange[3];
	if(r) {
		for(int i=0;i<3;i++) {
			range[i]=r[i];
		}
	}
	numberx=nrx;
	numbery=nry;
	number=nrx*nry;

	ptr = new Point3D[number];
	for (int i=0;i<number;i++)
		ptr[i] = p[i];
}

void Graph3D::save(QTextStream *t) {
	saveGraph(t);
	*t<<numberx<<' '<<numbery<<endl;
       	*t<<range[0].Min()<<' '<<range[0].Max()<<' '<<range[1].Min()<<' '<<range[1].Max()<<' ';
	*t<<range[2].Min()<<' '<<range[2].Max()<<' '<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< numberx*numbery;i++) {
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Z()<<endl;
	}
}

void Graph3D::open(QTextStream *t, int version) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>numberx>>numbery;
	else if (version > 1)
		*t>>name>>label>>numberx>>numbery;
	else
		*t>>name>>numberx>>numbery;

	kdDebug()<<"Graph3D : "<<name<<' '<<label<<' '<<numberx<<' '<<numbery<<endl;

	number=numberx*numbery;

	double xmin, xmax, ymin, ymax, zmin, zmax;
	*t>>xmin>>xmax>>ymin>>ymax>>zmin>>zmax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);
	range[2].setMin(zmin);
	range[2].setMax(zmax);
	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	double x, y, z;
	ptr = new Point3D[numberx*numbery];
	for (int i=0;i< numberx*numbery;i++) {
		*t>>x>>y>>z;
		ptr[i].setPoint(x,y,z);

		kdDebug()<<x<<' '<<y<<' '<<z<<endl;
	}
}

QStringList Graph3D::Info(){
	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PTERNARY)
		t=i18n("Ternary");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(numberx) << QString::number(numbery);
	s << QString::number(range[0].Min()) + " .. " + QString::number(range[0].Max());
	s << QString::number(range[1].Min())+ " .. " + QString::number(range[1].Max());
	s << QString::number(range[2].Min())+ " .. " + QString::number(range[2].Max());
	
	return s;
}
