//LabPlot : Graph2D.cc

#include <iostream>
#include <qstringlist.h>
#include <qprogressdialog.h>
#include <kdebug.h>
#include "Graph2D.h"

using namespace std;

Graph2D::Graph2D(QString n, QString l,LRange r[2], int t, Style st,
		Symbol sy, Point *p, int nr,bool b)
	: Graph(n,l,t,st,sy,nr,b)
{

	range = new LRange[2];
	if (r) {
		for (int i=0;i<2;i++) {
			range[i].setMin(r[i].Min());
			range[i].setMax(r[i].Max());
		}
	}

	ptr = new Point[nr];
	for(int i=0;i<nr;i++)
		ptr[i] = p[i];
}

QStringList Graph2D::Info() 
{
	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PGRASS)
		t=i18n("GRASS");
	else if (type==PVTK)
		t=i18n("VTK");
	else if (type==PPIE)
		t=i18n("Pie");
	else if (type==PPOLAR)
		t=i18n("Polar");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");
	
	s << name << t << sh;
	s << QString::number(number);
	s << QString(" 1 ");		// only 1 column
	s << QString::number(range[0].Min()) + " .. " + QString::number(range[0].Max());
	s << QString::number(range[1].Min())+ " .. " + QString::number(range[1].Max());
/*	s << QString::number(style.Type()) << (style.Color()).name();
	s << QString::number(style.isFilled()) << (style.FillColor()).name();
	s << QString::number(symbol.getType()) << (symbol.getColor()).name();
	s << QString::number(symbol.getSize());
	s << QString::number(symbol.getFill()) << (symbol.getFillColor()).name() ;
*/
	return s;
}

void Graph2D::save(QTextStream *t) {
	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].Min()<<' '<<range[0].Max()<<' '<<range[1].Min()<<' '<<range[1].Max()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	//dump data
	for (int i=0;i< number;i++)
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<endl;
}

void Graph2D::open(QTextStream *t,int version) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1 )
		*t>>name>>label>>number;
	else	// version == 0
		*t>>name>>number;

	double xmin, xmax, ymin, ymax;
	*t>>xmin>>xmax>>ymin>>ymax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);

	// this belongs to openGraph() but the ranges are in between :-( 
	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read data
	double x, y;
	ptr = new Point[number];
	for (int i=0;i< number;i++) {
		*t>>x>>y;
		ptr[i].setPoint(x,y);
		//kdebug()<<x<<' '<<y<<endl;
	}
}
