//LabPlot : Dialog.cc

#include <iostream>
#include <qlabel.h>
#include <klocale.h>
#include <kdebug.h>
#include "Dialog.h"
#include "Plot2DSurface.h"

using namespace std;

Dialog::Dialog(Worksheet *p, const char *name)
	: KDialog((QWidget *)p, name), p(p)
{
	vbox = new QGroupBox(1,QGroupBox::Horizontal,QString(""),this);
	gbox = new QGroupBox(1, QGroupBox::Vertical, QString(""), this);

	ok = new KPushButton(i18n("OK"),gbox);
	apply = new KPushButton(i18n("Apply"),gbox);
	cancel = new KPushButton(i18n("Cancel"),gbox);
	QObject::connect(cancel,SIGNAL(clicked()),SLOT(reject()));
}

void Dialog::resizeEvent(QResizeEvent *e) {
	kdDebug()<<"Dialog::resizeEvent()\n";

	QSize s = e->size();
	gbox->setGeometry(0,s.height()-50,s.width(),50);
	vbox->setGeometry(0,0,s.width(),s.height()-50);
}

//! used from dialogs for surface plots
QVBox* Dialog::surfaceStyle(QTabWidget *tw) {
	QVBox *styletab = new QVBox(tw);

	Plot *tmpplot = p->getPlot(p->getAPI());
	Plot2DSurface *plot;
	if (tmpplot && tmpplot->getType() == PSURFACE)
		plot = (Plot2DSurface *)tmpplot;
	else
		plot = new Plot2DSurface(p);

	QHBox *hb = new QHBox(styletab);
	dcb = new QCheckBox(i18n("density"),hb);
	dcb->setChecked(plot->densityEnabled());
	ccb = new QCheckBox(i18n("contour"),hb);
	ccb->setChecked(plot->contourEnabled());

	hb = new QHBox(styletab);
	new QLabel(i18n("number of level : "),hb);
	int number = plot->getNumber();
	numberle = new KLineEdit(QString::number(number),hb);
	numberle->setValidator(new QIntValidator(numberle));
	numberle->setMaximumWidth(100);
	new QLabel(i18n("contour line color : "),hb);
	contourcolor = new KColorButton(plot->getContourColor(),hb);

	hb = new QHBox(styletab);
	new QLabel(i18n("Brush : "),hb);
	dbrushcb = new KComboBox(hb);
	fillBrushBox(dbrushcb,SRECT,Qt::blue,FFULL,Qt::red);
	dbrushcb->setCurrentItem(plot->getBrush());

	hb = new QHBox(styletab);
	coloredcb = new QCheckBox(i18n("colored contour lines"),hb);
	coloredcb->setChecked(plot->getColoredContour());
	meshcb = new QCheckBox(i18n("show mesh"),hb);
	meshcb->setChecked(plot->getMesh());
	relativecb = new QCheckBox(i18n("relative color scale"),hb);
	relativecb->setChecked(plot->getRelative());

	hb = new QHBox(styletab);
	new QLabel(i18n(" Threshold : "),hb);
	thresholdle = new KLineEdit(QString::number(plot->getThreshold()),hb);
	thresholdle->setValidator(new QDoubleValidator(thresholdle));
	thresholdle->setMaximumWidth(100);

	hb = new QHBox(styletab);
	new QLabel(i18n(" Color Palette : "),hb);
	//palabel->setAlignment(Qt::AlignHCenter);
	pcb = new KComboBox(hb);
	for (int j=0;j<21;j++) {		// all palettes
		QPainter pa;
		QPixmap pm(255,25);
		pa.begin(&pm);
		pm.fill(Qt::white);

		for (int i=0;i<255;i++) {
			pa.setPen(plot->getColor(i,j));
			pa.drawLine(i,0,i,25);
		}

		pa.end();
		pcb->insertItem(pm);
	}
	pcb->setCurrentItem(plot->getPalette());

	kdDebug()<<"OK"<<endl;
	return styletab;
}

//! used from dialogs for simple plots
QVBox* Dialog::simpleStyle(QTabWidget *tw, Graph *graph, Style *style, Symbol *symbol) {
	QVBox *styletab = new QVBox(tw);

	QHBox *hb = new QHBox(styletab);
	new QLabel(i18n("Graph Style : "),hb);
	cb2 = new KComboBox(hb);
	QStringList stylelist;
	stylelist<<i18n("Lines")<<i18n("NoCurve")<<i18n("Steps")<<i18n("Boxes")<<i18n("Impulses");
	cb2->insertStringList(stylelist);
	cb2->setCurrentItem(style->Type());

	hb = new QHBox(styletab);
	new QLabel(i18n("   Color : "),hb);
	color = new KColorButton(style->Color(),hb);
	QObject::connect(color,SIGNAL(changed(const QColor &)),this,SLOT(styleChanged()));
	hb = new QHBox(styletab);
	new QLabel(i18n(" Line Width : "),hb);
	widthle = new KLineEdit(QString::number(style->getWidth()),hb);
	widthle->setValidator(new QIntValidator(widthle));
	new QLabel(i18n(" Style : "),hb);
	pencb = new KComboBox(hb);
	QStringList penlist;
	penlist<<i18n("(No)")<<QString("-----")<<QString("- - -")<<QString("");
	penlist<<QString("---")<<QString("---");
	pencb->insertStringList(penlist);
	pencb->setCurrentItem(style->getPenStyle());

	hb = new QHBox(styletab);
	filled = new QCheckBox(i18n("Filled "),hb);
	filled->setChecked(style->isFilled());
	fcolor = new KColorButton(style->FillColor(),hb);
	QObject::connect(fcolor,SIGNAL(changed(const QColor &)),this,SLOT(styleChanged()));

	hb = new QHBox(styletab);
	new QLabel(i18n("    Brush : "),hb);
	brushcb = new KComboBox(hb);
	fillBrushBox(brushcb,SRECT,Qt::blue,FFULL,fcolor->color());
	brushcb->setCurrentItem(style->getBrush());

	hb = new QHBox(styletab);
	new QLabel(i18n("Graph Symbol : "),hb);
	symbolcb = new KComboBox(hb);
	fillSymbolBox(Qt::blue,FNONE,Qt::red,1);
	symbolcb->setCurrentItem(symbol->getType());
	QObject::connect(symbolcb,SIGNAL(activated(int)),this,SLOT(symbolChanged()));
	hb = new QHBox(styletab);
	new QLabel(i18n("    Color : "),hb);
	scolor = new KColorButton(symbol->getColor(),hb);
	QObject::connect(scolor,SIGNAL(changed(const QColor &)),this,SLOT(symbolChanged()));
	
	hb = new QHBox(styletab);
	new QLabel(i18n("    Size : "),hb);
	ssize = new KLineEdit(QString("5"),hb);
	ssize->setValidator(new QIntValidator(1,20,ssize));
	
	hb = new QHBox(styletab);
	new QLabel(i18n("    Fill : "),hb);
	symbolfillcb = new KComboBox(hb);
	fillSymbolFillBox(SRECT,Qt::blue,Qt::red,1);
	symbolfillcb->setCurrentItem(symbol->getFill());
	QObject::connect(symbolfillcb,SIGNAL(activated(int)),this,SLOT(symbolChanged()));
		
	ssize->setText(QString::number(symbol->getSize()));
	sfcolor = new KColorButton(symbol->getFillColor(),hb);
	QObject::connect(sfcolor,SIGNAL(changed(const QColor &)),this,SLOT(symbolChanged()));

	hb = new QHBox(styletab);
	new QLabel(i18n("    Brush : "),hb);
	sbrushcb = new KComboBox(hb);
	fillBrushBox(sbrushcb,SRECT,Qt::blue,FFULL,Qt::red);
	sbrushcb->setCurrentItem(symbol->getBrush());
	QObject::connect(sbrushcb,SIGNAL(activated(int)),this,SLOT(symbolChanged()));

	return styletab;
}

//! any style properties changed
void Dialog::styleChanged() {
	fillBrushBox(brushcb,SRECT,color->color(),FFULL,fcolor->color());
}
//! any symbol properties changed
void Dialog::symbolChanged() {
	fillSymbolBox(scolor->color(),(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	fillSymbolFillBox((SType)symbolcb->currentItem(),scolor->color(),sfcolor->color(),sbrushcb->currentItem());
	fillBrushBox(sbrushcb,(SType)symbolcb->currentItem(),scolor->color(),
		(FType)symbolfillcb->currentItem(),sfcolor->color());
}

QVBox* Dialog::annotateValuesTab(QTabWidget *tw, Graph *graph) {
	QVBox *annotatetab = new QVBox(tw);
	QStringList list;
	
	QHBox *hb = new QHBox(annotatetab);
	new QLabel(i18n("Type : "),hb);
	typecb = new KComboBox(hb);
	list<<i18n("None")<<i18n("x")<<i18n("y")<<i18n("z")<<i18n("x,y")<<i18n("x,y,z");
	typecb->insertStringList(list);
	if (graph)
		typecb->setCurrentItem(graph->getAnnotateValues().getType());

	hb = new QHBox(annotatetab);
	new QLabel(i18n("Position : "),hb);
	positioncb = new KComboBox(hb);
	list.clear();
	list<<i18n("top")<<i18n("bottom")<<i18n("left")<<i18n("right");
	positioncb->insertStringList(list);
	if (graph)
		positioncb->setCurrentItem(graph->getAnnotateValues().getPosition());

	hb = new QHBox(annotatetab);
	new QLabel(i18n("Distance : "),hb);
	QString distance("10");
	if (graph)
		distance=QString::number(graph->getAnnotateValues().getDistance());
	distancele = new KLineEdit(distance,hb);
	distancele->setValidator(new QIntValidator(0,100,ssize));
	
	return annotatetab;
}

void Dialog::fillBrushBox(KComboBox *cb, SType t, QColor c,FType f, QColor s) {
	int item = cb->currentItem();
	cb->clear();
	// Qt : number of different brush styles
	int BRUSHNR=15;
	for (int i=0;i<BRUSHNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );

		Symbol symbol((SType)t,c,10,f,s,i);
		symbol.draw(&pa,15,15);
		pa.end();
		
		cb->insertItem(pm);
	}
	cb->setCurrentItem(item);
}

//! fill the symbol combo box with all symbols
void Dialog::fillSymbolBox(QColor c, FType f, QColor s, int b) {
	int item = symbolcb->currentItem();
	symbolcb->clear();
	for (int i=0;i<SYMBOLNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		Symbol symbol((SType)i,c,10,f,s,b);
		symbol.draw(&pa,15,15);
		pa.end();
		
		symbolcb->insertItem(pm);
	}
	symbolcb->setCurrentItem(item);
}

//! fill the symbol combo box with all symbols
void Dialog::fillSymbolFillBox(SType t, QColor c, QColor s, int b) {
	int item = symbolfillcb->currentItem();
	symbolfillcb->clear();
	for (int i=0;i<SYMBOLFILLNR;i++) {
		QPainter pa;
		QPixmap pm( 30, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		Symbol symbol(t,c,10,(FType)i,s,b);
		symbol.draw(&pa,15,15);
		pa.end();
		
		symbolfillcb->insertItem(pm);
	}
	symbolfillcb->setCurrentItem(item);
}
