/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mysqlinterface.h"

mysqldatabase::mysqldatabase()
{
  quit=FALSE;
  oldmodelchecked=FALSE;
  databaseconnect=QSqlDatabase::addDatabase(DRIVER);
  //berprfen, ob Datenbank schon besteht.
  databaseconnect->setDatabaseName(DATABASE);
  databaseconnect->setUserName(USER);
  databaseconnect->setPassword(PASSWORD);
  databaseconnect->setHostName(HOST);
  passbox=NULL;
  while(!databaseconnect->open()&(!this->quit))//Check wether the database is opening or not
    {
      //Check if an old kmp3organizer database exists
      if(!oldmodelchecked)
        {
          cerr<<"trying to open old database"<<endl;
          databaseconnect->setDatabaseName(OLDDATABASE);
          databaseconnect->setUserName(OLDUSER);
          databaseconnect->setPassword(OLDPASSWORD);
          databaseconnect->setHostName(HOST);
          if(databaseconnect->open())
            {
              //old database exists
              //ask user,wether to import,or delete the old database
              if (!(QMessageBox::warning(0,i18n("Import old Database"),i18n("There is an old K-Yamo-Database existing.<br>Do you want to import, or delete it?"),"Delete",i18n("Import"),QString::null,1)))
                {
                  //create new database, than delete old one
                  databaseconnect->close();
                  createnewdb();
                  databaseconnect->setDatabaseName("mysql");
                  databaseconnect->setUserName(rootuser);
                  databaseconnect->setPassword(rootpass);
                  databaseconnect->setHostName("localhost");
                  if (databaseconnect->open())
                    {
                      QSqlQuery querystatement;
                      querystatement.exec ("drop database "OLDDATABASE";");
                      databaseconnect->close();
                    }
                  oldmodelchecked=TRUE;
                }
              else
                {
                  //create new database, than import old database into the new one
                  databaseconnect->close();
                  if (createnewdb())
                    {
                      //Import old database
                      if (importolddb())
                        {
                          oldmodelchecked=TRUE;
                          databaseconnect->setDatabaseName("mysql");
                          databaseconnect->setUserName(rootuser);
                          databaseconnect->setPassword(rootpass);
                          databaseconnect->setHostName("localhost");
                          if (databaseconnect->open())
                            {
                              QSqlQuery querystatement;
                              //If import was successfull, delete old database
                              querystatement.exec ("drop database "OLDDATABASE";");
                            }
                        }
                    }
                }
            }
          else
            oldmodelchecked=TRUE;
        }
      else
        {
          cout<<"No old database found"<<endl;
          createnewdb();
        }
      //set standard-connectionoptions, before next retry
      databaseconnect->setDatabaseName(DATABASE);
      databaseconnect->setUserName(USER);
      databaseconnect->setPassword(PASSWORD);
    }
}

mysqldatabase::~mysqldatabase()
{
  if (databaseconnect->isOpen())
    databaseconnect->close();
}

void mysqldatabase::fetchacountdata(QString user,QString pass)
{
  rootuser=user;
  rootpass=pass;
}

void mysqldatabase::abort()
{
  if (!(QMessageBox::warning(0,i18n("chancel"),i18n("Without MySQL the helper-database can not be used.<br><br>use K-Yamo without MYSQL or retry login?"),"&without MySQL",i18n("&try again"),QString::null,1)))
    {
      this->quit=TRUE;
    }

}

bool mysqldatabase::createnewdb()
{
  //Get accountdata for mysql from user, and create database with that accountdata
  if (!passbox)
    passbox=new passwordbox();
  connect (passbox,SIGNAL(success(QString, QString )),this,SLOT(fetchacountdata(QString,QString)));
  connect (passbox,SIGNAL(abort()),this,SLOT(abort()));
  passbox->exec();
  databaseconnect->setDatabaseName("mysql");
  databaseconnect->setUserName(rootuser);
  databaseconnect->setPassword(rootpass);
  databaseconnect->setHostName("localhost");
  if (databaseconnect->open())
    {
      QSqlQuery querystatement;
      querystatement.exec ("create database "DATABASE"");
      querystatement.exec("use "DATABASE"");
      //create all needed tables
      //create artiststable, if it doesn't exist already
      if (!(databaseconnect->tables().contains("artists")))
        querystatement.exec ("CREATE TABLE artists ("
                             "artistid BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,"
                             "artistname VARCHAR (80),"
                             "artistcountry VARCHAR (50),"
                             "PRIMARY KEY (artistid)"
                             ") TYPE=INNODB;");
      //create albumstable, if it doesn't exist already
      if (!(databaseconnect->tables().contains("albums")))
        querystatement.exec ("CREATE TABLE albums ("
                             "albumid BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,"
                             "albumname VARCHAR (80),"
                             "artist_id BIGINT UNSIGNED,"
                             "cdid VARCHAR (10),"
                             "releaseyear INT UNSIGNED,"
                             "PRIMARY KEY (albumid),"
                             "INDEX art_id(artist_id),"
                             "FOREIGN KEY (artist_id) REFERENCES artists (artistid) ON DELETE CASCADE"
                             ") TYPE=INNODB;");
      //create genrestable, if it doesn't exist already
      if (!(databaseconnect->tables().contains("genres")))
        querystatement.exec ("CREATE TABLE genres ("
                             "genreid BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,"
                             "genrename VARCHAR (80),"
                             "PRIMARY KEY (genreid)"
                             ") TYPE=INNODB;");
      //create trackstable, if it doesn't exist already
      if (!(databaseconnect->tables().contains("tracks")))
        querystatement.exec ("CREATE TABLE tracks ("
                             "trackid BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,"
                             "tracknumber INT,"
                             "trackname VARCHAR (80),"
                             "artist_id BIGINT UNSIGNED,"
                             "album_id BIGINT UNSIGNED,"
                             "genre_id BIGINT UNSIGNED,"
                             "PRIMARY KEY (trackid),"
                             "INDEX art_id(artist_id),"
                             "INDEX alb_id(album_id),"
                             "INDEX gen_id(genre_id),"
                             "FOREIGN KEY (artist_id) REFERENCES artists (artistid) ON DELETE CASCADE,"
                             "FOREIGN KEY (album_id) REFERENCES albums (albumid) ON DELETE CASCADE,"
                             "FOREIGN KEY (genre_id) REFERENCES genres (genreid) ON DELETE CASCADE"
                             ") TYPE=INNODB;");
      //set new loginaccount for the new database
      querystatement.exec("GRANT ALL PRIVILEGES ON "DATABASE".* TO "USER"@"HOST" IDENTIFIED BY \""PASSWORD"\"");
      querystatement.exec("FLUSH PRIVILEGES");
      //disconnect root-connection with mysql
      databaseconnect->close();
      return TRUE;
    }
  else
    return FALSE;
}

bool mysqldatabase::importolddb()
{
  bool importOk=FALSE;
  databaseconnect->setDatabaseName(OLDDATABASE);
  databaseconnect->setUserName(OLDUSER);
  databaseconnect->setPassword(OLDPASSWORD);
  databaseconnect->setHostName(HOST);
  if(databaseconnect->open())
    {
      //get most information out of old trackstable, than catch releaseyear and the genre out of albumstable
      //store everything in a field of i3tags, than enter the tags into the new database
      QPtrList<id3tag> taglist;
      taglist.setAutoDelete(TRUE);//delete tags, when list is deleted
      id3tag *current;
      QSqlCursor trackstable("tracks");
      trackstable.select();
      long counter=0;
      progressmainwindow *progresswindow=new progressmainwindow(FALSE);
      progresswindow->show();
      progressinfoonly *progress=progresswindow->startInfoOnly(i18n("Reading in old database"));
      while(trackstable.next())
        {
          QString infotext=QString(i18n("Importing tag number %1").arg(QString::number(++counter)));
          progress->setText(infotext);
          current=new id3tag();
          current->album=trackstable.value("albumname").toString();
          current->artist=trackstable.value("groupname").toString();
          current->titel=trackstable.value("trackname").toString();
          current->number=trackstable.value("tracknumber").toInt();
          QSqlCursor albumstable("albums");
          QString searchexpression=QString("albumname=\"%1\" AND groupname = \"%2\"").arg(current->album,current->artist);
          albumstable.select(searchexpression);
          albumstable.next();
          current->genre=albumstable.value("genre").toString();

          current->year=albumstable.value("recordedyear").toInt();
          taglist.append(current);
        }
      QPtrList<id3tag>::Iterator index=taglist.begin();
      long newcounter=0;
      progresswindow->killProgress(progress);
      progresswithbar *progress2=progresswindow->startProgress(i18n("Writing new database."),counter);
      //close old database
      databaseconnect->close();
      //open new built database
      databaseconnect->setDatabaseName(DATABASE);
      databaseconnect->setUserName(USER);
      databaseconnect->setPassword(PASSWORD);
      databaseconnect->setHostName(HOST);
      if(databaseconnect->open())//Check wether the database is opening or not
        {
          while (index!=taglist.end()&&!progress2->isChancelled)
            {
              progress2->setProgress(newcounter++);
              current=*index;
              writetag(current);
              index++;
            }
          if (!progress2->isChancelled)
            importOk=TRUE;
          else
            {
              importOk=FALSE;
              //delete new partdatabase
              QSqlQuery querystatement;
              querystatement.exec ("drop database "DATABASE";");
            }
        }
      else
        {
          //Import impossible, cause new database does not open
          importOk=FALSE;
        }
      taglist.clear();
      delete progresswindow;
    }
  else
    {
      //Import impossible,because connection does not work
      importOk=FALSE;
    }
  return importOk;
}

void mysqldatabase::writetag(id3tag *Song)
{
  //set all foreign indexes to 0
  long artistindex=0;
  long albumindex=0;
  long genreindex=0;
  //Fill up tags if not propper set
  if (Song->album.isEmpty())
    Song->album="no album";
  if (Song->titel.isEmpty())
    Song->titel="no songname";
  if (Song->artist.isEmpty())
    Song->artist="no artist";
  if (Song->genre.isEmpty())
    Song->genre="no genre";

  //###################Check for Artist####################
  QSqlCursor artiststable("artists");
  QString artistsearch=QString("artistname =\"%1\"").arg(Song->artist);
  artiststable.select(artistsearch);
  if(!(artiststable.first()))//If artist doesn't exist, create a db-entry
    {
      QSqlRecord *buffer=artiststable.primeInsert();
      buffer->setValue("artistname",Song->artist);
      if (!artiststable.insert())
        {
          QSqlError error=artiststable.lastError();
          cerr<<"artisterror:"<<error.text()<<endl;
        }

      //reposition sql-cursor, so we can read out the new id for the artist
      artiststable.select(artistsearch);
      artiststable.first();
    }
  //fetch artisid as foreign key for other tables
  bool ok;
  artistindex=(QString(artiststable.value("artistid").toString())).toLong(&ok,10);

  //###################Check for Album####################
  QSqlCursor albumstable("albums");
  QString albumsearch=QString("albumname =\"%1\" and artist_id=\"%2\"").arg(Song->album,QString::number(artistindex));
  albumstable.select(albumsearch);
  if(!(albumstable.first()))//If album doesn't exist, create a db-entry
    {
      QSqlRecord *buffer=albumstable.primeInsert();
      buffer->setValue("albumname",Song->album);
      buffer->setValue("artist_id",QString::number(artistindex));
      buffer->setValue("releaseyear",Song->year);
      if (!albumstable.insert())
        {
          QSqlError error=albumstable.lastError();
          cerr<<"albumserror:"<<error.text()<<endl;
        }
      //reposition sql-cursor, so we can read out the new id for the album
      albumstable.select(albumsearch);
      albumstable.first();
    }
  //fetch artisid as foreign key for other tables
  albumindex=(QString(albumstable.value("albumid").toString())).toLong(&ok,10);

  //###################Check for Genre####################
  QSqlCursor genrestable("genres");
  QString genresearch=QString("genrename =\"%1\"").arg(Song->genre);
  genrestable.select(genresearch);
  if(!(genrestable.first()))//If genre doesn't exist, create a db-entry
    {
      QSqlRecord *buffer=genrestable.primeInsert();
      buffer->setValue("genrename",Song->genre);
      if (!genrestable.insert())
        {
          QSqlError error=genrestable.lastError();
          cerr<<"genreserror: "<<error.text()<<endl;
        }
      //reposition sql-cursor, so we can read out the new id for the album
      genrestable.select(genresearch);
      genrestable.first();
    }
  //fetch artistid as foreign key for other tables
  genreindex=(QString(genrestable.value("genreid").toString())).toLong(&ok,10);

  //###################Check for Song####################

  QSqlCursor trackstable("tracks");
  QString tracksearch=QString("trackname=\"%1\" and album_id=\"%2\" and artist_id=\"%3\"").arg(Song->titel,QString::number(albumindex),QString::number(artistindex));
  trackstable.select(tracksearch);
  if(!(trackstable.first()))//If Song doesn't exist, create a db-entry
    {
      QSqlRecord *buffer=trackstable.primeInsert();
      buffer->setValue("album_id",QString::number(albumindex));
      buffer->setValue("artist_id",QString::number(artistindex));
      buffer->setValue("genre_id",QString::number(genreindex));
      buffer->setValue("trackname",Song->titel);
      buffer->setValue("tracknumber",Song->number);
      if(!trackstable.insert())
        {
          QSqlError error=trackstable.lastError();
          cerr<<"trackserror"<<error.text()<<endl;
        }
    }
}

//Functions for filling comboboxes
void mysqldatabase::fillCombo(QComboBox *combobox,QString tablename,QString sortcriteria)
{
  //rescue current Text
  QString rescued=combobox->currentText();
  combobox->clear();
  QString result;
  QSqlCursor searchtable(tablename);
  searchtable.select("",searchtable.index(sortcriteria));
  while(searchtable.next())
    {
      result=searchtable.value(sortcriteria).toString();
      if (!result.isEmpty())
        combobox->insertItem(result,-1);
    }
  //insert rescued text as currentText
  combobox->setCurrentText(rescued);
}

void mysqldatabase::fillSortedCombo(QComboBox *combobox,QString tablename,QString sqlquery,QString criteria)
{
  //fetch old currentText, maybe we need this later again
  QString rescue=combobox->currentText();
  bool match=FALSE;
  combobox->clear();
  QString result;
  QSqlCursor searchtable(tablename);
  searchtable.select(sqlquery);
  long resultcounter=0;
  while(searchtable.next())
    {
      resultcounter++;
      result=searchtable.value(criteria).toString();
      if (!result.isEmpty())
        combobox->insertItem(result,-1);
      if (!result.compare(rescue))//did we already have the right value in?
        match=TRUE;
    }
  if(match)
    combobox->setCurrentText(rescue);
  else if (resultcounter!=1)
    combobox->setCurrentText("");
}

void mysqldatabase::fillSortedCombo(QComboBox *combobox,QString tablename,QString sqlquery,QString criteria,QString realtable)
{
  //fetch old currentText, maybe we need this later again
  QString rescue=combobox->currentText();
  bool match=FALSE;
  combobox->clear();
  QString result;
  QSqlCursor searchtable(tablename);
  searchtable.select(sqlquery);
  QStringList bufferlist;
  while(searchtable.next())
    {
      result=searchtable.value(criteria).toString();
      if (!result.isEmpty())
        {
          //get every entry only once
          bool doubleentry=FALSE;
          QStringList::Iterator index=bufferlist.begin();
          while (index!=bufferlist.end())
            {
              if (!QString(*index).compare(result))
                {
                  doubleentry=TRUE;
                  index=bufferlist.end();
                }
              else
                index++;
            }
          if (!doubleentry)
            {
              bufferlist.append(result);
            }
        }
    }
  //now translate the indexes to real strings
  QStringList::Iterator index=bufferlist.begin();
  QString realquery=criteria.remove("_");
  QString realcriteria=QString("%1%2").arg(criteria.remove("id"),"name");
  long resultcounter=0;
  while (index!=bufferlist.end())
    {
      QString querystring=QString("%1=\"%2\"").arg(realquery,QString(*index));
      resultcounter++;
      QSqlCursor searchtable(realtable);
      searchtable.select(querystring);
      searchtable.first();
      result=searchtable.value(realcriteria).toString();
      combobox->insertItem(result,-1);
      if (!result.compare(rescue))//did we already have the right value in?
        match=TRUE;
      index++;
    }
  if(match)
    combobox->setCurrentText(rescue);
  else if (resultcounter!=1)
    combobox->setCurrentText("");
}

long mysqldatabase::translateartist(QString artist)
{
  QSqlCursor artiststable("artists");
  QString searchstring=QString("artistname =\"%1\"").arg(artist);
  artiststable.select(searchstring);
  if  (artiststable.first())
    {
      bool ok;
      return QString(artiststable.value("artistid").toString()).toLong(&ok,10);
    }
  else
    return 0;
}

long mysqldatabase::translatealbum(QString album)
{
  QSqlCursor albumstable("albums");
  QString searchstring=QString("albumname =\"%1\"").arg(album);
  albumstable.select(searchstring);
  if  (albumstable.first())
    {
      bool ok;
      return QString(albumstable.value("albumid").toString()).toLong(&ok,10);
    }
  else
    return 0;
}

long mysqldatabase::translategenre(QString genre)
{
  QSqlCursor genrestable("genres");
  QString searchstring=QString("genrename =\"%1\"").arg(genre);
  genrestable.select(searchstring);
  if  (genrestable.first())
    {
      bool ok;
      return QString(genrestable.value("genreid").toString()).toLong(&ok,10);
    }
  else
    return 0;
}

bool mysqldatabase::albumexists(long artistid,long albumid,QStringList *songlist)
{
  bool albumfound=FALSE;
  QSqlCursor trackstable("tracks");
  QString searchstring=QString("artist_id =\"%1\" AND album_id=\"%2\"").arg(QString::number(artistid),QString::number(albumid));
  trackstable.select(searchstring,trackstable.index("tracknumber"));
  while(trackstable.next())
    {
      albumfound=TRUE;
      QString result=trackstable.value("trackname").toString();
      songlist->append(result);
    }
  return albumfound;
}

long mysqldatabase::getyear(long albumindex)
{
  long releaseyear=0;
  QSqlCursor albumstable("albums");
  QString searchstring=QString("albumid=\"%1\"").arg(QString::number(albumindex));
  albumstable.select(searchstring);
  if (albumstable.first())
    ;
  {
    bool ok;
    releaseyear=QString(albumstable.value("releaseyear").toString()).toLong(&ok,10);
  }
  return releaseyear;
}

void mysqldatabase::gettrack(QComboBox *trackbox,long artistid,long albumid,int tracknumber)
{
  QSqlCursor trackstable("tracks");
  QString searchstring=QString("artist_id= %1 and album_id=%2 and tracknumber=%3").arg(QString::number(artistid),QString::number(albumid),QString::number(tracknumber));
  trackstable.select(searchstring);
  if (trackstable.first())
    {
      QString result=trackstable.value("trackname").toString();
      trackbox->setCurrentText(result);
    }
}

bool mysqldatabase::checkdiscid(QString discid,QComboBox *artistbox,QComboBox *albumbox)
{
  bool ok;
  QSqlCursor albumstable("albums");
  QString searchstring=QString("cdid=\"%1\"").arg(discid);
  albumstable.select(searchstring);
  if (albumstable.first())
    {
      albumbox->setCurrentText(albumstable.value("albumname").toString());
      long artistid=QString(albumstable.value("artist_id").toString()).toLong(&ok,10);
      QSqlCursor artiststable("artists");
      QString searchstring=QString("artistid=%1").arg(artistid);
      artiststable.select(searchstring);
      if(artiststable.first())
        artistbox->setCurrentText(artiststable.value("artistname").toString());
      return TRUE;
    }
  else
    return FALSE;
}

//+++++++++++++++++++++++++++++++++++++++
//+Insert complete cds into the database+
//+++++++++++++++++++++++++++++++++++++++
void mysqldatabase::writealbum(QString discid,QString discartist,QString discalbum,QString discgenre,long discyear,QStringList *tracklist)
{
  //look if we alread have that disc in database
  long albumid;
  long artistid;
  long genreid;
  bool ok;
  QSqlCursor albumstable("albums");
  QSqlCursor artiststable("artists");
  QSqlCursor genrestable("genres");
  QSqlCursor trackstable("tracks");
  QString searchstring=QString("cdid=%1").arg(discid);
  albumstable.select(searchstring);
  if (albumstable.first())
    {
      //album exists already, so we do not need to insert artist and album,only fetch artistid and albumid
      artistid=QString(albumstable.value("artist_id").toString()).toLong(&ok,10);
      albumid=QString(albumstable.value("albumid").toString()).toLong(&ok,10);
    }
  else
    {
      //album does not exist, so check for the artist first and than generate a new album entry
      searchstring=QString("artistname=\"%1\"").arg(discartist);
      artiststable.select(searchstring);
      if (!artiststable.first())
        {
          //artist does not exist,so we create it
          QSqlRecord *buffer=artiststable.primeInsert();
          buffer->setValue("artistname",discartist);
          if (!artiststable.insert())
            {
              QSqlError error=artiststable.lastError();
              cerr<<"artistserror: "<<error.text()<<endl;
            }
          else
            {
              //reposition sql-cursor, so we can read out the new id for the artist
              artiststable.select(searchstring);
              artiststable.first();
            }
        }
      //fetch artistid, no matter if new, or already existing
      artistid=QString(artiststable.value("artistid").toString()).toLong(&ok,10);
      //now check if album already exists, but maybe with a different cdid, or no cdid
      //if we have it without cdid,thow entry away,(this deletes all tracks in the album also) and create new one
      bool generatealbum=TRUE;
      searchstring=QString("artist_id=%1 AND albumname=\"%2\"").arg(QString::number(artistid),discalbum);
      albumstable.select(searchstring);
      if (albumstable.first())
        {
          //Check if this version has a cdid
          QString checkid=albumstable.value("cdid").toString();
          if(checkid.isEmpty())
            {
              albumstable.primeDelete();
              albumstable.del();
              generatealbum=TRUE;
            }
          else
            generatealbum=FALSE;
        }
      //do we have to generate an album?
      if (generatealbum)
        {
          //Insert new Album with the cdid
          QSqlRecord *buffer=albumstable.primeInsert();
          buffer->setValue("artist_id",QString::number(artistid));
          buffer->setValue("albumname",discalbum);
          buffer->setValue("cdid",discid);
          buffer->setValue("releaseyear",QString::number(discyear));
          if (!albumstable.insert())
            {
              QSqlError error=albumstable.lastError();
              cerr<<"albumserror: "<<error.text()<<endl;
            }
          else
            {
              //reposition sql-cursor, so we can read out the new id for the album
              albumstable.select(searchstring);
              albumstable.first();
            }
        }
      albumid=QString(albumstable.value("albumid").toString()).toLong(&ok,10);
    }
  //We have an album now for sure, so lets check for the genre
  searchstring=QString("genrename=\"%1\"").arg(discgenre);
  genrestable.select(searchstring);
  if(!genrestable.first())
    {
      //create a new genre
      QSqlRecord *buffer=genrestable.primeInsert();
      buffer->setValue("genrename",discgenre);
      if (!genrestable.insert())
        {
          QSqlError error=genrestable.lastError();
          cerr<<"genreserror: "<<error.text()<<endl;
        }
      else
        {
          //reposition sql-cursor, so we can read out the new id for the genre
          genrestable.select(searchstring);
          genrestable.first();
        }
    }
  genreid=QString(genrestable.value("genreid").toString()).toLong(&ok,10);
  //Now we have everithing we need to create the tracks,if they don't already exist
  QStringList::Iterator index=tracklist->begin();
  int trackcounter=1;
  while(index!=tracklist->end())
    {
      searchstring=QString("artist_id=%1 AND album_id=%2 AND trackname=\"%3\"").arg(QString::number(artistid),QString::number(albumid),QString(*index));
      trackstable.select(searchstring);
      if (!trackstable.first())
        {
          //track does nor exist. Create it
          QSqlRecord *buffer=trackstable.primeInsert();
          buffer->setValue("tracknumber",trackcounter);
          buffer->setValue("trackname",QString(*index));
          buffer->setValue("artist_id",QString::number(artistid));
          buffer->setValue("album_id",QString::number(albumid));
          buffer->setValue("genre_id",QString::number(genreid));
          if (!trackstable.insert())
            {
              QSqlError error=trackstable.lastError();
              cerr<<"trackserror: "<<error.text()<<endl;
            }
        }
      trackcounter++;
      index++;
    }
}
