/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "encoder-interface.h"

lamecode::lamecode(QString source,QString destination,int kbit,id3tag *Song,progressmainwindow *progresswindow)
{
  Songtags=Song;
  wavfile=source;
  mp3file=destination;
  KProcess *lameProcess=new KProcess;
  progress=progresswindow->startProgress(QString(i18n("encoding track %1 with lame")).arg(QString::number(Song->number)),100,lameProcess);
  progresswindow->show();
  if (kbit)
    *lameProcess<<"lame"<<"-h"<<"-ms"<<QString("-b%1").arg(QString::number(kbit))<<source<<destination;
  else
    *lameProcess<<"lame"<<"-h"<<"-ms"<<"--vbr-new"<<source<<destination;
  connect(lameProcess,SIGNAL(receivedStderr(KProcess *,char *,int)),SLOT(readprogressinfo(KProcess *,char *,int)));
  connect(lameProcess,SIGNAL(processExited(KProcess *)),SLOT(finishedProcess(KProcess *)));
  connect(this,SIGNAL(killProgress(progresswithbar *)),progresswindow,SLOT(killProgress(progresswithbar *)));
  lameProcess->start(KProcess::RunMode(1),KProcess::Communication(6));
}

void lamecode::readprogressinfo(KProcess  *proc,char *text,int length)
{
  QString buffer=text;
  int percent;
  while (buffer.contains('%'))
    {
      QString line=buffer.left(buffer.find('%'));
      buffer=buffer.remove(0,buffer.find('%')+1);
      line=line.remove(0,line.find('(')+1);
      percent=line.toInt();
    }
    progress->setProgress(percent);
}

void lamecode::finishedProcess(KProcess *proc)
{
  disconnect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(readprogressinfo(KProcess *,char *,int)));
  disconnect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(finishedProcess(KProcess *)));
  emit killProgress(progress);
  QFile wav(wavfile);
  wav.remove();
  musikdatei *workingtrack=new musikdatei();
  workingtrack->schreibenTag(mp3file,Songtags);  
  delete workingtrack;
  delete Songtags;
}

#include "encoder-interface.moc"
