/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "albumdialog.h"

albumdialog::albumdialog(QScrollView *pointer,compactdisc *cd)
{
  if (cd)
    {
      counter=cd->cdcontent->trackcount;
      if (!counter)
        {
          nothing=new QLabel(i18n("<center><b>press refresh cd-info to read in cd-contents</b></center>"),pointer);
          pointer->addChild(nothing,0,0);
          pointer->resizeContents(800,50);
          pointer->setResizePolicy(QScrollView::AutoOneFit);
        }
      else
        {
          scrollbox=new QGroupBox(4,Qt::Horizontal,pointer->viewport());
          pointer->addChild(scrollbox,0,0);
          pointer->resizeContents(800,200);
          pointer->setResizePolicy(QScrollView::AutoOneFit);
          songfield=new song *[counter];
          timefield=new long [counter];
          /*          QStringList::Iterator index=cd->tracklist->begin();
                    int i=0;
                    while (index!=cd->tracklist->end())
                      {
                        QString timestring=QString(*index).remove(0,QString(*index).find(".")+1);
                        timestring=timestring.left(timestring.find("["));
                        timefield[i]=timestring.toLong();
                        songfield[i]=new song(scrollbox,i+1,timefield[i]);
                        i++;
                        index++;
                      }*/
          for (int i=0;i<counter;i++)
            {
              timefield[i]=cd->cdcontent->cdtoc[i+1].frameoffset-cd->cdcontent->cdtoc[i].frameoffset;
              songfield[i]=new song(scrollbox,i+1,timefield[i]);
            }
        }
    }
  else
    {
      counter=0;
      nothing=new QLabel(i18n("<center><b>press refresh cd-info to read in cd-contents</b></center>"),pointer);
      pointer->addChild(nothing,0,0);
      pointer->resizeContents(800,50);
      pointer->setResizePolicy(QScrollView::AutoOneFit);
    }
}

albumdialog::~albumdialog()
{
  if (!counter)
    {
      delete nothing;
    }
  else
    {
      for (int i=1;i<=counter;i++)
        {
          delete songfield[i-1];
        }
      delete songfield;
      delete timefield;
      delete scrollbox;
    }
}

void albumdialog::setalltracks(QStringList *songlist)
{
  int filledcounter=0;
  QStringList::Iterator index=songlist->begin();
  while(index!=songlist->end()and filledcounter<counter)
    {
      songfield[filledcounter]->songledit->setText(*index);
      // cout<<*index<<endl;
      index++;
      filledcounter++;
    }

}

song::song(QWidget *pointer,int index,long duration)
{
  double long duration2=duration;
  songlabel=new QLabel(QString(i18n("song %1")).arg(QString::number(index)),pointer);
  songcheck=new QCheckBox(pointer);
  songledit=new QLineEdit(pointer);
  QString songtimestring=QString("%1min:%2sec").arg(QString::number(duration/4500),QString::number((int)(((duration2/4500)-(double)(duration/4500))*60)));//calculate blocks in minitues and seconds
  songtime=new QLabel(songtimestring,pointer);
}

song::~song()
{
  delete songlabel;
  delete songcheck;
  delete songledit;
  delete songtime;
}
