/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __CALIBRATEDIALOG_H
#define __CALIBRATEDIALOG_H

#include <qmap.h>
#include <qstring.h>
#include "patternlibrarydlg.h"

class KListViewItem;
class QIconViewItem;
class QPopupMenu;
class KXStitchMimeSource;
class KAction;
class QLabel;

/** Wrapper class to manage the pattern libraries
    @author Stephen P Allewell
  */
class PatternLibraryDialog : public PatternLibraryDlg
{
  Q_OBJECT
public:
  enum Mode {Create, Insert, Export, Import};
  PatternLibraryDialog(QWidget* parent, enum Mode mode, KXStitchMimeSource* data = 0);
  virtual ~PatternLibraryDialog();

  KXStitchMimeSource* pattern();

protected slots:
  void showContextMenu(KListView*,QListViewItem*,const QPoint&);
  void showContextMenu(QIconViewItem*,const QPoint&);
  virtual void accept();
  void contextHelp();
  void libraryChanged(QListViewItem*);
  void patternChanged(QIconViewItem*);
  void patternDoubleClicked(QIconViewItem*);
  void newCatagory();
  void showToolTip(QIconViewItem*);
  void removeToolTip();
  void exportIcon();
  void exportTree();

private:
  void fillLibraryList();
  void recurseLibrary(KListViewItem*,QString);
  void fillPatternList(QListViewItem* item = 0);
  void exportPatterns();
  bool libContains(QString path,Q_UINT16 checksum);
  void libAppend(QString path,Q_UINT16 checksum,QByteArray& compressed);
  void doImport();
  Q_INT32 exportLibrary(QDataStream&,QString,QValueList<int>);

  KXStitchMimeSource*             m_patternData;
  enum Mode                       m_mode;
  QListViewItem*                  m_listViewItem;
  QIconViewItem*                  m_iconViewItem;
  QLabel*                         m_tooltip;
  QMap<QString,QValueList<int> >  m_exportList; // stores exports as path and list of indexes
};

#endif
