/***************************************************************************
                          commands_file  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_FILE_H
#define COMMANDS_FILE_H

#include "kxecommand.h"
#include <klocale.h>

/** @file
	This file contains all commands taken from menu File which
	can effect our edited document. These commans allows to have
	undo/redo functionality.
*/

/**
Command for setting version and encoding to XML file.

@author The KXMLEditor Team
*/

class KXMLEditorPart;
class QString;

class KXEVersionEncodingCommand : public KXECommand
{
	public:
		KXEVersionEncodingCommand(KXMLEditorPart* pPart, const QString& oldData, const QString &newData);
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Changing version and encoding"); }
		~KXEVersionEncodingCommand();
	protected:
		QString m_strOldData;
		QString m_strNewData;
};

class KXEStylesheetAttachCommand : public KXECommand
{
	public:
		KXEStylesheetAttachCommand(KXMLEditorPart* pPart,const QString& prevStylesheet,const QString& newStylesheet);
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Attaching stylesheet ")+m_strNewStylesheet; }
		~KXEStylesheetAttachCommand();
	protected:
		QString m_strPrevStylesheet;
		QString m_strNewStylesheet;
};

class KXEStylesheetDetachCommand : public KXECommand
{
	public:
		KXEStylesheetDetachCommand(KXMLEditorPart* pPart,const QString& prevStylesheet);
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Detaching stylesheet ")+m_strPrevStylesheet; }
		~KXEStylesheetDetachCommand();
	protected:
		QString m_strPrevStylesheet;
};

class KXESchemaAttachCommand : public KXECommand
{
	public:
		KXESchemaAttachCommand(KXMLEditorPart *pPart,const QString& newSchema);
		KXESchemaAttachCommand(KXMLEditorPart *pPart,const QString& newSchema, const QString& prevSchema);
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Attaching schema ")+m_strNewSchema; }
		~KXESchemaAttachCommand();
	protected:
		QString m_strNewSchema;
		QString m_strPrevSchema;
};

class KXESchemaDetachCommand : public KXECommand
{
	public:
		KXESchemaDetachCommand(KXMLEditorPart* pPart, const QString& schema);
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Detaching schema ")+m_schema; }
		~KXESchemaDetachCommand();
	protected:
		QString m_schema;
};

#endif
