/***************************************************************************
                          kxmleditorshell.cpp  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /**
 @file
 */

#include "kxmleditorshell.h"

#include <klibloader.h>
#include <kstdaction.h>
#include <kapplication.h>
#include <klocale.h>
#include <kdebug.h>
#include <kfiledialog.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstatusbar.h>
#include <kparts/browserextension.h>
#include "../part/kxmleditorpart.h"
#include "dcopiface_shell.h"

#define FILE_DIALOG_FILTER "*.xml|XML files\n*.xsl|XSL files\n*.xslt|XSLT files\n*.xul|XUL files\n*.rc|Resource UI files\n*.ui|User Interface UI files\n*|All files"

KXMLEditorShell::KXMLEditorShell( const char * name, WFlags f )
	: KParts::MainWindow( name, f ),
	  m_pPart(0),
	  m_pKXEShellIface(0)
{
	//////////////////////////////
	// CREATE ACTIONS
	//////////////////////////////
	setXMLFile("kxmleditorshell.rc");

	KStdAction::openNew(this,SLOT(slotActFileNew()),actionCollection(),"file_new");
	KStdAction::open( this, SLOT(slotFileOpen()), actionCollection(),"file_open" );
	m_pActFileOpenRecent = KStdAction::openRecent( this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection(),"file_open_recent");
	m_pActFileOpenRecent->loadEntries( instance()->config() );
	m_pActFileSave = KStdAction::save( this, SLOT(slotFileSave()), actionCollection(),"file_save" );
	KStdAction::saveAs( this, SLOT(slotFileSaveAs()), actionCollection() ,"file_save_as");
	m_pActFileSave->setEnabled(false);

	KToggleAction * pActToggleToolBar = KStdAction::showToolbar( this, SLOT(slotToggleToolBar()), actionCollection() );
	KToggleAction * pActToggleStatusBar = KStdAction::showStatusbar( this, SLOT(slotToggleStatusBar()), actionCollection() );
	KStdAction::keyBindings( this, SLOT(slotConfigureKeys()), actionCollection() );
	KStdAction::configureToolbars( this, SLOT(slotConfigureToolbars()), actionCollection() );

        KStdAction::mail(this,SLOT(mail()),actionCollection(),"file_mail");

	KStdAction::quit( this, SLOT(close()), actionCollection(),"file_quit");

	// try to find libkxmleditor
	QString szLibName("libkxmleditorpart");
	KLibFactory * pFactory = KLibLoader::self()->factory(szLibName);
	if (pFactory)
	{
		m_pPart = static_cast <KParts::ReadWritePart*> ( pFactory->create( this, "KXMLEditor view", "KParts::ReadWritePart" ) );
		setCentralWidget( m_pPart->widget() );

		// get the parts browser extension and initialize additional actions with it
		KParts::BrowserExtension * pBrowserExt = 0;
		if ( (pBrowserExt = KParts::BrowserExtension::childObject(m_pPart)) )  // if there is one
		{
			connect( pBrowserExt, SIGNAL(enableAction( const char *, bool )), this, SLOT(slotEnableBrowserExtActions( const char *, bool )) );

			KAction * pActEditCut = KStdAction::cut( pBrowserExt, SLOT(cut()), actionCollection(), "cut" );
			pActEditCut->setEnabled(pBrowserExt->isActionEnabled("cut"));

			KAction * pActEditCopy = KStdAction::copy( pBrowserExt, SLOT(copy()), actionCollection(), "copy" );
			pActEditCopy->setEnabled(pBrowserExt->isActionEnabled("copy"));

			KAction * pActEditPaste = KStdAction::paste( pBrowserExt, SLOT(paste()), actionCollection(), "paste" );
			pActEditPaste->setEnabled(pBrowserExt->isActionEnabled("paste"));

			KAction * pActPrint = KStdAction::print( pBrowserExt, SLOT(print()), actionCollection(), "print" );
			pActPrint->setEnabled(pBrowserExt->isActionEnabled("print"));
		}

		createGUI( m_pPart );
	}
	else
		kdFatal() << "KXMLEditorShell::KXMLEditorShell no " << szLibName << " found" << endl;

	//////////////////////////////
	// CREATE STATUSBAR
	//////////////////////////////
	statusBar()->message( i18n("Ready.") );

	//////////////////////////////
	// MISC. INITIALIZATION
	//////////////////////////////
	setAutoSaveSettings();
	pActToggleToolBar->setChecked( ! toolBar()->isHidden() );
	pActToggleStatusBar->setChecked( ! statusBar()->isHidden() );

	m_pKXEShellIface = new KXMLEditorShellIface(*this);

	statusBar()->setSizeGripEnabled(true);
}

KXMLEditorShell::~KXMLEditorShell()
{
	if (m_pKXEShellIface)
		delete m_pKXEShellIface;
}

/////////////////////////////////////////////////////////////////////
//                     ACTION SLOTS
/////////////////////////////////////////////////////////////////////

void KXMLEditorShell::slotFileOpen()
{
	statusBar()->message( i18n("Opening file...") );

	KURL url = KFileDialog::getOpenURL( QString::null,
	                                    i18n(FILE_DIALOG_FILTER),
	                                    this );
	openURL(url);
  m_pActFileSave->setEnabled(true);

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotFileOpenRecent(const KURL & url)
{
	statusBar()->message( i18n("Opening file...") );

	openURL(url);

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotFileSave()
{
	statusBar()->message( i18n("Saving file...") );

	if( m_pPart->url().isEmpty() )
		slotFileSaveAs();
	else
		m_pPart->save();

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotFileSaveAs()
{
	statusBar()->message( i18n("Saving file with a new filename...") );

	KFileDialog dlg( QDir::currentDirPath(),   // start dir.
	                 i18n(FILE_DIALOG_FILTER), // filter
	                 this,                     // parent
	                 "file dialog for saving", // name
	                 true );                   // modal
	dlg.setCaption( i18n("Save as...") );
	dlg.setOperationMode( KFileDialog::Saving );
	dlg.exec();

	KURL url = dlg.selectedURL();

	if(!url.isEmpty())
	{
    // append filetype if necessary
    if(dlg.currentFilter() != "*.*")
    { QString strExtension = dlg.currentFilter();
      strExtension.remove('*');

      if(strExtension != url.fileName().right(strExtension.length()))
        url.setFileName(url.fileName() + strExtension );
    }

		if (m_pPart->saveAs(url))	// something may go wrong
		{
			m_pActFileOpenRecent->addURL(url);
			m_pPart->setModified(false);

			m_pActFileSave->setEnabled(false);
		}
	}

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotToggleToolBar()
{
	statusBar()->message( i18n("Toggle the toolbar...") );

	if( toolBar()->isHidden() )
		toolBar()->show();
	else
		toolBar()->hide();

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotToggleStatusBar()
{
	statusBar()->message( i18n("Toggle the statusbar...") );

	if( statusBar()->isHidden() )
		statusBar()->show();
	else
		statusBar()->hide();

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotConfigureKeys()
{
	KKeyDialog dlg;
	dlg.insert(m_pPart->actionCollection());
	dlg.insert(actionCollection());
	dlg.configure();
}

void KXMLEditorShell::slotConfigureToolbars()
{
	KEditToolbar dlg( factory() );
	if ( dlg.exec() )
		createGUI( m_pPart );
}

/////////////////////////////////////////////////////////////////////
//                    ADDITIONAL FUNCTIONS
/////////////////////////////////////////////////////////////////////

bool KXMLEditorShell::openURL( const KURL & url ) const
{
	if ( url.isEmpty() )
		return false;

	// About this function, the style guide (
	// http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
	// says that it should open a new window if the document is _not_
	// in its initial state.  This is what we do here.

	// We have to differenciate, if this shell could
	// be used or a new one has to be created.
	if ( m_pPart->url().isEmpty() && ! m_pPart->isModified() )
	{
		// this one can be used - try to open the file in it
		if ( ! m_pPart->openURL(url) )
			return false;
	}
	else
	{
		// a new one has to be created
		KXMLEditorShell * pShell = new KXMLEditorShell;

		// try to open the file in the shell
		if ( ! pShell->m_pPart->openURL(url) )
			return false;

		// show the new shell
		pShell->show();
	}

	// on success, the URL could be added to our list of recent files
	m_pActFileOpenRecent->addURL(url);

	return true;
}

bool KXMLEditorShell::queryClose()
{
	if ( ! m_pPart->closeURL() )
		return false;

	m_pActFileOpenRecent->saveEntries( instance()->config() );

	return KParts::MainWindow::queryClose();
}

void KXMLEditorShell::saveProperties( KConfig * pConfig )
{
	pConfig->writeEntry( "CurrentURL", m_pPart->url().url() );

	KParts::MainWindow::saveProperties(pConfig);
}

void KXMLEditorShell::readProperties( KConfig * pConfig )
{
	KParts::MainWindow::readProperties(pConfig);

	QString strURL = pConfig->readEntry( "CurrentURL", "" );
	if ( strURL.isEmpty())
		return;
	m_pPart->openURL( strURL );
}

void KXMLEditorShell::slotEnableBrowserExtActions( const char * pszName, bool bEnabled )
{
	KAction * pAct = actionCollection()->action( pszName );
	if ( pAct )
		pAct->setEnabled( bEnabled );
	else
		kdDebug() << "KXMLEditor " << k_funcinfo << " unknown action (" << pszName << ")" << endl;

}

// Set main window caption (by using the base class functionality),
// Enables/disables Save button (corresponding to the parts modified status)
void KXMLEditorShell::setCaption( const QString & strCaption )
{
	m_pActFileSave->setEnabled( m_pPart->isModified() );
	KParts::MainWindow::setCaption( strCaption, m_pPart->isModified() ); // base class functionality
}


//
// Called when creating new file is requested.
//
void KXMLEditorShell::slotActFileNew()
{
	// About this function, the style guide (
	// http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
	// says that it should open a new window if the document is _not_
	// in its initial state.  This is what we do here..
	KXMLEditorShell * pShell;
	if ( ! m_pPart->url().isEmpty() || m_pPart->isModified() )
	{
		pShell = new KXMLEditorShell;
		pShell->show();
	}
	// if there is a way to determine in KXMLEditorPart that it was created "for new file" then
	// this part should be changed.
	else
		pShell = this;

	((KXMLEditorPart *)pShell->m_pPart)->newFile();
}

void KXMLEditorShell::mail()
{
	slotFileSave();							// first - our XML file have to be saved.
	if (!m_pPart->url().isEmpty())
	{
		QStringList urls(m_pPart->url().url());			// we can prepare then list of attachments (1 element in the list)
		QString theSubject(m_pPart->url().fileName(false));	// and set the mail subject
		kapp->invokeMailer(	QString::null,			// finally we can compose e-mail (addressed to no-one) out of that
						QString::null,
						QString::null,
						theSubject,				// subject
						QString::null,			// body
						QString::null,
						urls);					// attachments
	}
}
