/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kpushbutton.h>
#include <ktabwidget.h>
#include <kmessagebox.h>
#include <kinputdialog.h>
//QT Includes
#include <qlabel.h>

//kX Generator Includes
#include "ServerLayoutWidget.h"
#include "GlobalFunctions.h"
#include "ChangeEntriesDialog.h"



ServerLayoutWidget :: ServerLayoutWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "ServerLayout Widget" )
{
//Setting window geometry
    setGeometry(0, 0, 560, 339);

X = Xorg;


//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("looknfeel", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 30);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );
//Layouts Combo Box
   LayoutCombo = new KComboBox(this);
    LayoutCombo->setGeometry(10, 55, 400, 25);


//Change entries button
   KPushButton *ChangeEntriesButton = new KPushButton(this);
    ChangeEntriesButton->setText(Locale(2));
    ChangeEntriesButton->setGeometry(270, 90, 140, 25);
    ChangeEntriesButton->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));




//Tab widget
   KTabWidget *ServerLayoutTabWidget = new KTabWidget(this);

//Making tab widgets
    QWidget *PointerTab = new QWidget();
    QWidget *KeyboardTab = new QWidget();
    QWidget *ScreenTab = new QWidget();

//Inserting tab widgets into TabWidget
    ServerLayoutTabWidget->setGeometry(10, 140, 550, 198);
    ServerLayoutTabWidget->insertTab(PointerTab, Icons->loadIcon("mouse", KIcon::Toolbar, KIcon::SizeSmall), Locale(3));
    ServerLayoutTabWidget->insertTab(KeyboardTab, Icons->loadIcon("keyboard", KIcon::Toolbar, KIcon::SizeSmall), Locale(4));
    ServerLayoutTabWidget->insertTab(ScreenTab, Icons->loadIcon("background", KIcon::Toolbar, KIcon::SizeSmall), Locale(5));


//Making "Pointers" tab

       PointersListBox = new KListBox(PointerTab);
         PointersListBox->setGeometry(10, 10, 190, 148);
       KPushButton *AddPointerButton = new KPushButton(PointerTab);
         AddPointerButton->setGeometry(210, 10, 130, 25);
         AddPointerButton->setText(Locale(6));
         AddPointerButton->setIconSet(Icons->loadIcon("add", KIcon::Toolbar, KIcon::SizeSmall));

       KPushButton *RemovePointerButton = new KPushButton(PointerTab);
         RemovePointerButton->setGeometry(210, 45, 130, 25);
         RemovePointerButton->setText(Locale(7));
         RemovePointerButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));

       QLabel *PointerInfoLabel = new QLabel(PointerTab);
         PointerInfoLabel->setText(Locale(9));
         PointerInfoLabel->setGeometry(350, 10, 190, 130);
         PointerInfoLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);

       PointerCoreCheckBox = new QCheckBox(PointerTab);
         PointerCoreCheckBox->setGeometry(350, 133, 190, 25);
         PointerCoreCheckBox->setText(Locale(10));
         PointerCoreCheckBox->setEnabled(FALSE);


//Making "Keyboards" tab

       KeyboardsListBox = new KListBox(KeyboardTab);
         KeyboardsListBox->setGeometry(10, 10, 190, 148);   //160
       KPushButton *AddKeyboardButton = new KPushButton(KeyboardTab);
         AddKeyboardButton->setGeometry(210, 10, 130, 25);
         AddKeyboardButton->setText(Locale(6));
         AddKeyboardButton->setIconSet(Icons->loadIcon("add", KIcon::Toolbar, KIcon::SizeSmall));

       KPushButton *RemoveKeyboardButton = new KPushButton(KeyboardTab);
         RemoveKeyboardButton->setGeometry(210, 45, 130, 25);
         RemoveKeyboardButton->setText(Locale(7));
         RemoveKeyboardButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));

       QLabel *KeyboardsInfoLabel = new QLabel(KeyboardTab);
         KeyboardsInfoLabel->setText(Locale(11));
         KeyboardsInfoLabel->setGeometry(350, 10, 190, 130);
         KeyboardsInfoLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);

       KeyboardsCoreCheckBox = new QCheckBox(KeyboardTab);
         KeyboardsCoreCheckBox->setGeometry(350, 133, 190, 25);
         KeyboardsCoreCheckBox->setText(Locale(10));
         KeyboardsCoreCheckBox->setEnabled(FALSE);

//Making "Screens" tab

       ScreensListBox = new KListBox(ScreenTab);
         ScreensListBox->setGeometry(10, 10, 190, 148);
       KPushButton *AddScreenButton = new KPushButton(ScreenTab);
         AddScreenButton->setGeometry(210, 10, 130, 25);
         AddScreenButton->setText(Locale(6));
         AddScreenButton->setIconSet(Icons->loadIcon("add", KIcon::Toolbar, KIcon::SizeSmall));

       KPushButton *RemoveScreenButton = new KPushButton(ScreenTab);
         RemoveScreenButton->setGeometry(210, 45, 130, 25);
         RemoveScreenButton->setText(Locale(7));
         RemoveScreenButton->setIconSet(Icons->loadIcon("remove", KIcon::Toolbar, KIcon::SizeSmall));

       QLabel *ScreenInfoLabel = new QLabel(ScreenTab);
         ScreenInfoLabel->setText(Locale(12));
         ScreenInfoLabel->setGeometry(350, 10, 190, 130);
         ScreenInfoLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);





//Running Init function
   RefreshLayoutCombo();
   Init();





//Connecting


     connect (LayoutCombo, SIGNAL(activated(int)), this, SLOT(Init()));
     connect (AddPointerButton, SIGNAL(clicked()), this, SLOT(AddPointer()));
     connect (RemovePointerButton, SIGNAL(clicked()), this, SLOT(RemovePointer()));
     connect (AddKeyboardButton, SIGNAL(clicked()), this, SLOT(AddKeyboard()));
     connect (RemoveKeyboardButton, SIGNAL(clicked()), this, SLOT(RemoveKeyboard()));
     connect (AddScreenButton, SIGNAL(clicked()), this, SLOT(AddScreen()));
     connect (RemoveScreenButton, SIGNAL(clicked()), this, SLOT(RemoveScreen()));
     connect (ChangeEntriesButton, SIGNAL(clicked()), this, SLOT(ChangeEntries()));

}

void ServerLayoutWidget :: Init()
{

//Initializing Input Devices
PointersListBox->clear();
KeyboardsListBox->clear();


//Initializing Screens
ScreensListBox->clear();
   for (int a = 1; a <= X->CountValues(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "Screen"); a++)
     {
      ScreensListBox->insertItem(X->GetValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "Screen", a));
     }




  for (int a = 1; a <= X->CountValues(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice"); a++)
    {
     if (X->isPointer(X->GetValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", a)))
       {
        PointersListBox->insertItem(X->GetValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", a));
       }
     if (X->isKeyboard(X->GetValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", a)))
       {
        KeyboardsListBox->insertItem(X->GetValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", a));
       }
    }



PointersListBox->setSelected(0, TRUE);
KeyboardsListBox->setSelected(0, TRUE);
ScreensListBox->setSelected(0, TRUE);
}

void ServerLayoutWidget :: RefreshLayoutCombo()
{
   LayoutCombo->clear();
   for (int a = 1; a <= X->CountSections(Xorg::ServerLayout); a++)
    {
     LayoutCombo->insertItem(X->GetValue(Xorg::ServerLayout, a, "Identifier", 1));
    }
}

void ServerLayoutWidget :: AddPointer()
{
GlobalFunctions Global;
QString Pointer = Global.GetPointer(X);
if (Pointer == "") 
  { return; }
    else
  {
    if (PointersListBox->findItem(Pointer, Qt::ExactMatch) == 0)
     {
       X->AppendValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", Pointer);
       Init();
     }
    else
     {
      KMessageBox::sorry(this, Locale(13), Locale(500));
     }
  }

}

void ServerLayoutWidget :: RemovePointer()
{
  if (PointersListBox->count() == 1)
    {
     KMessageBox :: sorry(this, Locale(14), Locale(500));
     return;
    }
unsigned int CurrentItem = PointersListBox->currentItem();

X->RemoveValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", PointersListBox->text(PointersListBox->currentItem()));
Init();

if (CurrentItem == PointersListBox->count()) 
   { PointersListBox->setSelected(CurrentItem - 1, TRUE); }
else
   { PointersListBox->setSelected(CurrentItem, TRUE); }
}

void ServerLayoutWidget :: AddKeyboard()
{
GlobalFunctions Global;
QString Keyboard = Global.GetKeyboard(X);
if (Keyboard == "") 
  { return; }
    else
  {
    if (KeyboardsListBox->findItem(Keyboard, Qt::ExactMatch) == 0)
     {
       X->AppendValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", Keyboard);
       Init();
     }
    else
     {
      KMessageBox::sorry(this, Locale(15), Locale(500));
     }
  }
}

void ServerLayoutWidget :: RemoveKeyboard()
{
  if (KeyboardsListBox->count() == 1)
    {
     KMessageBox :: sorry(this, Locale(16), Locale(500));
     return;
    }
unsigned int CurrentItem = KeyboardsListBox->currentItem();

X->RemoveValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "InputDevice", KeyboardsListBox->text(KeyboardsListBox->currentItem()));
Init();

if (CurrentItem == KeyboardsListBox->count()) 
   { KeyboardsListBox->setSelected(CurrentItem - 1, TRUE); }
else
   { KeyboardsListBox->setSelected(CurrentItem, TRUE); }
}

void ServerLayoutWidget :: AddScreen()
{
GlobalFunctions Global;
QString Screen = Global.GetScreen(X);
if (Screen == "") 
  { return; }
    else
  {
    if (ScreensListBox->findItem(Screen, Qt::ExactMatch) == 0)
     {
       X->AppendValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "Screen", Screen);
       Init();
     }
    else
     {
      KMessageBox::sorry(this, Locale(17), Locale(500));
     }
  }
}

void ServerLayoutWidget :: RemoveScreen()
{
  if (ScreensListBox->count() == 1)
    {
     KMessageBox :: sorry(this, Locale(18), Locale(500));
     return;
    }
unsigned int CurrentItem = ScreensListBox->currentItem();

X->RemoveValue(Xorg::ServerLayout, LayoutCombo->currentItem() + 1, "Screen", ScreensListBox->text(ScreensListBox->currentItem()));
Init();

if (CurrentItem == ScreensListBox->count()) 
   { ScreensListBox->setSelected(CurrentItem - 1, TRUE); }
else
   { ScreensListBox->setSelected(CurrentItem, TRUE); }
}



void ServerLayoutWidget :: ChangeEntries()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::ServerLayout);
Change->exec();
RefreshLayoutCombo();
Init();
}








