/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <klistbox.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <klineedit.h>

//QT Includes
#include <qwidget.h>
#include <qcheckbox.h>

//kX Generator Includes
#include "Xorg.h"
class AdvancedWidget : public QWidget
{
    Q_OBJECT
public:
AdvancedWidget(QWidget *Parent = 0, Xorg *Xorg = 0);

private:
Xorg *X;
QString Locale(int n);

   KListBox *ModulesBox;
   KURLRequester *RGBPath;
   KURLComboRequester *ModulesPath;
   KURLComboRequester *FontsPath;

   QCheckBox *RGBCheck;
   QCheckBox *FontsCheck;
   QCheckBox *ModulesCheck;
   QCheckBox *Composite;
   QCheckBox *Xinerama;
   QCheckBox *DontZap;
   QCheckBox *DontVT;
   QCheckBox *DontZoom;
   QCheckBox *PC98;
   QCheckBox *MouseFail;


   KComboBox *ModulesCombo;
   KComboBox *FontsCombo;

   KPushButton *ClearRGBButton;
   KPushButton *ClearFontsButton;
   KPushButton *ClearModulesButton;
   KPushButton *EnterFileFonts;
   KPushButton *EnterFileModules;
   KPushButton *EnterFileRGB;

   KLineEdit *RGBLine;

public slots:
void AddModule();
void RemoveModule();
void InitModules();
void InitFiles();
void InitExtensions();
void RGBCheckBoxHandle(bool Checked);
void FontsCheckBoxHandle(bool Checked);
void ModulesCheckBoxHandle(bool Checked);
void FontsUpdate();
void ModulesUpdate();
void RGBUpdate();
void ClearRGB();
void ClearFonts();
void ClearModules();
void CompositeHandle(bool Checked);
void XineramaHandle(bool Checked);


};
