/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GMOUNTS_H
#define XEPLUGIN_GMOUNTS_H

#include <qobject.h>
#include <kdirwatch.h>



/**
@author Stefano
*/
class XEPlugin_GMounts : public QObject
{
Q_OBJECT
public:
    XEPlugin_GMounts(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_GMounts();
protected:
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	KDirWatch	*KDEWatch;
	QString 	AutoAddMounts;
public slots:
    void xSetup();
    void xStart();
    void xStop();
    void MountAdded(const QString &);
    void dirty(const QString &);
    void xGetParameter(const QString,QString&);
    void xGetParameterList(QStringList*);
    void xGetInfo(QStringList &);
    void xSetupParameter(const QString, const QString);
};

#endif
