#ifndef KDIALUPCLASS_H
#define KDIALUPCLASS_H
/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "dialup.h"

#include <qobject.h>

class QString;
class SuProcessBase;
class KProcess;

class dialupClass : public QObject
{
    Q_OBJECT
    public:
        dialupClass(QObject *parent = 0, const char *name = 0);
        ~dialupClass();
        bool readData(QString profile);
        bool writeData(QString profile);
        void parseConfigLine( QString line);
        dialupData* getData()
        {
            return &m_data;
        }
    signals:
        void dataWritten();
                
    public slots:
        //void slotWriteProcessExited(SuProcessBase *);
        void slotWriteProcessExited(KProcess *);
        void slotWriteProcessWrote(KProcess *, char *, int);
        
    private:
        dialupData m_data;
};

#endif
