/*
 * $Id: embedtool.cpp,v 1.5 2002/12/02 12:00:18 garbanzo Exp $
 *
 * nVIDIA KWin embed tool (version 1.0)
 *
 * Copyright (C) 2002 Fredrik H�lund <fredrik@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the license, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
 /* Taken from nVIDIA KWin sources and modified by Sascha Hlusiak, 2006 */

#include <qimage.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qdatetime.h>

#include <iostream>

static int primes[] = {
	   2,   3,   5,   7,  11,  13,  17,  19,  23,  29,
	  31,  37,  41,  43,  47,  53,  59,  61,  67,  71,
	  73,  79,  83,  89,  97, 101, 103, 107, 109, 113,
	 127, 131, 137, 139, 149, 151, 157, 163, 167, 173,
	 179, 181, 191, 193, 197, 199, 211, 223, 227, 229
};

struct EmbedImage {
	QString string;
	int width;
	int height;
	bool alpha;
	QString name;
};

class nVIDIAEmbedder {
public:
	nVIDIAEmbedder();
	~nVIDIAEmbedder();
	
	void embed( const char * );
	void writeIndex();
	
private:
	QFile *file;
	QPtrList<EmbedImage> *index;
	QTextStream stream;
};

nVIDIAEmbedder::nVIDIAEmbedder()
{
	QDateTime date( QDateTime::currentDateTime() );
	QString datestring( date.toString() );
	
//	file = new QFile( "tiles.h" );
	file = new QFile();
	file->open( IO_WriteOnly | IO_Truncate ,stdout);

	stream.setDevice( file );

#if (0)	
	stream << "/*\n";
	stream << " * Generated by embedtool 1.0 on " << datestring << endl;
	stream << " */\n\n";

	stream << "#ifndef __TILES_H\n";
	stream << "#define __TILES_H\n\n";
	stream << "#include <qimage.h>\n"; 
	stream << "#include <qdict.h>\n\n";
	stream << "namespace nVIDIA {\n\n";
#endif
	
	index = new QPtrList<EmbedImage>;
	index->setAutoDelete( true );
}

nVIDIAEmbedder::~nVIDIAEmbedder()
{	
#if (0)
	stream << "} // namespace nVIDIA\n\n";
	stream << "#endif // __TILES_H\n\n";
	stream << "// vim: set noet ts=4 sw=4:\n";
#endif

	file->close();
	delete file;
	delete index;
}

void nVIDIAEmbedder::embed( const char *name )
{
	QFileInfo   fileinfo( name );
	QString     basename( fileinfo.baseName() );
	QString     codename( basename );
	QImage      image( name );
	
	codename = codename.replace( QRegExp("[^a-zA-Z0-9]"), "_" );
	
	stream << "static const QRgb " << codename << "_data[] = {" << endl << "\t";
	stream.setf( QTextStream::hex | QTextStream::right );
	stream.fill( '0' );
	
	int pixels = image.width() * image.height();
	Q_UINT32 *data = reinterpret_cast<Q_UINT32*>( image.bits() );
	bool hasAlpha = false;

	
	for ( int i = 0, j = 0; i < pixels; i++ ) {
		if ( qAlpha( *data ) && qAlpha( *data ) != 0xff )
			hasAlpha = true;
		
		stream << "0x" << qSetW(8) << *(data++);
		
		if ( i != pixels-1 ) {
			stream << ',';
		
			if ( j++ > 4 ) {
				j = 0;
				stream << endl << "\t";
			} else
				stream << ' ';
		}
	}

	stream.reset();
	
	stream << endl << "}; // " << codename << "_data" << endl << endl;

	EmbedImage *imginfo = new EmbedImage;
	imginfo->width = image.width();
	imginfo->height = image.height();
	imginfo->alpha = hasAlpha;
	imginfo->name = codename;
	imginfo->string = basename;
	index->append( imginfo ); 
}

void nVIDIAEmbedder::writeIndex()
{
	stream << "\tstruct EmbedImage {\n";
	stream << "\t\tconst char *name;\n";
	stream << "\t\tint width;\n";
	stream << "\t\tint height;\n";
	stream << "\t\tbool alpha;\n";
	stream << "\t\tconst QRgb *data;\n";
	stream << "\t};\n\n";

	uint i = 0;
	stream << "\tstatic const EmbedImage image_db[] = {\n";
	for ( EmbedImage *image = index->first(); image; image = index->next() )
	{
		stream << "\t\t{ \"" << image->string << "\", "
			<< image->width << ", " << image->height <<
			", " << (image->alpha ? "true" : "false")
			<< ", " << image->name << "_data }";
		if ( i++ < index->count() - 1 )
			stream << ',';
		stream << endl;
	}
	stream << "\t};\n\n";

	uint prime = 0;
	
	for ( i = 0; i < 50; i++ )
		if ( (prime = primes[i]) >= index->count() )
			break;
	
	stream << "\tclass nVIDIAImageDb {\n";
	stream << "\tprivate:\n";
	stream << "\t\tstatic nVIDIAImageDb *m_inst;\n";
	stream << "\t\tQDict<QImage> *db;\n\n";
	stream << "\t\tnVIDIAImageDb() {\n";
	stream << "\t\t\tdb = new QDict<QImage>( " << prime << " );\n";
	stream << "\t\t\tdb->setAutoDelete( true );\n\n";
	stream << "\t\t\tfor ( int i = 0; i < " << index->count() << "; i++ ) {\n";
	stream << "\t\t\t\tQImage *img = new QImage( (uchar*)image_db[i].data,\n";
	stream << "\t\t\t\t\t\timage_db[i].width, image_db[i].height,\n";
	stream << "\t\t\t\t\t\t32, NULL, 0, QImage::LittleEndian );\n\n";
	stream << "\t\t\t\tif ( image_db[i].alpha )\n";
	stream << "\t\t\t\t\timg->setAlphaBuffer( true );\n\n";
	stream << "\t\t\t\tdb->insert( image_db[i].name, img );\n";
	stream << "\t\t\t}\n";
	stream << "\t\t}\n\n";
	stream << "\t\t~nVIDIAImageDb() {\n";
	stream << "\t\t\tdelete db;\n";
	stream << "\t\t}\n\n";
	stream << "\tpublic:\n";
	stream << "\t\tstatic nVIDIAImageDb* instance() {\n";	
	stream << "\t\t\tif ( ! m_inst ) m_inst = new nVIDIAImageDb;\n";
	stream << "\t\t\treturn m_inst;\n";
	stream << "\t\t}\n\n";
	stream << "\t\tstatic void release() {\n";
	stream << "\t\t\tif ( m_inst ) delete m_inst;\n";
	stream << "\t\t\tm_inst = NULL;\n";
	stream << "\t\t}\n\n";
	stream << "\t\tQImage *image( const QString &name ) const {\n";
	stream << "\t\t\treturn db->find( name );\n";
	stream << "\t\t}\n\n";
	stream << "\t}; // class nVIDIAImageDb\n\n";
	stream << "\tnVIDIAImageDb *nVIDIAImageDb::m_inst = NULL;\n\n";
}

int main( int argv, char **argc )
{
	if ( argv < 2 ) {
		printf("embedtool [file1] [file2] [file3] > output.h\n");
		
		return 1;
	}

	nVIDIAEmbedder embedder;

	for ( int i = 1; i < argv; i++ )
	{
		std::cerr << argc[i] << std::endl;
		embedder.embed( argc[i] );
	}

//	embedder.writeIndex();
	
	return 0;
}

// vim: set noet ts=4 sw=4:

