/***************************************************************************
                          kentry.h  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KENTRY_H
#define KENTRY_H

#include <qobject.h>
#include <qlabel.h>
#include <qrect.h>
#include <qwhatsthis.h>
#include <klocale.h>

#include "ksingletabwidget.h"
#include "kwavecontrol.h"

/**
  *@author Matthias Reif
  */
class KWCEntry : public QObject
{
   Q_OBJECT
public:
	KWCEntry( const QString & inscr, KSingleTabWidget *parent = 0, const char *name = 0 );
	~KWCEntry();
	
	void setInscription( const QString & text );
	void setRow( int row );
	void showValue( bool ok = true );
	void showValue2( bool ok = true );
	void setValueWidget( QWidget *widget );
	void setValue2Widget( QWidget *widget );
	void setRightWidget( QWidget *widget );
	void move( int row, int col = 0, int alignment = Qt::AlignLeft | Qt::AlignVCenter );
	QWidget* getValueWidget();
	void setWhatsThis( QString whatsThis );

protected:
	QLabel *inscriptionLabel;

	QWidget *valueWidget;
	QWidget *value2Widget;
	QWidget *rightWidget;

	KSingleTabWidget *parent;
};

#endif
