/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRAFFICTAB_H
#define KTRAFFICTAB_H

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kled.h>
#include <qwhatsthis.h>

#include "ktrafficwidget.h"
#include "ksingletabwidget.h"
#include "kwavecontrol.h"
#include "qwhatsthisstrings.h"

#include "wcardlib.h"

/**
@author Matthias Reif
*/
class KTrafficTab : public QWidget
{
Q_OBJECT
public:
	KTrafficTab( QWidget *parent = 0, const char *name = 0 );
	~KTrafficTab();
	void setTraffic( double recv, double sent );
	void clear( double recv, double sent );
	void setDiscarded( iw_discarded discarded, int missedBeacon );
	void setDiscardedUnknown();

	KTrafficWidget *trafficWidget;
	
	QLabel *maxValueLabel;
	KLineEdit *maxValueEdit;
	KComboBox *maxValueSelect;
	
protected:
	QGridLayout* gridLayout;
	QWidget* gridWidget;

	QGridLayout* discardLayout;
	QWidget* discardWidget;

	QHBoxLayout* hLayout;
	QWidget* hWidget;
	
	QLabel* recvInscr;
	QLabel* recvValue;
	QLabel* sentInscr;
	QLabel* sentValue;
	KLed* recvLed;
	KLed* sentLed;
	
	QLabel *nwidInscr, *nwidValue;
	QLabel *codeInscr, *codeValue;
	QLabel *fragmentInscr, *fragmentValue;
	QLabel *retriesInscr, *retriesValue;
	QLabel *miscInscr, *miscValue;
	QLabel *missedBeaconInscr, *missedBeaconValue;
	
	double prevSent, prevRecv;
	double actSent, actRecv;
	
	static const double KILO_BYTE = 1024.0;
	static const double MEGA_BYTE = 1024.0 * 1024.0;
	static const double GIGA_BYTE = 1024.0 * 1024.0 * 1024.0;
	
public slots:
	void maxValueApply();
};

#endif
