/***************************************************************************
                          smallwidget.h  -  description
                             -------------------
    begin                : Sam Jan 25 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMALLWIDGET_H
#define SMALLWIDGET_H

#include <qwidget.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qdesktopwidget.h>
#include <kprogress.h>
#include <kpopupmenu.h>

#include "options.h"

/**
  *@author Matthias Reif
  */

class SmallWidget : public QWidget  {
   Q_OBJECT
public: 
	SmallWidget(Options *opt, QWidget *parent=0, const char *name=0, WFlags f = 0 );
	~SmallWidget();
  /** No descriptions */
  void mousePressEvent(QMouseEvent *ev);
  /** No descriptions */
  void mouseMoveEvent(QMouseEvent *ev);
  /** No descriptions */
  void mouseReleaseEvent(QMouseEvent *ev);
	/** actualize link */
  void act(int value);

protected:
	KProgress	*linkBar;
	QLabel		*errorLabel;

 	KPopupMenu *popup;
	
	QDesktopWidget *desktop;

	Options *options;

	int 	xPress , yPress;     // save point of mouse press event

	
	bool	hold;				// mouse state
  bool	isCard;			// card state
	
public slots: // Public slots
	/** when a popop entry was activated */
  void popupSlot(int id);
};

#endif
