/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "widgetnotifyhelper.h"

#include <QtCore/QObject>
#include <QTextEdit>
#include <QLineEdit>
#include <QSpinBox>
#include <klineedit.h>
#include <kurlrequester.h>
#include <QCheckBox>
#include <QComboBox>
#include <ktextedit.h>
#include <knuminput.h>
#include <QRadioButton>


WidgetNotifyHelper::WidgetNotifyHelper(QObject *parent)
        : QObject(parent)
{
	this->w = 0L;
	//qDebug("WidgetNotifyHelper::WidgetNotifyHelper\n");
}


WidgetNotifyHelper::~WidgetNotifyHelper()
{
}

void WidgetNotifyHelper::setupChangedAction(QWidget *w)
{
	this->w = w;
	//qDebug("WidgetNotifyHelper::setupChangedAction");
    // connect changed signals to own signal
	
// 	qDebug(qPrintable(QString("processing widget: "+w->objectName())));
	
	QList<QComboBox *> comboboxlist = w->findChildren<QComboBox *>();
// 	qDebug(qPrintable(QString().setNum(comboboxlist.size())+QString(" QComboBox found.")));
	for (int i = 0; i < comboboxlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QComboBox")));
		connect(comboboxlist.at(i), SIGNAL(textChanged(const QString &)), w, SLOT(dialogChanged()));
    }

	
	QList<KLineEdit *> klineeditlist = w->findChildren<KLineEdit *>();
// 	qDebug(qPrintable(QString().setNum(klineeditlist.size())+QString(" KLineEdit found.")));
	for (int i = 0; i < klineeditlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: KLineEdit")));
		connect(klineeditlist.at(i), SIGNAL(textChanged(const QString &)), w, SLOT(dialogChanged()));
    }

	QList<QLineEdit *> qlineeditlist = w->findChildren<QLineEdit *>();
// 	qDebug(qPrintable(QString().setNum(qlineeditlist.size())+QString(" QLineEdit found.")));
	for (int i = 0; i < qlineeditlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QLineEdit")));
		connect(qlineeditlist.at(i), SIGNAL(textChanged(const QString &)), w, SLOT(dialogChanged()));
    }

	QList<KUrlRequester *> kurlrequesterlist = w->findChildren<KUrlRequester *>();
// 	qDebug(qPrintable(QString().setNum(kurlrequesterlist.size())+QString(" KUrlRequester found.")));
	for (int i = 0; i < kurlrequesterlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: KUrlRquester")));
		connect(kurlrequesterlist.at(i), SIGNAL(textChanged(const QString &)), w, SLOT(dialogChanged()));
    }

	QList<QTextEdit *> qtexteditlist = w->findChildren<QTextEdit *>();
// 	qDebug(qPrintable(QString().setNum(qtexteditlist.size())+QString(" QTextEdit found.")));
	for (int i = 0; i < qtexteditlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QTextEdit")));
		connect(qtexteditlist.at(i), SIGNAL(textChanged()), w, SLOT(dialogChanged()));
	}

	QList<KTextEdit *> ktexteditlist = w->findChildren<KTextEdit *>();
	// 	qDebug(qPrintable(QString().setNum(ktexteditlist.size())+QString(" KTextEdit found.")));
	for (int i = 0; i < ktexteditlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: KTextEdit")));
		connect(ktexteditlist.at(i), SIGNAL(textChanged()), w, SLOT(dialogChanged()));
		
	}

	QList<QSpinBox *> qspinboxlist = w->findChildren<QSpinBox *>();
// 	qDebug(qPrintable(QString().setNum(qspinboxlist.size())+QString(" QSpinBox found.")));
	for (int i = 0; i < qspinboxlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QSpinBox")));
		connect(qspinboxlist.at(i), SIGNAL(valueChanged(int)), w, SLOT(dialogChanged()));
    }

	QList<KIntSpinBox *> kintspinboxlist = w->findChildren<KIntSpinBox *>();
	// 	qDebug(qPrintable(QString().setNum(kintspinboxlist.size())+QString(" QSpinBox found.")));
	for (int i = 0; i < kintspinboxlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QSpinBox")));
		connect(kintspinboxlist.at(i), SIGNAL(valueChanged(int)), w, SLOT(dialogChanged()));
	}
	

	QList<QCheckBox *> qcheckboxlist = w->findChildren<QCheckBox *>();
// 	qDebug(qPrintable(QString().setNum(qcheckboxlist.size())+QString(" QCheckBox found.")));
	for (int i = 0; i < qcheckboxlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: ")+ (w->objectName())));
		connect(qcheckboxlist.at(i), SIGNAL(stateChanged(int)), w, SLOT(dialogChanged()));
    }

	QList<QRadioButton *> qradiobuttonlist = w->findChildren<QRadioButton *>();
// 	qDebug(qPrintable(QString().setNum(qradiobuttonlist.size())+QString(" QRadioButton found.")));
	for (int i = 0; i < qradiobuttonlist.size(); ++i) {
// 		qDebug(qPrintable(QString("WidgetNotifyHelper::connect: QRadioButton")));
		connect(qradiobuttonlist.at(i) , SIGNAL(toggled(bool)), w, SLOT(dialogChanged()));
    }
	
}

