/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profileuseroptions.h"

#include <QtGui/QCheckBox>

#include <klineedit.h>

#include "widgetnotifyhelper.h"

ProfileUserOptions::ProfileUserOptions(QWidget *parent)
{
    Q_UNUSED(parent);

    setupUi(this);
    connect(NtDomainNameCheckbox, SIGNAL(stateChanged(int)), this, SLOT(domainNameToggled(int)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}


ProfileUserOptions::~ProfileUserOptions()
{}

void ProfileUserOptions::domainNameToggled(int)
{
    if (NtDomainNameCheckbox->isChecked())
        NtDomainNameLineedit->setEnabled(true);
    else
        NtDomainNameLineedit->setEnabled(false);
}

void ProfileUserOptions::dialogChanged()
{
    dialogModified = true;
}

