/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <QFrame>
#include <QScrollArea>

#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtGui/QColor>
#include <QtGui/QPixmap>

#include <kapplication.h>
#include <kdialog.h>
#include <kpagedialog.h>

#include "configconnectoptions.h"
#include "configdaemonoptions.h"
#include "configdebugoptions.h"
#include "configgeneraloptions.h"
#include "confighelperprogramoptions.h"
#include "configlogoptions.h"
#include "profilecertoptions.h"
#include "profileciscooptions.h"
#include "profilecmdexecafterconnectoptions.h"
#include "profilecmdexecafterdisconnectoptions.h"
#include "profilecmdexecbeforeconnectoptions.h"
#include "profilecmdexecbeforedisconnectoptions.h"
#include "profilegeneraloptions.h"
#include "profileipsecoptions.h"
#include "profilenetworkgeneraloptions.h"
#include "profilenetworkhttpproxyoptions.h"
#include "profilenetworknatoptions.h"
#include "profilenetworkrouteoptions.h"
#include "profilenetworkvirtualipoptions.h"
#include "profileopenvpnoptions.h"
#include "profilepptpoptions.h"
#include "profilepskoptions.h"
#include "profileracoonoptions.h"
#include "profilesmartcardoptions.h"
#include "profilesshoptions.h"
#include "profileuseroptions.h"
#include "profilevtunoptions.h"
#include "vpnaccountdata.h"

class PreferencesDialog : public KPageDialog
{
    Q_OBJECT

public:

    /**
     * Constructor
     * @param parent parent widget
     * @param app pointer to main application
     * @param LogOutput textedit for debug messages
     * @param GlobalConfig pointer to configuration object
     * @param showOnlyProfiles view mode. true: show as profile manager, false: show as preferences dialog
     * @return
     */
    PreferencesDialog(QWidget *parent, KApplication *app, QTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles);
    ~PreferencesDialog();

public slots:
    void accept();
    void reject();
    void slotApply();
    void authTypeChanged(int authtype);
    void connectionTypeChanged(int connectiontype);
    void profileChanged(const QString& itemtext);
    void saveSessionClicked();
    void deleteSessionClicked();
    void renameSessionClicked();
    void newSessionClicked();
    void importCertificate();
    void pageChanged(KPageWidgetItem *current, KPageWidgetItem *before);
    void userAuthToggled(bool);
    void useUdpToggled(bool);
    void useSpecialServerSmartcardificateToggled(bool);
    void applicationVersionToggled(bool);
    void IkeGroupToggled(bool);
    void perfectForwardSecurityToggled(bool);
    void singleDesToggled(bool);
    void useKwalletToggled(bool);
    void dpdToggled(bool);

private slots:
    void OpenvpnPathChanged(const KUrl &);
    void FreeswanPathChanged(const KUrl &);
    void PppdPathChanged(const KUrl &);
    void PptpPathChanged(const KUrl &);
    void RacoonPathChanged(const KUrl &);
    void VpncPathChanged(const KUrl &);
    void CiscoVpncPathChanged(const KUrl &);
    void L2tpdPathChanged(const KUrl &);
    void Xl2tpdPathChanged(const KUrl &);
    void Openl2tpPathChanged(const KUrl&);
    void VtundPathChanged(const KUrl &);
    void SshPathChanged(const KUrl &);
    void showEvent(QShowEvent* e);
    void detectPkcs11Ids();
    void detectPkcs11Slots();
    void localPortToggled(bool);
    void tunnelDeviceTypeChanged(const QString &);
    void useXauthToggled(bool);
    void slotStatusMsg(const QString &text, int id);

protected:
    void setupGui();

    QList<VpnAccountData *> *AccountList;
    QTextEdit *LogOutput;
    VpnAccountData *currentProfile;
    KVpncConfig *GlobalConfig;
    QString lastProfileName;
    int KvpncDebugLevel;
    bool canAccept;
    bool configChanged;
    QPixmap ok_icon;
    QPixmap wrong_icon;
	QScrollArea* DaemonScrollView;
    QStringList CiscoCerts;
    QStringList CiscoCaCerts;

private:
    KPageWidgetItem *prev_page;
    KPageWidgetItem *current_page;

public:
    QApplication *app;

    /* -- option pages -- */
    // Kvpnc
    ConfigGeneralOptions *GeneralOptionsWidget;
    ConfigDebugOptions *DebugOptionsWidget;
    ConfigConnectOptions *ConnectOptionsWidget;
    ConfigLogOptions *LogOptionsWidget;

    // programs
    ConfigDaemonOptions *ConfigDaemonOptionsWidget;
    ConfigHelperProgramOptions *HelperProgramOptionsWidget;

    // profile
    ProfileGeneralOptions *ProfileGeneralOptionsWidget;
    QWidget *ProfileSpecificOptionsWidget;
    QWidget *ProfileCommandExecOptionsWidget;
    QWidget *ProfileAuthenticationOptionsWidget;
    ProfileNetworkRouteOptions *ProfileNetworkRouteOptionsWidget;
    ProfileNetworkGeneralOptions *ProfileNetworkGeneralOptionsWidget;
    ProfileNetworkNatOptions *ProfileNetworkNatOptionsWidget;
    ProfileNetworkVirtualIpOptions *ProfileNetworkVirtualIpOptionsWidget;
    ProfileCertOptions *ProfileCertOptionsWidget;
    ProfileSmartcardOptions *ProfileSmartcardOptionsWidget;
    ProfilePskOptions *ProfilePskOptionsWidget;
    ProfileUserOptions *ProfileUserOptionsWidget;
    ProfileOpenvpnOptions *ProfileOpenvpnOptionsWidget;
    ProfileNetworkHttpProxyOptions *ProfileNetworkHttpProxyOptionsWidget;
    ProfilePptpOptions *ProfilePptpOptionsWidget;
    ProfileRacoonOptions *ProfileRacoonOptionsWidget;
    ProfileIpsecOptions *ProfileIpsecOptionsWidget;
    ProfileCiscoOptions *ProfileCiscoOptionsWidget;
    ProfileVtunOptions *ProfileVtunOptionsWidget;
    ProfileSshOptions *ProfileSshOptionsWidget;
    ProfileCmdExecBeforeConnectOptions *ProfileCmdExecBeforeConnectOptionsWidget;
    ProfileCmdExecBeforeDisconnectOptions *ProfileCmdExecBeforeDisconnectOptionsWidget;
    ProfileCmdExecAfterConnectOptions *ProfileCmdExecAfterConnectOptionsWidget;
    ProfileCmdExecAfterDisconnectOptions *ProfileCmdExecAfterDisconnectOptionsWidget;

    KPageWidgetItem* ProfileNetworkRouteOptionsFrame;
    KPageWidgetItem* ConfigConnectOptionsFrame;
    KPageWidgetItem* ConfigDaemonOptionsFrame;
    KPageWidgetItem* ConnectOptionsFrame;
    KPageWidgetItem* DebugOptionsFrame;
    KPageWidgetItem* LogOptionsFrame;
    KPageWidgetItem* HelperProgramOptionsFrame;
    KPageWidgetItem* ProfileGeneralOptionsFrame;
    KPageWidgetItem* ProfileSpecificOptionsFrame;
    KPageWidgetItem* ProfileCommandExecOptionsFrame;
    KPageWidgetItem* ProfileAuthenticationOptionsFrame;
    KPageWidgetItem* ProfileUserOptionsFrame;
    KPageWidgetItem* ProfileCertOptionsFrame;
    KPageWidgetItem* ProfileCiscoOptionsFrame;
    KPageWidgetItem* ProfileNetworkHttpProxyOptionsFrame;
    KPageWidgetItem* ProfileCmdExecAfterConnectOptionsFrame;
    KPageWidgetItem* ProfileCmdExecBeforeDisconnectOptionsFrame;
    KPageWidgetItem* ProfileCmdExecAfterDisconnectOptionsFrame;
    KPageWidgetItem* ProfileCmdExecBeforeConnectOptionsFrame;
    KPageWidgetItem* GeneralOptionsFrame;
    KPageWidgetItem* ProfileSmartcardOptionsFrame;
    KPageWidgetItem* ProfilePskOptionsFrame;
    KPageWidgetItem* ProfileNetworkGeneralOptionsFrame;
    KPageWidgetItem* ProfileNetworkNatOptionsFrame;
    KPageWidgetItem* ProfileNetworkVirtualIpOptionsFrame;
    KPageWidgetItem* ProfileRacoonOptionsFrame;
    KPageWidgetItem* ProfileIpsecOptionsFrame;
    KPageWidgetItem* ProfileOpenvpnOptionsFrame;
    KPageWidgetItem* ProfilePptpOptionsFrame;
    KPageWidgetItem* ProfileVtunOptionsFrame;
    KPageWidgetItem* ProfileSshOptionsFrame;

    KComboBox *ProfileGeneralSelector;
    KComboBox *ProfileSpecificSelector;
    KComboBox *ProfileCommandExecSelector;
    KComboBox *ProfileAuthenticationSelector;
    KComboBox *ProfileNetworkRouteSelector;
    KComboBox *ProfileNetworkGeneralSelector;
    KComboBox *ProfileNetworkNatSelector;
    KComboBox *ProfileNetworkVirtualIpSelector;
    KComboBox *ProfileCertSelector;
    KComboBox *ProfileSmartcardSelector;
    KComboBox *ProfilePskSelector;
    KComboBox *ProfileUserSelector;
    KComboBox *ProfileOpenvpnSelector;
    KComboBox *ProfileNetworkHttpProxySelector;
    KComboBox *ProfilePptpSelector;
    KComboBox *ProfileRacoonSelector;
    KComboBox *ProfileIpsecSelector;
    KComboBox *ProfileCiscoSelector;
    KComboBox *ProfileVtunSelector;
    KComboBox *ProfileSshSelector;
    KComboBox *ProfileCmdExecBeforeConnectSelector;
    KComboBox *ProfileCmdExecBeforeDisconnectSelector;
    KComboBox *ProfileCmdExecAfterConnectSelector;
    KComboBox *ProfileCmdExecAfterDisconnectSelector;
	
    bool profileAddedOrDeleted;
    bool profileHasChanged;
    bool showOnlyProfiles;
    QString NewProfileName;
};

#endif
