/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "newprofilewizard.h"

#include <Qt3Support/Q3HBoxLayout>
#include <Qt3Support/Q3ButtonGroup>

#include <QtGui/QCheckBox>
#include <QtGui/QCursor>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPixmap>
#include <QtGui/QPushButton>
#include <QtGui/QRadioButton>
#include <QtGui/QSpinBox>
#include <QtGui/QTreeWidgetItemIterator>
#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

#include <kcombobox.h>
#include <kinputdialog.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <kpassworddialog.h>
#include <kstandarddirs.h>
#include <kurlrequester.h>
#include <kvbox.h>

#include "addnetworkroutedialog.h"
#include "networkinterface.h"
#include "utils.h"

#if defined(QWIZARD_QT4_PORT)
NewProfileWizard::NewProfileWizard(KVpncConfig *GlobalConfig,
                                   QWidget *parent)
    : QWizard(parent)
{
    globalConfiguration = GlobalConfig;
    debugLevel = globalConfiguration->KvpncDebugLevel;

    setPage(Page_Intro, new ProfileIntroductionPage(globalConfiguration));
    setPage(Page_Conclusion, new ProfileConclusionPage(globalConfiguration));

    setStartId(Page_Intro);

#ifndef Q_WS_MAC
    setWizardStyle(ModernStyle);
#endif

    setPixmap(QWizard::LogoPixmap,
              QPixmap(KIconLoader::global()->loadIcon("kvpnc", KIconLoader::Dialog)));

    setWindowTitle(i18n("Add new profile..."));
}

NewProfileWizard::~NewProfileWizard()
{
}

void NewProfileWizard::accept()
{
    QDialog::accept();
}

ProfileIntroductionPage::ProfileIntroductionPage(KVpncConfig *GlobalConfig, QWidget *parent)
    : QWizardPage(parent)
{
    globalConfiguration = GlobalConfig;
    debugLevel = globalConfiguration->KvpncDebugLevel;

    setTitle(i18n("Introduction"));
    setPixmap(QWizard::WatermarkPixmap,
              QPixmap(KStandardDirs::locate("data", "kvpnc/newprofilewizard.png")));

    label = new QLabel(i18n("This wizard will help you to create a new profile."));
    label->setWordWrap(true);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(label);
    setLayout(layout);
}

int ProfileIntroductionPage::nextId() const
{
    return NewProfileWizard::Page_Conclusion;
}

ProfileConclusionPage::ProfileConclusionPage(KVpncConfig *GlobalConfig, QWidget *parent)
    : QWizardPage(parent)
{
    globalConfiguration = GlobalConfig;
    debugLevel = globalConfiguration->KvpncDebugLevel;

    setTitle(i18n("Conclusion"));
    setPixmap(QWizard::WatermarkPixmap,
              QPixmap(KStandardDirs::locate("data", "kvpnc/newprofilewizard_final.png")));

    label = new QLabel();
    label->setWordWrap(true);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(label);
    setLayout(layout);
}

void ProfileConclusionPage::initializePage()
{
    QString finishText = wizard()->buttonText(QWizard::FinishButton);
    finishText.remove('&');
    label->setText(i18n("Click %1 to create your new profile.").arg(finishText));
}
#else
NewProfileWizard::NewProfileWizard(KVpncConfig* GlobalConfig) : Q3Wizard()
{
    this->GlobalConfig = GlobalConfig;

    newProfileCreated = false;
    setWindowTitle(i18n("Add new profile..."));
    //setMinimumSize( 400,300);

    SetupPixmap = new QPixmap(KStandardDirs::locate("data", "kvpnc/newprofilewizard.png"));
    SetupPixmapFinal = new QPixmap(KStandardDirs::locate("data", "kvpnc/newprofilewizard_final.png"));

    // currently static for new profile
    VpnAccountData::ConnectionType ConnType = VpnAccountData::ConnectionType(VpnAccountData::other);
    Port = 500;
    Gateway = "";
    ID = "";
    Username = "";
    UserPassword = "";
    PreSharedKey = "";
    ApplicationVersion = "";
    NtDomainName = "";
    PerfectForwardSecrecy = "";
    IkeGroup = "";
    Description = "";
    Name = "None";
    useApplicationVersion = false;
    useGlobalIpsecSecret = false;
    useIkeGroup = false;
    useLocalPort = false;
    useNtDomainName = false;
    useSingleDes = false;
    useAdvancedSettings = false;
    usePerfectSecrecy = false;
    saveUserPassword = false;
    savePsk = false;
    useUdp = false;
    useUdpPort = false;
    useDnsServer = false;
    DnsServer = "";
    refuse40BitEncryption = true;
    refuse128BitEncryption = false;
    allowStatefulMode = false;
    requireMppe = true;
    useNoBsdComp = true;
    useNoDeflate = true;
    savePsk = false;
    connectaftercreating = true;
    daemonavailable = false;
    enterdatamanually = false;
    importOK = false;


    profileData = new VpnAccountData(ConnType, Name);
    profileData->setGateway(Gateway);
    profileData->setID(ID);
    profileData->setPreSharedKey(PreSharedKey);
    profileData->setSavePsk(savePsk);
    profileData->setUserName(Username);
    profileData->setUserPassword(UserPassword);
    profileData->setSaveUserPassword(saveUserPassword);
    profileData->setSavePsk(savePsk);
    profileData->setApplicationVersion(ApplicationVersion);
    profileData->setUseLocalPort(useLocalPort);
    profileData->setLocalPort(Port);
    profileData->setUseSingleDes(useSingleDes);
    profileData->setPerfectForwardSecrety(PerfectForwardSecrecy);
    profileData->setIkeGroup(IkeGroup);
    profileData->setUseGlobalIpsecSecret(useGlobalIpsecSecret);
    profileData->setUseIkeGroup(useIkeGroup);
    profileData->setNtDomainName(NtDomainName);
    profileData->setUseAdvancedSettings(useAdvancedSettings);
    profileData->setUsePerfectForwardSecrety(usePerfectSecrecy);
    profileData->setUseTlsAuth(false);

    setupPages();

    //  // tmp
    //  newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setEnabled(false);
    //  newprofilewizardtypeselectionpagecontent->RacoonRadioButton->setEnabled(false);
}

void NewProfileWizard::accept()
{

    if (!enterdatamanually) {
        if (profileData->getConnectionType() == VpnAccountData::cisco) {
//    importProfile( VpnAccountData::cisco );
//    if ( importOK )
//     newProfileCreated = true;
//    else
//     newProfileCreated = false;
        }
    } else {
        newProfileCreated = true;
    }
    finished = true;

    if (newProfileCreated && profileData->getAuthType() == VpnAccountData::cert) {}

    Q3Wizard::accept();
}

void NewProfileWizard::reject()
{
    finished = false;
    Q3Wizard::reject();
}

void NewProfileWizard::setupPages()
{

    // setup start page
    startpage = new KHBox(0);
    //  page1->setSpacing(8);
    QLabel *setupPixmapContent1 = new QLabel(startpage);
    setupPixmapContent1->setPixmap(*SetupPixmap);
    setupPixmapContent1->resize(setupPixmapContent1->sizeHint());
    newprofilewizardstartcontent = new NewProfileWizardStart(startpage);
//  newprofilewizardstartcontent->resize ( newprofilewizardstartcontent->sizeHint() );
    startpage->sizeHint();
    addPage(startpage, "<b>" + i18n("Welcome") + "</b>");

    // type selection
    newprofilewizardtypeselectionpage = new KHBox(0);
    //  newprofilewizardtypeselectionpage->setSpacing(8);
    QLabel *setupPixmapContent2 = new QLabel(newprofilewizardtypeselectionpage);
    setupPixmapContent2->setPixmap(*SetupPixmap);
    setupPixmapContent2->resize(setupPixmapContent2->sizeHint());
    newprofilewizardtypeselectionpagecontent = new NewProfileWizardTypeSelection(newprofilewizardtypeselectionpage);
    newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setText(i18n("IPSec (%1)", QString("FreeS/WAN/Openswan/strongSwan")));
    newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->setText(i18n("L2TP over IPSec (%1)" , QString("FreeS/WAN/Openswan/strongSwan")));
//  newprofilewizardtypeselectionpage->sizeHint();
    addPage(newprofilewizardtypeselectionpage, "<b>" + i18n("Type selection") + "</b>");

    // cisco
    newprofilewizardciscoselectionpage = new KHBox(0);
    //  newprofilewizardciscoselectionpage->setSpacing(8);
    QLabel *setupPixmapContent3 = new QLabel(newprofilewizardciscoselectionpage);
    setupPixmapContent3->setPixmap(*SetupPixmap);
    setupPixmapContent3->resize(setupPixmapContent3->sizeHint());
    newprofilewizardciscoselectionpagecontent = new NewProfileWizardCiscoSelection(newprofilewizardciscoselectionpage);
//  newprofilewizardciscoselectionpage->sizeHint();

    newprofilewizardciscomanuallypage = new KHBox(0);
    //  newprofilewizardciscomanuallypage->setSpacing(8);
    QLabel *setupPixmapContent4 = new QLabel(newprofilewizardciscomanuallypage);
    setupPixmapContent4->setPixmap(*SetupPixmap);
    setupPixmapContent4->resize(setupPixmapContent4->sizeHint());
    newprofilewizardciscomanuallypagecontent = new NewProfileWizardCiscoManually(newprofilewizardciscomanuallypage);
//  newprofilewizardciscomanuallypage->sizeHint();
    connect(newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit , SIGNAL(textChanged(const QString&)), this, SLOT(pskToggled(const QString&)));

    // racoon
    newprofilewizardracoonpage = new KHBox(0);
    //  newprofilewizardracoonpage->setSpacing(8);
    QLabel *setupPixmapContent5 = new QLabel(newprofilewizardracoonpage);
    setupPixmapContent5->setPixmap(*SetupPixmap);
    setupPixmapContent5->resize(setupPixmapContent5->sizeHint());
    newprofilewizardracoonpagecontent = new NewProfileWizardRacoon(newprofilewizardracoonpage);
    newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem(0, "main");
    newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem(1, "aggressive");
    newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem(2, "base");
    newprofilewizardracoonpagecontent->ExchangeModeComboBox->setCurrentItem("main");    // main

    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(0, "SHA1");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(1, "MD5");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentItem("SHA1");    //SHA1

    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(0, "modp768");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(1, "modp1024");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(2, "ec2n155");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(3, "ec2n185");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(4, "modp1536");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(5, "modp2048");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(6, "modp3072");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(7, "modp4096");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(8, "modp6144");
    newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem(9, "modp8192");

    newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem(0, "asn1dn");
    newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem(1, "address");
    newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem(2, "fqdn");
    newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem(3, "keyid");
    newprofilewizardracoonpagecontent->LocalIdTypeCombobox->insertItem(4, "user_fqdn");

    newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem(0, "asn1dn");
    newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem(1, "address");
    newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem(2, "fqdn");
    newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem(3, "keyid");
    newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->insertItem(4, "user_fqdn");

    newprofilewizardracoonpagecontent->PerfectForwardSecurityCheckbox->setChecked(true);
    newprofilewizardracoonpagecontent->PerfectForwardSecrecyCombobox->setCurrentItem("modp2048");



    connect(newprofilewizardracoonpagecontent->LocalIdTypeCombobox, SIGNAL(highlighted(const QString&)), this, SLOT(localIDTypeToggled(const QString&)));
    connect(newprofilewizardracoonpagecontent->RemoteIdTypeCombobox, SIGNAL(highlighted(const QString&)), this, SLOT(remoteIDTypeToggled(const QString&)));
    connect(newprofilewizardracoonpagecontent->IkeGroupCheckbox, SIGNAL(toggled(bool)), this, SLOT(ikeGroupToggled(bool)));
    connect(newprofilewizardracoonpagecontent->UseXauthCheckBox, SIGNAL(toggled(bool)), this, SLOT(useXauthRacoonToggled(bool)));

    Utils::IpsecAlgos KernelCrypto = Utils(GlobalConfig).getKernelCrypto();

    // man racoon.conf
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(0, "des");
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(1, "3des");
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(2, "blowfish");
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(3, "cast128");
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(4, "aes");
    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(5, "camellia");

    // man racoon.conf
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(0, "md5");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(1, "sha1");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(2, "sha256");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(3, "sha384");
    newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(4, "sha512");




//   // phase 2 encr algos from kernel
// int IpsecEspEncryptionAlgorithmIdx=0;
//  for ( QStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it )
//  {
    //   newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem (IpsecEspEncryptionAlgorithmIdx, *it );
    // IpsecEspEncryptionAlgorithmIdx++;
//  }
//
//  // phase 2 auth algos from kernel
// int IpsecEspAuthenticationAlgorithmIdx=0;
//  for ( QStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it )
//  {
    //   newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem (IpsecEspAuthenticationAlgorithmIdx,  *it );
    // IpsecEspAuthenticationAlgorithmIdx++;
//  }

    // vpn mit linux book
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(0, "des");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(1, "3des");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(2, "des_iv64");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(3, "des_iv32");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(4, "rc5");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(5, "rc4");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(6, "idea");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(7, "3idea");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(8, "cast128");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(9, "blowfish");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(10, "null_enc");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(11, "twofish");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(12, "rijndael");
    newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(13, "aes");

    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(0, "des");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(1, "3des");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(2, "des_iv64");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(3, "des_iv32");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(4, "hmac_md5");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(5, "hmac_sha1");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(6, "hmac_sha256");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(7, "hmac_sha384");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(8, "hmac_sha512");
    newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(9, "non_auth");


    // FIXME save not implemented yet
    newprofilewizardracoonpagecontent->PerfectForwardSecurityCheckbox->hide();
    newprofilewizardracoonpagecontent->PerfectForwardSecrecyCombobox->hide();

    newprofilewizardracoonpage->sizeHint();

    //freeswan
    newprofilewizardfreeswanselectionpage = new KHBox(0);
    //  newprofilewizardfreeswanselectionpage->setSpacing(8);
    QLabel *setupPixmapContent711 = new QLabel(newprofilewizardfreeswanselectionpage);
    setupPixmapContent711->setPixmap(*SetupPixmap);
    setupPixmapContent711->resize(setupPixmapContent711->sizeHint());
    newprofilewizardfreeswanselectionpagecontent  = new NewProfileWizardOpenvpnSelection(newprofilewizardfreeswanselectionpage);
    newprofilewizardfreeswanselectionpagecontent->OpenvpnImportRadioButton->setText(i18n("Import &Ipsec config file"));
    newprofilewizardfreeswanselectionpage->sizeHint();

    newprofilewizardfreeswanpage = new KHBox(0);
    //  newprofilewizardfreeswanpage->setSpacing(8);
    QLabel *setupPixmapContent6 = new QLabel(newprofilewizardfreeswanpage);
    setupPixmapContent6->setPixmap(*SetupPixmap);
    setupPixmapContent6->resize(setupPixmapContent6->sizeHint());
    newprofilewizardfreeswanpagecontent = new NewProfileWizardFreeswan(newprofilewizardfreeswanpage);
    newprofilewizardfreeswanpage->sizeHint();

    //freeswan
    newprofilewizardfreeswanpage = new KHBox(0);
    //  newprofilewizardfreeswanpage->setSpacing(8);
    QLabel *setupPixmapContent66 = new QLabel(newprofilewizardfreeswanpage);
    setupPixmapContent66->setPixmap(*SetupPixmap);
    setupPixmapContent66->resize(setupPixmapContent66->sizeHint());
    newprofilewizardfreeswanpagecontent = new NewProfileWizardFreeswan(newprofilewizardfreeswanpage);

    newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(0, "asn1dn");
    newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(1, "address");
    newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(2, "fqdn");
    newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(3, "keyid");
    newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->insertItem(4, "user_fqdn");

    newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->insertItem(0, "transport");
    newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->insertItem(1, "tunnel");

    newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->KComboBox::setCurrentIndex(1);
    newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->setChecked(true);
    newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->hide();


    connect(newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox, SIGNAL(highlighted(const QString&)), this, SLOT(localIDTypeIpsecToggled(const QString&)));

    connect(newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox, SIGNAL(toggled(bool)), this, SLOT(useEspToogled(bool)));
    connect(newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox, SIGNAL(toggled(bool)), this, SLOT(useIkeToggled(bool)));
    connect(newprofilewizardfreeswanpagecontent->UseLeftNextHopCheckBox, SIGNAL(toggled(bool)), this, SLOT(useLeftNextHopToggled(bool)));
    connect(newprofilewizardfreeswanpagecontent->UseRightNextHopCheckBox, SIGNAL(toggled(bool)), this, SLOT(useRightNextHopToggled(bool)));
    connect(newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox, SIGNAL(activated(const QString&)), this, SLOT(localIDTypeIpsecToggled(const QString&)));
    connect(newprofilewizardfreeswanpagecontent->UseXauthCheckBox, SIGNAL(toggled(bool)), this, SLOT(useXauthFreeswanToggled(bool)));

    newprofilewizardfreeswanpage->sizeHint();

    // openvpn
    newprofilewizardopenvpnselectionpage = new KHBox(0);
    //  newprofilewizardopenvpnselectionpage->setSpacing(8);
    QLabel *setupPixmapContent7 = new QLabel(newprofilewizardopenvpnselectionpage);
    setupPixmapContent7->setPixmap(*SetupPixmap);
    setupPixmapContent7->resize(setupPixmapContent7->sizeHint());
    newprofilewizardopenvpnselectionpagecontent = new NewProfileWizardOpenvpnSelection(newprofilewizardopenvpnselectionpage);
    newprofilewizardopenvpnselectionpage->sizeHint();

    newprofilewizardopenvpnauthpage = new KHBox(0);
    //  newprofilewizardopenvpnauthpage->setSpacing(8);
    QLabel *setupPixmapContent71 = new QLabel(newprofilewizardopenvpnauthpage);
    setupPixmapContent71->setPixmap(*SetupPixmap);
    setupPixmapContent71->resize(setupPixmapContent71->sizeHint());
    newprofilewizardopenvpnauthpagecontent = new NewProfileWizardOpenvpnAuth(newprofilewizardopenvpnauthpage);
    newprofilewizardopenvpnauthpage->sizeHint();
    connect(newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, SIGNAL(toggled(bool)), this, SLOT(authenticateWithUsernameAndPasswordToggled(bool)));
    connect(newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox, SIGNAL(toggled(bool)), this, SLOT(useAuthenticationAlgorithmToggled(bool)));

    newprofilewizardopenvpnpage = new KHBox(0);
    //  newprofilewizardopenvpnpage->setSpacing(8);
    QLabel *setupPixmapContent8 = new QLabel(newprofilewizardopenvpnpage);
    setupPixmapContent8->setPixmap(*SetupPixmap);
    setupPixmapContent8->resize(setupPixmapContent8->sizeHint());
    newprofilewizardopenvpnpagecontent = new NewProfileWizardOpenvpn(newprofilewizardopenvpnpage);
    newprofilewizardopenvpnpage->sizeHint();
    newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem(0, "tun");
    newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem(1, "tap");
    newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem(0, "client");
    newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem(1, "server");
    newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled(false);
    newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled(false);

    newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->setChecked(false);
    newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->setChecked(false);
    newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked(false);
    newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setChecked(false);
    newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked(false);
    newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->setChecked(false);

    connect(newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox , SIGNAL(toggled(bool)), this, SLOT(userdefinedOpenvpnPortToggeled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox , SIGNAL(toggled(bool)), this, SLOT(nsCertTypeOpenvpnToggled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox, SIGNAL(toggled(bool)), this, SLOT(userdefinedOpenvpnPortToggeled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox, SIGNAL(toggled(bool)), this, SLOT(useTlsAuthToggled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox, SIGNAL(toggled(bool)), this, SLOT(useTlsRemoteHostToggled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox, SIGNAL(toggled(bool)), this, SLOT(useUserdefiniedCipherToggled(bool)));
    connect(newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox, SIGNAL(toggled(bool)), this, SLOT(useHttpProxyToggeled(bool)));

    QStringList ciphers = Utils(GlobalConfig).getOpenvpnCiphers();
    QStringList digests = Utils(GlobalConfig).getOpenvpnDigests();

    int CipherIdx = 0;
    for (QStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it) {
        newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->insertItem(CipherIdx, *it);
        CipherIdx++;
    }

    int digestsIdx = 0;
    for (QStringList::Iterator it = digests.begin(); it != digests.end(); ++it) {
        newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->insertItem(digestsIdx, *it);
        digestsIdx++;
    }

    // pptp
    newprofilewizardpptppage = new KHBox(0);
    //  newprofilewizardpptppage->setSpacing(8);
    QLabel *setupPixmapContent9 = new QLabel(newprofilewizardpptppage);
    setupPixmapContent9->setPixmap(*SetupPixmap);
    setupPixmapContent9->resize(setupPixmapContent9->sizeHint());
    newprofilewizardpptppagecontent = new NewProfileWizardPptp(newprofilewizardpptppage);
    newprofilewizardpptppage->sizeHint();
    newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled(false);
    newprofilewizardpptppagecontent->RequireMppeCheckbox->setChecked(profileData->getRequireMppe());
    newprofilewizardpptppagecontent->Refuse128BitEncryptionCheckbox->setChecked(profileData->getRefuse128BitEncryption());
    newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->setChecked(profileData->getRefuse40BitEncryption());
    newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->setChecked(profileData->getDisableMPPEComp());
    newprofilewizardpptppagecontent->DnsServerCheckbox->setChecked(profileData->getUseDnsUpdate());
    newprofilewizardpptppagecontent->DnsServerCheckbox->setChecked(profileData->getUseDnsServer());
    newprofilewizardpptppagecontent->DnsServerLineedit->setText(profileData->getDnsServer());
    newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->setChecked(profileData->getUseNoBsdComp());
    newprofilewizardpptppagecontent->UseNoDeflateCheckbox->setChecked(profileData->getUseNoDeflate());
    newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->setChecked(profileData->getAllowStatefulMode());
    newprofilewizardpptppagecontent->UseNoIpDefaultCheckbox->setChecked(profileData->getUseNoIpDefault());
    newprofilewizardpptppagecontent->DisableCcpCheckbox->setChecked(profileData->getDisableCcp());
    newprofilewizardpptppagecontent->DisableHeaderCompressionCheckbox->setChecked(profileData->getDisableHeaderCompression());
    newprofilewizardpptppagecontent->DisableMagicNumberNegotiationCheckbox->setChecked(profileData->getDisableMagicNumberNegotiation());
    newprofilewizardpptppagecontent->DisableIpxCheckbox->setChecked(profileData->getDisableIpx());
    newprofilewizardpptppagecontent->DisableAddressControlCompressionCheckbox->setChecked(profileData->getDisableAddressControlCompression());
    newprofilewizardpptppagecontent->DisableProtocolFieldCompressionCheckbox->setChecked(profileData->getDisableProtocolFieldCompression());


    newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem(0, "chap");
    newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem(1, "pap");
    newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem(2, "mschap");
    newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem(3, "mschap-v2");

    connect(newprofilewizardpptppagecontent->DnsServerCheckbox, SIGNAL(toggled(bool)), this, SLOT(useDnsServerToggled(bool)));
    connect(newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox, SIGNAL(toggled(bool)), this, SLOT(useSearchDomainInResolvConfToggled(bool)));

    // vtun
    newprofilewizardvtunpage = new KHBox(0);
    //  newprofilewizardvtunpage->setSpacing(8);
    QLabel *setupPixmapContent19 = new QLabel(newprofilewizardvtunpage);
    setupPixmapContent19->setPixmap(*SetupPixmap);
    setupPixmapContent19->resize(setupPixmapContent19->sizeHint());
    newprofilewizardvtunpagecontent = new ProfileVtunOptions(newprofilewizardvtunpage);
    newprofilewizardvtunpage->sizeHint();
    connect(newprofilewizardvtunpagecontent->PortCheckbox, SIGNAL(toggled(bool)), this, SLOT(usePortToggled(bool)));

    // ssh
    newprofilewizardsshpage = new KHBox(0);
    //  newprofilewizardsshpage->setSpacing(8);
    QLabel *setupPixmapContent191 = new QLabel(newprofilewizardsshpage);
    setupPixmapContent191->setPixmap(*SetupPixmap);
    setupPixmapContent191->resize(setupPixmapContent191->sizeHint());
    newprofilewizardsshpagecontent = new ProfileSshOptions(newprofilewizardsshpage);
    newprofilewizardsshpage->sizeHint();

    QByteArray Home = qgetenv("HOME");
    if (!Home.isEmpty()) {
        QDir dir(Home + "/.ssh");
        QStringList KeyFiles = dir.entryList(QStringList("*"), QDir::Files);

        //if (GlobalConfig->KvpncDebugLevel > 2)
        //{
        // GlobalConfig->appendLogEntry(i18n("SSH files: %1", QString(KeyFiles.join(","))),KVpncEnum::debug);
        //}

        if (KeyFiles.size() > 1) {
            int KeyFilesIdx = 0;
            for (QStringList::Iterator it = KeyFiles.begin(); it != KeyFiles.end(); ++it) {
                QString item = QString(*it);
                if (GlobalConfig->KvpncDebugLevel > 2) {
                    //GlobalConfig->appendLogEntry(i18n("processing entry: %1", QString(item),KVpncEnum::debug);
                }
                if (!item.contains(".pub", Qt::CaseInsensitive)  && !item.contains("authorized_keys", Qt::CaseInsensitive)  && !item.contains("known_hosts", Qt::CaseInsensitive) && !item.contains(".", Qt::CaseInsensitive) && !item.contains("..", Qt::CaseInsensitive) && !item.contains("config", Qt::CaseInsensitive)) {
                    if (GlobalConfig->KvpncDebugLevel > 2) {
                        GlobalConfig->appendLogEntry(i18n("SSH key found: %1", QString(*it)), KVpncEnum::debug);
                    }
                    newprofilewizardsshpagecontent->SshKeyComboBox->insertItem(KeyFilesIdx, *it);
                    KeyFilesIdx++;
                }
            }
        }
    }


    newprofilewizardauthselectionpage = new KHBox(0);
    //  newprofilewizardauthselectionpage->setSpacing(8);
    QLabel *setupPixmapContent81 = new QLabel(newprofilewizardauthselectionpage);
    setupPixmapContent81->setPixmap(*SetupPixmap);
    setupPixmapContent81->resize(setupPixmapContent81->sizeHint());
    newprofilewizardauthselectioncontent = new NewProfileWizardAuthSelection(newprofilewizardauthselectionpage);
    newprofilewizardauthselectionpage->sizeHint();
    newprofilewizardauthselectioncontent->CertificateRadioButton->setChecked(true);
    newprofilewizardauthselectioncontent->HybridRadioButton->hide();


    // virtual ip
    newprofilewizardvirtualipaddresspage = new KHBox(0);
    QLabel *setupPixmapContent_virtualip = new QLabel(newprofilewizardvirtualipaddresspage);
    setupPixmapContent_virtualip->setPixmap(*SetupPixmap);
    setupPixmapContent_virtualip->resize(setupPixmapContent_virtualip->sizeHint());
    profilenetworkvirtualipoptionscontent = new ProfileNetworkVirtualIpOptions(newprofilewizardvirtualipaddresspage);
    newprofilewizardvirtualipaddresspage->sizeHint();
    insertPage(newprofilewizardvirtualipaddresspage, "<b>" + i18n("Virtual IP address options") + "</b>", -1);
    connect(profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox, SIGNAL(toggled(bool)), this, SLOT(useVirtualIpAddressToggled(bool)));

    // psk
    newprofilewizardpskpage = new KHBox(0);
    //  newprofilewizardpskpage->setSpacing(8);
    QLabel *setupPixmapContent72 = new QLabel(newprofilewizardpskpage);
    setupPixmapContent72->setPixmap(*SetupPixmap);
    setupPixmapContent72->resize(setupPixmapContent72->sizeHint());
    newprofilewizardpskcontent = new NewProfileWizardPsk(newprofilewizardpskpage);
    newprofilewizardpskpage->sizeHint();

    connect(newprofilewizardpskcontent->PskInFileCheckBox , SIGNAL(toggled(bool)), this, SLOT(pskIsInFileToggled(bool)));
    connect(newprofilewizardpskcontent->PSKLineEdit , SIGNAL(textChanged(const QString &)), this, SLOT(pskInputToggled(const QString&)));

    newprofilewizardp12certselectionpage = new KHBox(0);
    //  newprofilewizardp12certselectionpage->setSpacing(8);
    QLabel *setupPixmapContent74 = new QLabel(newprofilewizardp12certselectionpage);
    setupPixmapContent74->setPixmap(*SetupPixmap);
    setupPixmapContent74->resize(setupPixmapContent74->sizeHint());
    newprofilewizardp12certselectioncontent = new NewProfileWizardP12CertSelection(newprofilewizardp12certselectionpage);
    newprofilewizardp12certselectionpage->sizeHint();
    connect(newprofilewizardp12certselectioncontent->UseSmartcardCheckBox, SIGNAL(toggled(bool)), this, SLOT(useSmartcardOnCertFormateToggled(bool)));

    // cert
    newprofilewizardcertpage = new KHBox(0);
    //  newprofilewizardcertpage->setSpacing(8);
    QLabel *setupPixmapContent73 = new QLabel(newprofilewizardcertpage);
    setupPixmapContent73->setPixmap(*SetupPixmap);
    setupPixmapContent73->resize(setupPixmapContent73->sizeHint());
    newprofilewizardcertcontent = new NewProfileWizardCert(newprofilewizardcertpage);
    newprofilewizardcertpage->sizeHint();
    connect(newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox , SIGNAL(toggled(bool)), this, SLOT(useSpecialServerCertificateToggled(bool)));
    connect(newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox , SIGNAL(toggled(bool)), this, SLOT(useSpecialRemoteIDToggled(bool)));
    connect(newprofilewizardcertcontent->UseSmartcardCheckBox, SIGNAL(toggled(bool)), this, SLOT(useSmartcardToggled(bool)));
    connect(newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox, SIGNAL(toggled(bool)), this, SLOT(usePkcs11ProvidersToggled(bool)));
    connect(newprofilewizardcertcontent->DetectPkcs11SlotsPushButton, SIGNAL(clicked()), this, SLOT(detectPkcs11Slots()));
    connect(newprofilewizardcertcontent->DetectPkcs11IdPushButton, SIGNAL(clicked()), this, SLOT(detectPkcs11Ids()));
    newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->setEnabled(false);
    newprofilewizardcertcontent->Pkcs11SlotTypeLabel->setEnabled(false);
    newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setUrl(KUrl("/usr/local/lib/libetpkcs11.so"));


    // user
    newprofilewizarduserpage = new KHBox(0);
    //  newprofilewizarduserpage->setSpacing(8);
    QLabel *setupPixmapContent75 = new QLabel(newprofilewizarduserpage);
    setupPixmapContent75->setPixmap(*SetupPixmap);
    setupPixmapContent75->resize(setupPixmapContent75->sizeHint());
    newprofilewizarduserpagecontent = new NewProfileWizardUser(newprofilewizarduserpage);
    newprofilewizarduserpage->sizeHint();

    connect(newprofilewizarduserpagecontent->PasswordEdit , SIGNAL(textChanged(const QString&)), this, SLOT(userpassToggled(const QString&)));
    connect(newprofilewizarduserpagecontent->UsernameLineEdit , SIGNAL(textChanged(const QString&)), this, SLOT(usernameToggled(const QString&)));
    connect(newprofilewizarduserpagecontent->NtDomainNameCheckbox, SIGNAL(toggled(bool)), this, SLOT(domainNameToggled(bool)));
    newprofilewizarduserpagecontent ->NtDomainNameCheckbox->setEnabled(true);
    newprofilewizarduserpagecontent ->NtDomainNameCheckbox->hide();
    newprofilewizarduserpagecontent ->NtDomainNameLineedit->hide();


    // network
    newprofilewizardnetworkpage = new KHBox(0);
    //  newprofilewizardnetworkpage->setSpacing(8);
    QLabel *setupPixmapContent76 = new QLabel(newprofilewizardnetworkpage);
    setupPixmapContent76->setPixmap(*SetupPixmap);
    setupPixmapContent76->resize(setupPixmapContent76->sizeHint());
    newprofilewizardnetworkcontent = new NewProfileWizardNetwork(newprofilewizardnetworkpage);
    newprofilewizardnetworkpage->sizeHint();
    int NetworkDeviceIdx = 0;
    newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem(NetworkDeviceIdx, "default");
    NetworkDeviceIdx++;

    NetworkInterface iface(GlobalConfig, GlobalConfig->appPointer);
    QStringList list = iface.getAllNetworkInterfaces();
    for (QStringList::Iterator it = list.begin(); it != list.end(); ++it)
        newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem(NetworkDeviceIdx, QString(*it));

    newprofilewizardnetworkcontent->MtuSpinbox->hide();
    newprofilewizardnetworkcontent->MtuCheckbox->hide();
    newprofilewizardnetworkcontent->MruSpinbox->hide();
    newprofilewizardnetworkcontent->MruCheckbox->hide();

    newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->hide();
    newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->hide();

    newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->insertItem(0, "tun");
    newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->insertItem(1, "tap");

    connect(newprofilewizardnetworkcontent->MtuCheckbox, SIGNAL(toggled(bool)), this, SLOT(mtuToggled(bool)));
    connect(newprofilewizardnetworkcontent->MtuCheckbox, SIGNAL(toggled(bool)), this, SLOT(mtuToggled(bool)));
    connect(newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox, SIGNAL(toggled(bool)) , this, SLOT(useRemoteNetworkToggled(bool)));
    connect(newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox, SIGNAL(activated(const QString &)), this, SLOT(tunnelDeviceTypeChanged(const QString&)));

    // network routes
    newprofilewizardnetworkroutepage = new KHBox(0);
    //  newprofilewizardnetworkroutepage->setSpacing(8);
    QLabel *setupPixmapContent761 = new QLabel(newprofilewizardnetworkroutepage);
    setupPixmapContent761->setPixmap(*SetupPixmap);
    setupPixmapContent761->resize(setupPixmapContent761->sizeHint());
    newprofilewizardnetworkroutecontent = new ProfileNetworkRouteOptions(newprofilewizardnetworkroutepage);
    newprofilewizardnetworkroutepage->sizeHint();

    connect(newprofilewizardnetworkroutecontent->DefaultRouteComboBox, SIGNAL(activated(const QString&)), this, SLOT(defaultRouteToggled(const QString&)));

    newprofilewizardnetworkroutecontent->DefaultRouteComboBox->KComboBox::setCurrentIndex(1);


    // nat
    newprofilewizardnatpage = new KHBox(0);
    //  newprofilewizardnatpage->setSpacing(8);
    QLabel *setupPixmapContent77 = new QLabel(newprofilewizardnatpage);
    setupPixmapContent77->setPixmap(*SetupPixmap);
    setupPixmapContent77->resize(setupPixmapContent77->sizeHint());
    newprofilewizardnatcontent = new NewProfileWizardNat(newprofilewizardnatpage);
    newprofilewizardnatpage->sizeHint();
    newprofilewizardnatcontent->UseUdpCheckbox->setChecked(true);
    connect(newprofilewizardnatcontent->UseUdpCheckbox, SIGNAL(toggled(bool)), this, SLOT(useUdpToggled(bool)));
    connect(newprofilewizardnatcontent->UdpPortCheckbox, SIGNAL(toggled(bool)), this, SLOT(udpPortToggled(bool)));


    // connectionstatuscheck
    newprofilewizardconnectionstatuscheckpage = new KHBox(0);
    //  newprofilewizardconnectionstatuscheckpage->setSpacing(8);
    QLabel *setupPixmapContent79 = new QLabel(newprofilewizardconnectionstatuscheckpage);
    setupPixmapContent79->setPixmap(*SetupPixmap);
    setupPixmapContent79->resize(setupPixmapContent79->sizeHint());
    newprofilewizardconnectionstatuscheckcontent = new NewProfileWizardConnectionStatusCheck(newprofilewizardconnectionstatuscheckpage);
    newprofilewizardconnectionstatuscheckpage->sizeHint();
    insertPage(newprofilewizardconnectionstatuscheckpage, "<b>" + i18n("Connection status check") + "</b>", -1);
    connect(newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox, SIGNAL(toggled(bool)), this, SLOT(pingIpAfterConnectToggled(bool)));
    connect(newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox, SIGNAL(toggled(bool)), this, SLOT(connectionStatusCheckToggled(bool)));

    // connectoptions
    newprofilewizardconnectoptionspage = new KHBox(0);

    //  newprofilewizardconnectoptionspage->setSpacing(8);
    QLabel *setupPixmapContent80 = new QLabel(newprofilewizardconnectoptionspage);
    setupPixmapContent80->setPixmap(*SetupPixmap);
    setupPixmapContent80->resize(setupPixmapContent80->sizeHint());
    newprofilewizardconnectoptionscontent = new NewProfileWizardConnectOptions(newprofilewizardconnectoptionspage);
    newprofilewizardconnectoptionspage->sizeHint();
    newprofilewizardconnectoptionscontent->DoAutoConnectCheckBox->hide(); //TODO later
    newprofilewizardconnectoptionscontent->AutoConnectProfileComboBox->hide(); //TODO_ later
    insertPage(newprofilewizardconnectoptionspage, "<b>" + i18n("Connect options") + "</b>", -1);

    // general
    newprofilewizardgeneralpage = new KHBox(0);
    //  newprofilewizardgeneralpage->setSpacing(8);
    QLabel *setupPixmapContent78 = new QLabel(newprofilewizardgeneralpage);
    setupPixmapContent78->setPixmap(*SetupPixmap);
    setupPixmapContent78->resize(setupPixmapContent78->sizeHint());
    newprofilewizardgeneralpagecontent = new NewProfileWizardGeneral(newprofilewizardgeneralpage);
    newprofilewizardgeneralpage->sizeHint();
    insertPage(newprofilewizardgeneralpage, "<b>" + i18n("General settings") + "</b>", -1);

    // setup end page
    endpage = new KHBox(0);
    //  endpage->setSpacing(8);
    QLabel *setupPixmapContent11 = new QLabel(endpage);
    setupPixmapContent11->setPixmap(*SetupPixmapFinal);
    setupPixmapContent11->resize(setupPixmapContent11->sizeHint());
    QLabel *endpagecontent = new QLabel(endpage);
    endpagecontent->setMargin(11);
    endpagecontent->setText(i18n("Now you have completed all steps for creating a new profile.\nClick \"Finish\" to continue."));
    endpagecontent->setMaximumSize(endpagecontent->sizeHint());
    endpage->sizeHint();
    insertPage(endpage, "<b>" + i18n("Finish") + "</b>", -1);       // last page
}

void NewProfileWizard::next()
{
    // called at each finish of a page
    bool ok = true;
    QString msg = i18n("Please fill in all fields.");

    if (currentpage == startpage) {
        // nothing here
    } else if (currentpage == newprofilewizardgeneralpage) {
        msg = i18n("These fields must be filled in:\n");
        if (newprofilewizardgeneralpagecontent->NameLineEdit->text().isEmpty()) {
            ok = false;
            msg += "- " + i18n("Name") + "\n";
            GlobalConfig->appendLogEntry(i18n("Name is empty."), KVpncEnum::error);
        } else {
            QString Name = newprofilewizardgeneralpagecontent->NameLineEdit->text();


            bool nameOk = true;
            if (Name.contains(' ', Qt::CaseInsensitive)) {
                KMessageBox::error(this, i18n("Profile name cannot contain spaces."), i18n("Spaces Not Allowed"));
                GlobalConfig->appendLogEntry(i18n("Profile name cannot contain spaces.") , KVpncEnum::error);

                nameOk = false;
            }

            if (Name.isEmpty()) {
                KMessageBox::error(this, i18n("Profile name cannot be empty."), i18n("No Name Entered"));
                GlobalConfig->appendLogEntry(i18n("Profile name cannot be empty.") , KVpncEnum::error);

                nameOk = false;
            }

            VpnAccountData * it = 0L;
            while (nameOk == false) {
                for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
                    it = GlobalConfig->AccountList->at(accountIdx);
                    if (it->getName() == Name) {
                        //account->setName( QString( account->getName() + "_2" ) );
                        //     KMessageBox::information ( this, i18n( "Profile name exists!\n It will be renamed to \"%1\"." , QString( account->getName() )), i18n( "Name exist, renamed" ) );
                        KMessageBox::error(this, i18n("Profile name exists."), i18n("Name Exists"));

                        QString newName = KInputDialog::getText(i18n("New Name"), i18n("New name for profile:"), QString(Name += "_2"), &ok);

                        if (!Name.isEmpty()) {
                            nameOk = true;
                            break;
                        }
                    }
                    nameOk = true;
                }
                nameOk = true;
            }

            if (nameOk) {
                profileData->setName(Name);

                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("Profile name: %1" , QString(profileData->getName())), KVpncEnum::debug);

                newProfileCreated = true;
            } else {
                return ;
            }
        }

        if (newprofilewizardgeneralpagecontent->gatewayLineEdit->text().isEmpty()) {
            ok = false;
            msg += "- " + i18n("Gateway") + "\n";
            GlobalConfig->appendLogEntry(i18n("Gateway is empty."), KVpncEnum::error);
        } else {
            profileData->setGateway(newprofilewizardgeneralpagecontent->gatewayLineEdit->text());
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Gateway: %1" , newprofilewizardgeneralpagecontent->gatewayLineEdit->text()), KVpncEnum::debug);
        }
        profileData->setDescription(newprofilewizardgeneralpagecontent->DescriptionLineEdit->text());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Description: %1" , newprofilewizardgeneralpagecontent->DescriptionLineEdit->text()), KVpncEnum::debug);
    } else if (currentpage == newprofilewizardtypeselectionpage) {
        if (newprofilewizardtypeselectionpagecontent->CiscoRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::cisco);
            removePage(newprofilewizardcertpage);
            removePage(newprofilewizardpskpage);
            removePage(newprofilewizardp12certselectionpage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardvirtualipaddresspage);
            newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();
//    newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
//    newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
//    newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
//    newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
//    newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

            newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
            newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();

            insertPage(newprofilewizardciscoselectionpage, "<b>" + i18n("Cisco selection") + "</b>", indexOf(currentpage) + 1);

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("Cisco (free)")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->CiscoVpncRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::ciscoorig);
//    removePage ( newprofilewizardcertpage );
            removePage(newprofilewizardpskpage);
            removePage(newprofilewizardp12certselectionpage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardvirtualipaddresspage);
            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
            newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

            newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
            newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();

            insertPage(newprofilewizardciscoselectionpage, "<b>" + i18n("Cisco selection") + "</b>", indexOf(currentpage) + 1);


            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("Cisco (proprietary)")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::freeswan);
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardvirtualipaddresspage);

            insertPage(newprofilewizardfreeswanpage, "<b>" + i18n("FreeSWAN/OpenSWAN/stronGswan settings") + "</b>", indexOf(currentpage) + 1);

            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem(0, "main");
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem(1, "aggressive");
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setCurrentItem("main");    // main
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setEnabled(true);

            newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->KComboBox::setCurrentIndex(1); // tunnel

            newprofilewizardcertcontent->certpathURLRequester->setUrl(KUrl("/etc/ipsec.d/cacerts"));
            newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(false);
            newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentItem(i18n("ID"));

//    profileData->setIkeGroup ( "modp2048" ); // default for windows?!
//    profileData->setAuthenticationAlgorithm ( "hmac_md5" ); // default for windows?!
//    profileData->setHashAlgo ( "sha1" ); // default for windows?!


//    newprofilewizardfreeswanpagecontent->InfoLabel->setText ( i18n ( "Please enter %1 specific settings:", QString("FreeS/WAN/Openswan/strongSwan" )) );
            insertPage(newprofilewizardfreeswanselectionpage, "<b>" + i18n("IPSec selection") + "</b>", indexOf(currentpage) + 1);


            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("FreeS/WAN/Openswan/strongSwan")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::racoon);
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardvirtualipaddresspage);


//    profileData->setIkeGroup ( "modp2048" ); // default for windows?!
//    profileData->setHashAlgo ( "sha1" ); // default for windows?!
//    profileData->setAuthenticationAlgorithm ( "hmac_md5" );

            profileData->setUseMailAddressAsIdentifier(false);

//    newprofilewizardracoonpagecontent->DHGroupComboBox->setCurrentItem ( profileData->getIkeGroup() );
//    newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->setCurrentItem ( profileData->getAuthenticationAlgorithm() );
//    newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentItem ( profileData->getEncryptionAlgorithm() );

            Utils::IpsecAlgos KernelCrypto = Utils(GlobalConfig).getKernelCrypto();

            // man racoon.conf
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(0, "des");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(1, "3des");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(2, "blowfish");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(3, "cast128");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(4, "aes");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(5, "camellia");

            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentItem("3des");

            // man racoon.conf
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(0, "md5");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(1, "sha1");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(2, "sha256");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(3, "sha384");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(4, "sha512");

            newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentItem("md5");

            // vpn mit linux book
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(0, "des");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(1, "3des");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(2, "des_iv64");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(3, "des_iv32");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(4, "rc5");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(5, "rc4");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(6, "idea");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(7, "3idea");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(8, "cast128");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(9, "blowfish");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(10, "null_enc");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(11, "twofish");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(12, "rijndael");
            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(13, "aes");

            newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->setCurrentItem("3des");

            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(0, "des");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(1, "3des");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(2, "des_iv64");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(3, "des_iv32");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(4, "hmac_md5");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(5, "hmac_sha1");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(6, "hmac_sha256");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(7, "hmac_sha384");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(8, "hmac_sha512");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(9, "non_auth");

            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->setCurrentItem("hmac_md5");

            int EncryptionAlgorithm2Idx = 0;
            for (QStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it) {
                newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(EncryptionAlgorithm2Idx, *it);
                EncryptionAlgorithm2Idx++;
            }

            newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
            newprofilewizardcertcontent->SmartcardGroupBox->hide();
            newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();


            insertPage(newprofilewizardauthselectionpage, i18n("Authentication settings"), indexOf(currentpage) + 1);
            insertPage(newprofilewizardracoonpage, "<b>" + i18n("Racoon settings") + "</b>", indexOf(currentpage) + 2);

            newprofilewizardauthselectioncontent->HybridRadioButton->show();


            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("Racoon")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->L2tpRacoonRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::l2tpd_racoon);
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardnetworkpage);
            removePage(newprofilewizardvirtualipaddresspage);

            profileData->setUseMailAddressAsIdentifier(false);

//    profileData->setIkeGroup ( "modp2048" ); // default for windows?!
//    profileData->setHashAlgo ( "sha1" ); // default for windows?!
//    profileData->setAuthenticationAlgorithm ( "hmac_md5" ); // default for windows?

            Utils::IpsecAlgos KernelCrypto = Utils(GlobalConfig).getKernelCrypto();

            //FIXME why this is not in kernel crypto list???
//  newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem ( "3des" );

            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(0, "des");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(1, "des_iv64");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(2, "des_iv32");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(3, "rc5");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(4, "rc4");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(5, "idea");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(6, "3idea");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(7, "cast128");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(8, "blowfish");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(9, "null_enc");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(10, "twofish");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(11, "rijndael");
            newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem(12, "aes");

            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(0, "md5");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(1, "sha1");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(2, "sha256");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(3, "sha384");
            newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem(4, "sha512");

            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(0, "des");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(1, "3des");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(2, "des_iv64");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(3, "des_iv32");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(4, "hmac_md5");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(5, "hmac_sha1");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(6, "hmac_sha256");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(7, "hmac_sha384");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(8, "hmac_sha512");
            newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem(9, "non_auth");
//    // int IpsecIkeEncryptionAlgorithmIdx=0;
//  for ( QStringList::Iterator it = KernelCrypto.IpsecIkeEncryptionAlgorithms.begin(); it !=  KernelCrypto.IpsecIkeEncryptionAlgorithms.end(); ++it )
//  {
            //   newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem (IpsecIkeEncryptionAlgorithmIdx, *it );
            // IpsecIkeEncryptionAlgorithmIdx++;
//  }
//
// int IpsecIkeHashAlgorithmIdx=0;
//  for ( QStringList::Iterator it = KernelCrypto.IpsecIkeHashAlgorithms.begin(); it != KernelCrypto.IpsecIkeHashAlgorithms.end(); ++it )
//  {
            //   newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem ( IpsecIkeHashAlgorithmIdx, *it );
            // IpsecIkeHashAlgorithmIdx++;
//  }
            int IpsecEspEncryptionAlgorithmIdx = 0;
            for (QStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it) {
                newprofilewizardracoonpagecontent->EncryptionAlgorithm2ComboBox->insertItem(IpsecEspEncryptionAlgorithmIdx, *it);
                IpsecEspEncryptionAlgorithmIdx++;
            }
            // int IpsecEspAuthenticationAlgorithm=0;
//  for ( QStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it )
//  {
            //   newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->insertItem (IpsecEspAuthenticationAlgorithm, *it );
            // IpsecEspAuthenticationAlgorithm++;
//  }
            insertPage(newprofilewizardracoonpage, "<b>" + i18n("Racoon settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardauthselectionpage, i18n("Authentication settings"), indexOf(currentpage) + 2);
            insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 3);

            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
            newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
            newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
            newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
            newprofilewizardcertcontent->SmartcardGroupBox->hide();
            newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();
            newprofilewizardcertcontent->certpathURLRequester->setUrl(KUrl("/etc/racoon/"));

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("L2TP (racoon)")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::l2tpd_freeswan);
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardnetworkpage);
            removePage(newprofilewizardvirtualipaddresspage);

            profileData->setUseMailAddressAsIdentifier(false);

            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem(0, "main");
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->insertItem(1, "aggressive");
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setCurrentItem("main");    // main
            newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->setEnabled(true);
            newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->KComboBox::setCurrentIndex(1); // transport
            newprofilewizardfreeswanpagecontent->IpsecVpnModeCombobox->setEnabled(false);


            newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
            newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
            newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(false);
            newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentItem(i18n("ID"));
            newprofilewizardauthselectioncontent->CertificateRadioButton->setText(i18n("&Certificate/Smartcard"));
            newprofilewizardcertcontent->certpathURLRequester->setUrl(KUrl("/etc/ipsec.d/cacerts"));

//    newprofilewizardfreeswanpagecontent->InfoLabel->setText ( i18n ( "Please enter %1 specific settings:", QString( "FreeS/WAN/Openswan/strongSwan" ) ));

            insertPage(newprofilewizardfreeswanselectionpage, "<b>" + i18n("IPSec selection") + "</b>", indexOf(currentpage) + 1);

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("L2TP (OpenS/WAN)")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::openvpn);
            profileData->setLocalPort(1194);
            profileData->setRemotePort(1194);
            profileData->setUserdefinedPort(1194);
            profileData->setUseSmartcard(false);
            profileData->setCertPath("/etc/openvpn");
            profileData->setHashAlgo("SHA1");
            profileData->setAuthenticationAlgorithm("MD5");
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();

            newprofilewizardcertcontent->UseSmartcardCheckBox->show();
            newprofilewizardcertcontent->SmartcardGroupBox->show();
            newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->show();
            newprofilewizardauthselectioncontent->CertificateRadioButton->setText(i18n("&Certificate/Smartcard"));
            newprofilewizardcertcontent->certpathURLRequester->setUrl(KUrl("/etc/openvpn"));

            insertPage(newprofilewizardopenvpnauthpage, "<b>" + i18n("OpenVPN authentication settings") + "</b>", indexOf(currentpage) + 1);

            connect(newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, SIGNAL(toggled(bool)), this, SLOT(authenticateWithUsernameAndPasswordToggled(bool)));
            newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->setCurrentItem("SHA1");


            insertPage(newprofilewizardopenvpnselectionpage, "<b>" + i18n("OpenVPN selection") + "</b>", indexOf(currentpage) + 1);

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("OpenVPN")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->PptpRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::pptp);
            profileData->setUseMtu(false);
            profileData->setUseMru(false);
            profileData->setMtu(1500);
            profileData->setMru(1500);
            newprofilewizardnetworkcontent->MtuSpinbox->show();
            newprofilewizardnetworkcontent->MtuCheckbox->show();
            newprofilewizardnetworkcontent->MruSpinbox->show();
            newprofilewizardnetworkcontent->MruCheckbox->show();
            newprofilewizardnetworkcontent->MtuSpinbox->setValue(profileData->getMtu());
            newprofilewizardnetworkcontent->MruSpinbox->setValue(profileData->getMru());
            newprofilewizardnetworkcontent->MtuSpinbox->setEnabled(false);
            newprofilewizardnetworkcontent->MruSpinbox->setEnabled(false);
            newprofilewizardnetworkcontent->MtuCheckbox->setChecked(false);
            newprofilewizardnetworkcontent->MruCheckbox->setChecked(false);

            newprofilewizardpptppagecontent->AuthMethodComboBox->setCurrentItem(profileData->getAuthMethod());
            newprofilewizardpptppagecontent->L2tpDaemonComboBox->hide();
            newprofilewizardpptppagecontent->L2tpdDaemonLabel->hide();
            newprofilewizardpptppagecontent->AuthGroupBox->hide();
            newprofilewizardpptppagecontent->UseNoDeflateCheckbox->setChecked(! profileData->getUseNoDeflate());
            newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->setChecked(! profileData->getUseNoBsdComp());


            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardcertpage);
            removePage(newprofilewizardpskpage);
            removePage(newprofilewizardp12certselectionpage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnselectionpage);
            insertPage(newprofilewizardpptppage, "<b>" + i18n("PPTP settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 2);
            insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 3);

            newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
            newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
            newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
            newprofilewizardcertcontent->SmartcardGroupBox->hide();


            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("PPTP")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->VtunRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::vtun);
            profileData->setLocalPort(5000);
            profileData->setRemotePort(5000);
            profileData->setUserdefinedPort(5000);
            profileData->setUseSmartcard(false);
//    profileData->setCertPath( "/etc/openvpn" );
//    profileData->setHashAlgo("SHA1");
//    profileData->setAuthenticationAlgorithm("MD5");
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardopenvpnpage);
            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();


            insertPage(newprofilewizardvtunpage, "<b>" + i18n("Vtun options") + "</b>", 2);
            insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 3);
            insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);


            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("Vtun")), KVpncEnum::debug);
        } else if (newprofilewizardtypeselectionpagecontent->SshRadioButton->isChecked()) {
            profileData->setConnectionType(VpnAccountData::ssh);
            profileData->setRemotePort(22);
            profileData->setUseSmartcard(false);
            profileData->setTunnelDeviceType("tun");
            removePage(newprofilewizardvtunpage);
            removePage(newprofilewizardciscoselectionpage);
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardracoonpage);
            removePage(newprofilewizardpptppage);
            removePage(newprofilewizardfreeswanpage);
            removePage(newprofilewizardfreeswanselectionpage);
            removePage(newprofilewizardopenvpnpage);
            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();

            profilenetworkvirtualipoptionscontent->SourceIpgroupBox->hide();

            newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
            newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
            newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
            newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
            newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->hide();
            newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();

            newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->show();
            newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->show();
            newprofilewizardnetworkcontent->TunnelDeviceTypeLabel->setEnabled(true);
            newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->setEnabled(true);


            profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->setChecked(true);
            newprofilewizarduserpagecontent->UsernameLineEdit->setText("root");

            insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardsshpage, "<b>" + i18n("SSH options") + "</b>", 2);
            insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 3);
            insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Selected type: %1" , QString("SSH")), KVpncEnum::debug);
        }


        QString type = ""; // visible name
        QString bin = "";  // executable name
        if (profileData->getConnectionType() == VpnAccountData::cisco) {
            type = "vpnc";
            bin = "vpnc";
        } else if (profileData->getConnectionType() == VpnAccountData::freeswan) {
            type = "freeswan";
            bin = "ipsec";
        } else if (profileData->getConnectionType() == VpnAccountData::racoon) {
            type = "racoon";
            bin = "racoon";
        } else if (profileData->getConnectionType() == VpnAccountData::l2tpd_racoon) {
            type = "L2TP (racoon)";
            bin = "racoon";
        } else if (profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
            type = "L2TP (OpenSWAN)";
            bin = "ipsec";
        } else if (profileData->getConnectionType() == VpnAccountData::pptp) {
            type = "pptp";
            bin = "pppd pptp";
        } else if (profileData->getConnectionType() == VpnAccountData::openvpn) {
            type = "openvpn";
            bin = "openvpn";
        } else if (profileData->getConnectionType() == VpnAccountData::vtun) {
            type = "vtun";
            bin = "vtund";
        } else if (profileData->getConnectionType() == VpnAccountData::ssh) {
            type = "ssh";
            bin = "ssh";
        } else {
            type = "other";
            bin = "";
        }

        ToolInfo *it = 0;

        if (!GlobalConfig->ToolList->isEmpty()) {
            if (type != "pptp") {
                it = Utils(GlobalConfig).getToolInfo(bin);
                if (it != 0) {
                    if (it->PathToExec.section('/', -1) == bin) {
                        if (GlobalConfig->KvpncDebugLevel > 0)
                            GlobalConfig->appendLogEntry(i18n("The required daemon (%1) is available, you will be able to use this connection." , bin), KVpncEnum::info);
                        daemonavailable = true;
                    } else {
                        GlobalConfig->appendLogEntry(QString("Tool (path): ") + it->PathToExec, KVpncEnum::debug);
                        GlobalConfig->appendLogEntry(QString("Tool (exe): ") + it->PathToExec.section('/', -1), KVpncEnum::debug);


                        KMessageBox::information(this, i18n("The required daemon (%1) is not available, you will not be able to use this connection until the daemon is installed." , bin));
                        if (GlobalConfig->KvpncDebugLevel > 0)
                            GlobalConfig->appendLogEntry(i18n("The required daemon (%1) is not available, you will not be able to use this connection until the daemon is installed." , bin), KVpncEnum::error);
                        daemonavailable = false;
                        removePage(newprofilewizardconnectoptionspage);
                    }
                }
                if (type == "ipsec") {

                    QString realversion = it->Version.section(' ', 1, 1).section('/', 0, 0).right(it->Version.section(' ', 1, 1).section('/', 0, 0).length() - 1);
                    QString realtype = it->Version.section(' ', 0, 0).toLower();

                    if (realversion.indexOf("1.", 0, Qt::CaseInsensitive) > -1) {
                        KMessageBox::information(this, i18n("The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use Aggressive Mode - Main Mode will be used." , QString("2")));
                        if (GlobalConfig->KvpncDebugLevel > 0)
                            GlobalConfig->appendLogEntry(i18n("The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use Aggressive Mode - Main Mode will be used." , QString("2"), bin), KVpncEnum::error);
                    }
                }
            } else {
                bool pppd_and_pptp_available = false;
                it = Utils(GlobalConfig).getToolInfo("pppd");
                if (it->PathToExec.section('/', -1) == "pppd") {
                    it = Utils(GlobalConfig).getToolInfo("pptp");
                    if (it->PathToExec.section('/', -1) == "pptp")
                        pppd_and_pptp_available = true;
                }
                if (pppd_and_pptp_available) {
                    // programs are installed
                    daemonavailable = true;
                    if (GlobalConfig->KvpncDebugLevel > 0)
                        GlobalConfig->appendLogEntry(i18n("The required daemons (%1 and %2) are available." , QString("pppd"), QString("pptp")), KVpncEnum::info);
                } else {
                    KMessageBox::information(this, i18n("The required daemons (%1 and %2) are not available, you will not be able to use this connection until the daemons are installed." , QString("pppd"), QString("pptpd")));
                    GlobalConfig->appendLogEntry(i18n("The required daemons (%1 and %2) are not available, connect will be disabled." , QString("pppd"), QString("pptpd")), KVpncEnum::error);
                    daemonavailable = false;
                    removePage(newprofilewizardconnectoptionspage);
                }
            }

        }

    } else if (currentpage == newprofilewizardciscoselectionpage) {
        if (newprofilewizardciscoselectionpagecontent->PcfImportRadioButton->isChecked()) {
            enterdatamanually = false;
            removePage(newprofilewizardciscomanuallypage);
            removePage(newprofilewizardgeneralpage);
            insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Cisco selection: import PCF file"), KVpncEnum::debug);

            if (profileData->getConnectionType() == VpnAccountData::cisco)
                importProfile(VpnAccountData::cisco);
            if (profileData->getConnectionType() == VpnAccountData::ciscoorig)
                importProfile(VpnAccountData::ciscoorig);
            if (importOK)
                newProfileCreated = true;
            else
                newProfileCreated = false;

        } else {
            enterdatamanually = true;

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Cisco selection: enter data manually"), KVpncEnum::debug);

            if (profileData->getConnectionType() == VpnAccountData::cisco) {
                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("Cisco selection: cisco"), KVpncEnum::debug);

                insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
                insertPage(newprofilewizardciscomanuallypage, "<b>" + i18n("Cisco settings") + "</b>", indexOf(currentpage) + 2);
                insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 3);
                insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);
            }
            if (profileData->getConnectionType() == VpnAccountData::ciscoorig) {
                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("Cisco selection: ciscoorig"), KVpncEnum::debug);

                insertPage(newprofilewizardauthselectionpage, "<b>" + i18n("Authentication settings") + "</b>",  indexOf(currentpage) + 1);
                insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 2);
                insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 4);
                insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 5);

                newprofilewizardauthselectioncontent->PskRadioButton->setChecked(true);
            }

        }
    } else if (currentpage == newprofilewizardciscomanuallypage) {
        msg = i18n("These fields must be filled in:\n");
        if (newprofilewizardciscomanuallypagecontent->IDLineEdit->text().isEmpty()) {
            ok = false;
            msg += "- " + i18n("Cisco IPSec ID") + "\n";
            GlobalConfig->appendLogEntry(i18n("Cisco IPSec ID is empty."), KVpncEnum::error);
        }
        profileData->setGateway(newprofilewizardciscomanuallypagecontent->IDLineEdit->text());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Cisco IPSec ID: %1" , newprofilewizardciscomanuallypagecontent->IDLineEdit->text()), KVpncEnum::debug);

        profileData->setAllowEmptyGroupPassword(newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked());
        if (GlobalConfig->KvpncDebugLevel > 0) {
            if (newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked())
                GlobalConfig->appendLogEntry(i18n("Allow empty group password: true"), KVpncEnum::debug);
            else
                GlobalConfig->appendLogEntry(i18n("Allow empty group password: false"), KVpncEnum::debug);
        }

//   if ( !newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() && newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text().isEmpty() )
//   {
//    ok = false;
//    msg += "- " + i18n( "Group password" ) + "\n";
//    GlobalConfig->appendLogEntry( i18n( "Group password is empty but you do not have checked to allow that." ), KVpncEnum::error );
//   }
//   else
        profileData->setPreSharedKey(newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text());

        profileData->setSavePsk(newprofilewizardciscomanuallypagecontent->CheckSavePsk->isChecked());

        profileData->setID(newprofilewizardciscomanuallypagecontent->IDLineEdit->text());
        profileData->setAllowEmptyGroupPassword(newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked());

        profileData->setUseDpdIdleTimeout(true);
        if (profileData->getConnectionType() == VpnAccountData::cisco)
            profileData->setDpdIdleTimeout(300);
        if (profileData->getConnectionType() == VpnAccountData::ciscoorig)
            profileData->setDpdIdleTimeout(90);

        insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
        insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 2);
        insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 3);
        insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);

    } else if (currentpage == newprofilewizardfreeswanpage) {
        msg = i18n("These fields must be filled in:\n");
        profileData->setUseModeConfig(newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->isChecked());
        if (GlobalConfig->KvpncDebugLevel > 0) {
            if (newprofilewizardfreeswanpagecontent->UseModeConfigCheckBox->isChecked())
                GlobalConfig->appendLogEntry(i18n("Use Mode Config: %1" , i18n("yes")), KVpncEnum::debug);
            else
                GlobalConfig->appendLogEntry(i18n("Use Mode Config: %1" , i18n("no")), KVpncEnum::debug);
        }

        profileData->setExchangeMode(newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Exchange mode (%1): %2" , QString("ipsec"), newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText()), KVpncEnum::debug);

        profileData->setLeftNextHop(newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->text());    //TODO check valid IP
        profileData->setRightNextHop(newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->text());     //TODO check valid IP
        profileData->setDisableOpportunisticEncryption(newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked());

        // xauth
        if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked()) {
            profileData->setAuthWithUsernameAndPassword(true);
        } else {
            profileData->setAuthWithUsernameAndPassword(false);
        }

        if (GlobalConfig->KvpncDebugLevel > 0) {
            if (newprofilewizardfreeswanpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked())
                GlobalConfig->appendLogEntry(i18n("Disable opportunistic encryption: %1" , i18n("yes")), KVpncEnum::debug);
            else
                GlobalConfig->appendLogEntry(i18n("Disable opportunistic encryption: %1" , i18n("no")), KVpncEnum::debug);
            GlobalConfig->appendLogEntry(i18n("Right next hop: %1" , newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->text()), KVpncEnum::debug);
            GlobalConfig->appendLogEntry(i18n("Left next hop: %1" , newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->text()), KVpncEnum::debug);
            GlobalConfig->appendLogEntry(i18n("Use PFS: %1" , profileData->getPerfectForwardSecrety()), KVpncEnum::debug);

        }

        profileData->setExchangeMode(newprofilewizardfreeswanpagecontent->ExchangeModeComboBox->currentText());

        if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked()) {
            if (newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text().isEmpty()) {
                ok = false;
                msg += "- " + i18n("Local ID (Group ID)") + "\n";
                GlobalConfig->appendLogEntry(i18n("Local ID (Group ID) is empty."), KVpncEnum::error);
            }
            profileData->setUseSpecialLocalID(true);
        }

        profileData->setLocalIDType(newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->currentText());

        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Type of local ID: %1" , newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->currentText()), KVpncEnum::debug);

        profileData->setSpecialLocalID(newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Local ID value: %1" , newprofilewizardfreeswanpagecontent->LocalIDLineEdit->text()), KVpncEnum::debug);

        // ike + esp
        QStringList IkeList;
        QStringList EspList;

        if (newprofilewizardfreeswanpagecontent->IkeAes256Sha1CheckBox->isChecked())
            IkeList.append("aes256-sha1");
        if (newprofilewizardfreeswanpagecontent->IkeAes128Sha1CheckBox->isChecked())
            IkeList.append("aes128-sha1");
        if (newprofilewizardfreeswanpagecontent->IkeDesSha1Modp2048CheckBox->isChecked())
            IkeList.append("3des-sha1-modp2048");
        if (newprofilewizardfreeswanpagecontent->IkeDesMd5CheckBox->isChecked())
            IkeList.append("3des-md5");
        if (newprofilewizardfreeswanpagecontent->IkeDesSha1CheckBox->isChecked())
            IkeList.append("3des-sha1");

        if (!newprofilewizardfreeswanpagecontent->OtherIkeLineEdit->text().isEmpty())
            IkeList.append(newprofilewizardfreeswanpagecontent->OtherIkeLineEdit->text());

        if (newprofilewizardfreeswanpagecontent->Esp3desMd5CheckBox->isChecked())
            EspList.append("3des-md5");
        if (newprofilewizardfreeswanpagecontent->EspDesSha1CheckBox->isChecked())
            EspList.append("3des-sha1");
        if (newprofilewizardfreeswanpagecontent->EspAes128Sha1CheckBox->isChecked())
            EspList.append("aes128-sha1");
        if (newprofilewizardfreeswanpagecontent->EspAes256Sha1CheckBox->isChecked())
            EspList.append("aes256-sha1");

        if (!newprofilewizardfreeswanpagecontent->OtherEspLineEdit->text().isEmpty())
            EspList.append(newprofilewizardfreeswanpagecontent->OtherEspLineEdit->text());

        if (newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked() && !EspList.isEmpty()) {
            profileData->setUseCustomEsp(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Use custom %1: %2" , i18n("ESP") , i18n("yes")), KVpncEnum::debug);

            profileData->setIpsecEsp(EspList.join(","));

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("ESP settings: %1" , EspList.join(",")), KVpncEnum::debug);

        } else if (newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked() && EspList.isEmpty()) {
            ok = false;
            msg += "- " + i18n("Use custom ESP checked but none selected.") + "\n";
            GlobalConfig->appendLogEntry(i18n("Use custom ESP checked but none selected."), KVpncEnum::error);
        } else if (!newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked()) {
            profileData->setUseCustomEsp(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Use custom %1: %2" , i18n("ESP") , i18n("no")), KVpncEnum::debug);
        }

        if (newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked() && !IkeList.isEmpty()) {
            profileData->setUseCustomIke(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Use custom %1: %2" , i18n("IKE") , i18n("yes")), KVpncEnum::debug);

            profileData->setIpsecIke(IkeList.join(","));

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("IKE settings: %1" , IkeList.join(",")), KVpncEnum::debug);

        } else if (newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked() && IkeList.isEmpty()) {
            ok = false;
            msg += "- " + i18n("Use custom IKE checked but none selected.") + "\n";
            GlobalConfig->appendLogEntry(i18n("Use custom IKE checked but none selected."), KVpncEnum::error);
        } else if (!newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked()) {
            profileData->setUseCustomIke(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Use custom %1: %2" , QString(i18n("IKE")), i18n("false")), KVpncEnum::debug);
        }

        if (ok) {
            if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked()) {
                if (GlobalConfig->KvpncDebugLevel > 1)
                    GlobalConfig->appendLogEntry(i18n("Authenticate with username and password: %1" , QString(i18n("yes"))), KVpncEnum::debug);
                profileData->setAuthWithUsernameAndPassword(true);

                insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
                insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 2);
                insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 3);
                insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);
            } else {
                if (GlobalConfig->KvpncDebugLevel > 1)
                    GlobalConfig->appendLogEntry(i18n("Authenticate with username and password: %1" , QString(i18n("no"))), KVpncEnum::debug);

                insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 1);
                insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 2);
                insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 3);
            }
        }

    } else if (currentpage == newprofilewizardfreeswanselectionpage) {
        if (newprofilewizardfreeswanselectionpagecontent->OpenvpnImportRadioButton->isChecked()) {
            enterdatamanually = false;
            removePage(newprofilewizardfreeswanpage);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("IPSec selection: import profile file"), KVpncEnum::debug);

            //    removePage ( newprofilewizardgeneralpage );
//    removePage ( newprofilewizardvirtualipaddresspage );

            if (importProfile(VpnAccountData::freeswan) == true) {
                newProfileCreated = true;
                newprofilewizardgeneralpagecontent->NameLineEdit->setText(profileData->getName());
                newprofilewizardgeneralpagecontent->gatewayLineEdit->setText(profileData->getGateway());
                newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText(profileData->getDescription());

            } else {
                newProfileCreated = false;
                ok = false;
            }
        } else {
            enterdatamanually = true;
            insertPage(newprofilewizardfreeswanpage, "<b>" + i18n("IPSec settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardauthselectionpage, i18n("Authentication settings"), indexOf(currentpage) + 1);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("IPSec selection: enter data manually"), KVpncEnum::debug);
        }

    } else if (currentpage == newprofilewizardracoonpage) {
        if (newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "SHA1") {
            profileData->setHashAlgo("sha1");
        }
        if (newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "MD5") {
            profileData->setHashAlgo("md5");
        }

        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Hash algorithm (%1): %2" , QString("racoon"), profileData->getHashAlgo()), KVpncEnum::debug);

        if (newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked()) {
            profileData->setUseModeConfig(newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked());
            if (GlobalConfig->KvpncDebugLevel > 0) {
                if (newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked())
                    GlobalConfig->appendLogEntry(i18n("Use Mode Config: %1", i18n("yes")), KVpncEnum::debug);
                else
                    GlobalConfig->appendLogEntry(i18n("Use Mode Config: %1" , i18n("no")), KVpncEnum::debug);
            }
        }

        profileData->setExchangeMode(newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Exchange mode (%1): %2" , QString("racoon"), newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText()), KVpncEnum::debug);

        profileData->setIkeGroup(newprofilewizardracoonpagecontent->DHGroupComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("DH group (%1): %2" , QString("racoon"), newprofilewizardracoonpagecontent->DHGroupComboBox->currentText()), KVpncEnum::debug);

        profileData->setAuthenticationAlgorithm(newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Authentication algorithm (%1) (phase 2): %2" , QString("racoon"), newprofilewizardracoonpagecontent->AuthenticationAlgorithm2ComboBox->currentText()), KVpncEnum::debug);

        profileData->setIpsecIke(newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText());
        profileData->setUseAuthenticationAlgorithm(true);
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Encryption algorithm (%1) (phase 1): %2" , QString("racoon"), newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText()), KVpncEnum::debug);

        profileData->setLocalIDType(newprofilewizardracoonpagecontent->LocalIdTypeCombobox->currentText());

        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Type of local ID: %1", QString(newprofilewizardracoonpagecontent->LocalIdTypeCombobox->currentText())), KVpncEnum::debug);

        profileData->setSpecialLocalID(newprofilewizardracoonpagecontent->LocalIDLineEdit->text());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Local ID value: %1" , QString(newprofilewizardracoonpagecontent->LocalIDLineEdit->text())), KVpncEnum::debug);

        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Type of remote ID: %1", QString(newprofilewizardracoonpagecontent->RemoteIdTypeCombobox->currentText())), KVpncEnum::debug);

        profileData->setSpecialLocalID(newprofilewizardracoonpagecontent->RemoteIDLineEdit->text());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Remote ID value: %1" , QString(newprofilewizardracoonpagecontent->RemoteIDLineEdit->text())), KVpncEnum::debug);


        if (newprofilewizardracoonpagecontent->UseXauthCheckBox->isChecked()) {
            profileData->setAuthWithUsernameAndPassword(true);
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Authenticate with username and password: %1", QString(i18n("yes"))), KVpncEnum::debug);
            insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 2);
            insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 3);
            insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 4);

        } else {
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Authenticate with username and password: %1" , QString(i18n("no"))), KVpncEnum::debug);
            insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 1);
            insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 2);
            insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 3);
        }
    } else if (currentpage == newprofilewizardopenvpnpage) {
        msg = i18n("These fields must be filled in:\n");
        profileData->setTunnelDeviceType(newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Tunnel device type (%1): %2", QString("OpenVPN"), newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText()), KVpncEnum::debug);

        if (newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->currentText() == "client")
            profileData->setNsCertType("client");
        else
            profileData->setNsCertType("server");

        profileData->setTunnelDeviceType(newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText());

        insertPage(newprofilewizardauthselectionpage, "<b>" + i18n("Authentication settings") + "</b>", indexOf(currentpage) + 1);
        insertPage(newprofilewizardnetworkpage, "<b>" + i18n("Network settings") + "</b>", indexOf(currentpage) + 2);
        insertPage(newprofilewizardnetworkroutepage, "<b>" + i18n("Network routes") + "</b>", indexOf(currentpage) + 3);
        insertPage(newprofilewizardnatpage, "<b>" + i18n("NAT settings") + "</b>", indexOf(currentpage) + 4);

        profileData->setUserdefiniedCipher(newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->currentText());
        profileData->setUseUserdefiniedCipher(newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked());

        profileData->setRemotePort(newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->value());
        profileData->setUseRemotePort(newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked());

        if (newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked()) {
            if (newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url().toLocalFile().isEmpty()) {
                ok = false;
                msg += i18n("TLS auth file") + "\n";
            } else {
                profileData->setUseTlsAuth(true);
                profileData->setTlsAuthFile(newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url().toLocalFile());
            }
        }

        if (newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked()) {
            if (newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text().isEmpty()) {
                ok = false;
                msg += i18n("TLS remote host") + "\n";
            } else {
                profileData->setUseTlsRemoteHost(newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked());
                profileData->setTlsRemoteHost(newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text());
            }
        }

        profileData->setDisableLzoCompression(newprofilewizardopenvpnpagecontent->DisableLzoCompressionCheckBox->isChecked());

        if (newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked()) {
            if (newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text().isEmpty()) {
                ok = false;
                msg += i18n("HTTP proxy host") + "\n";
            } else {
                profileData->setUseHttpProxy(newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked());
                profileData->setHttpProxy(newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text());
            }
        }

        if (newprofilewizardopenvpnpagecontent->AllowIpAddressChangeOfPeerCheckBox->isChecked())
            profileData->setAllowIpAddressChangeOfPeer(true);
        else
            profileData->setAllowIpAddressChangeOfPeer(false);

        profileData->setHttpProxyPort(newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value());
        profileData->setHttpProxyTimeout(newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value());


    } else if (currentpage == newprofilewizardauthselectionpage) {
        if (newprofilewizardauthselectioncontent->PskRadioButton->isChecked()) {
            useCert = false;

            profileData->setAuthType(VpnAccountData::psk);
            insertPage(newprofilewizardpskpage, "<b>" + i18n("PSK settings") + "</b>", indexOf(currentpage) + 1);

            // racoon or freeswan
            if (profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
                    profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon) {
                newprofilewizardpskcontent->PSKLineEdit->setEnabled(true);
                newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled(true);
                newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled(true);
            }

            else if (profileData->getConnectionType() == VpnAccountData::openvpn) {
                newprofilewizardpskcontent->PSKLineEdit->setEnabled(true);
                newprofilewizardpskcontent->LabelPsk->setEnabled(true);
            }

            else if (profileData->getConnectionType() == VpnAccountData::ciscoorig) {
                insertPage(newprofilewizardciscomanuallypage, "<b>" + i18n("Cisco settings") + "</b>", indexOf(currentpage) + 1);
                removePage(newprofilewizardpskpage);
            }
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Auth selection: use PSK."), KVpncEnum::debug);
        }
        if (newprofilewizardauthselectioncontent->CertificateRadioButton->isChecked()) {
            useCert = true;
            profileData->setAuthType(VpnAccountData::cert);

            newprofilewizardcertcontent->x509certURLRequester->show();
            newprofilewizardcertcontent->x509certURLRequester->sizeHint();
            newprofilewizardcertcontent->x509certComboBox->hide();


            if (profileData->getConnectionType() != VpnAccountData::ciscoorig)
                insertPage(newprofilewizardp12certselectionpage, "<b>" + i18n("Certificate format") + "</b>", indexOf(currentpage) + 1);
            // racoon or freeswan
            if (profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
                    profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon) {
                newprofilewizardcertcontent->x509certURLRequester->setEnabled(true);
                newprofilewizardcertcontent->LabelCertificate->setEnabled(true);
                newprofilewizardcertcontent->certpathURLRequester->setEnabled(true);
                newprofilewizardcertcontent->LabelCertificatePath->setEnabled(true);

                newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled(false);
                newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled(false);
            }

            else if (profileData->getConnectionType() == VpnAccountData::openvpn) {
                newprofilewizardcertcontent->CaCertpathURLRequester->setEnabled(true);
                newprofilewizardcertcontent->certpathURLRequester->setEnabled(true);
                newprofilewizardcertcontent->LabelCertificatePath->setEnabled(true);


                if (profileData->getUseOnlyCaCertAndUserAuth()) {
                    newprofilewizardcertcontent->x509certURLRequester->setEnabled(false);
                    newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(false);
                    newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(false);
                    newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(false);
                    newprofilewizardcertcontent->LabelCertificate->setEnabled(false);
                    newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(false);

                } else {
                    newprofilewizardcertcontent->x509certURLRequester->setEnabled(true);
                    newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(true);
                    newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(true);
                    newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(true);
                    newprofilewizardcertcontent->LabelCertificate->setEnabled(true);
                    newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(true);
                }
            }

            else if (profileData->getConnectionType() == VpnAccountData::ciscoorig) {
                newprofilewizardcertcontent->x509certURLRequester->setEnabled(true);
                newprofilewizardcertcontent->LabelCertificate->setEnabled(true);
                newprofilewizardcertcontent->certpathURLRequester->setEnabled(false);
                newprofilewizardcertcontent->LabelCertificatePath->setEnabled(false);
                newprofilewizardcertcontent->certpathURLRequester->hide();
                newprofilewizardcertcontent->LabelCertificatePath->hide();
                newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
                newprofilewizardcertcontent->SmartcardGroupBox->hide();
                newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->hide();
                newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->hide();
                newprofilewizardcertcontent->SpecialServerCertificateURLRequester->hide();
                newprofilewizardcertcontent->CaCertpathURLRequester->hide();
                newprofilewizardcertcontent->RemoteIDLineEdit->hide();
                newprofilewizardcertcontent->LabelPrivateKeyPath->hide();
                newprofilewizardcertcontent->privkeypathURLRequester->hide();
                newprofilewizardcertcontent->LabelCaCertificatePath->hide();
                newprofilewizardcertcontent->CertificateGroupBox->resize(newprofilewizardcertcontent->CertificateGroupBox->sizeHint());


                insertPage(newprofilewizardcertpage, "<b>" + i18n("Certificate settings") + "</b>", indexOf(currentpage) + 1);


//     newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->hide();
//     newprofilewizardciscomanuallypagecontent->LabelPsk->hide();
//     newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->hide();
//     newprofilewizardciscomanuallypagecontent->CheckSavePsk->hide();

                if (importCertificate()) {
                    // success :)
                } else {
                    newProfileCreated = false;
                }
                newprofilewizardcertcontent->LabelPrivateKeyPassword->setText("Certificate password:");
                // newprofilewizardcertcontent->LabelCertificate->setText(i18n("Certificate (enter name here):"));
                newprofilewizardcertcontent->x509certURLRequester->hide();
                newprofilewizardcertcontent->x509certComboBox->show();
                newprofilewizardcertcontent->x509certComboBox->sizeHint();
                newprofilewizardcertcontent->x509certComboBox->setCurrentItem(0);

            }

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Auth selection: use certificate."), KVpncEnum::debug);
        }
        if (newprofilewizardauthselectioncontent->HybridRadioButton->isChecked()) {
            useCert = false;

            profileData->setAuthType(VpnAccountData::hybrid);
            insertPage(newprofilewizardcertpage, "<b>" + i18n("Certificate settings") + "</b>", indexOf(currentpage) + 1);

            // racoon or freeswan
            if (profileData->getConnectionType() == VpnAccountData::racoon  || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon) {
                newprofilewizardpskcontent->PSKLineEdit->setEnabled(true);
                newprofilewizardfreeswanpagecontent->UseXauthCheckBox->setEnabled(true);
                newprofilewizardracoonpagecontent->UseXauthCheckBox->setEnabled(true);

                newprofilewizardcertpage->setEnabled(true);
                newprofilewizardcertcontent->x509certComboBox->setEnabled(false);
                newprofilewizardcertcontent->x509certURLRequester->setEnabled(false);
                newprofilewizardcertcontent->CaCertpathURLRequester->setEnabled(true);
                newprofilewizardcertcontent->certpathURLRequester->setUrl(KUrl("/etc/racoon/certs"));
                newprofilewizardcertcontent->LabelCertificate->setEnabled(false);
                newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(false);
                newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(false);
                newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled(false);
                newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(false);
                newprofilewizardcertcontent->RemoteIDLineEdit->setEnabled(false);
                newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->setEnabled(false);
                newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->setEnabled(false);
                newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(false);
                newprofilewizardpskcontent->setEnabled(false);


            } else if (profileData->getConnectionType() == VpnAccountData::ciscoorig) {
                insertPage(newprofilewizardciscomanuallypage, "<b>" + i18n("Cisco settings") + "</b>", indexOf(currentpage) + 1);
                removePage(newprofilewizardpskpage);
            }
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Auth selection: use Hybrid."), KVpncEnum::debug);
        }
    } else if (currentpage == newprofilewizardp12certselectionpage) {
        insertPage(newprofilewizardcertpage, "<b>" + i18n("Certificate settings") + "</b>", indexOf(currentpage) + 1);

        if (newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked()) {
            profileData->setUseSmartcard(true);
            newprofilewizardcertcontent->UseSmartcardCheckBox->setChecked(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("P12 cert selection: use smartcard."), KVpncEnum::debug);
        } else {
            if (newprofilewizardp12certselectioncontent->P12CertYesRadioButton->isChecked()) {
                // yes we have p12 cert
                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("P12 cert selection: cert type is PKCS12."), KVpncEnum::debug);

                if (importCertificate()) {
                    // success :)
                } else {
                    newProfileCreated = false;
                }
            } else {

                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("P12 cert selection: cert type is other."), KVpncEnum::debug);
            }
        }
    } else if (currentpage == newprofilewizardopenvpnselectionpage) {
        if (newprofilewizardopenvpnselectionpagecontent->OpenvpnImportRadioButton->isChecked()) {
            enterdatamanually = false;
            removePage(newprofilewizardopenvpnpage);
            removePage(newprofilewizardopenvpnauthpage);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN selection: import profile file."), KVpncEnum::debug);

            //    removePage ( newprofilewizardgeneralpage );
            removePage(newprofilewizardvirtualipaddresspage);

            if (importProfile(VpnAccountData::openvpn) == true) {
                newProfileCreated = true;
                newprofilewizardgeneralpagecontent->NameLineEdit->setText(profileData->getName());
                newprofilewizardgeneralpagecontent->gatewayLineEdit->setText(profileData->getGateway());
                newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText(profileData->getDescription());

                if (profileData->getAuthWithUsernameAndPassword()) {
                    if (GlobalConfig->KvpncDebugLevel > 0)
                        GlobalConfig->appendLogEntry(i18n("OpenVPN auth: authenticate with username and password."), KVpncEnum::debug);
                    insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);
                }
            } else {
                newProfileCreated = false;
                ok = false;
            }
        } else {
            enterdatamanually = true;
            insertPage(newprofilewizardopenvpnpage, "<b>" + i18n("OpenVPN settings") + "</b>", indexOf(currentpage) + 1);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN selection: enter data manually."), KVpncEnum::debug);
        }

    } else if (currentpage == newprofilewizardopenvpnauthpage) {
        if (newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked()) {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN auth: authenticate with username and password."), KVpncEnum::debug);
            insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);

            profileData->setAuthWithUsernameAndPassword(true);

            if (newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->isChecked()) {
                profileData->setUseOnlyCaCertAndUserAuth(true);

                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("OpenVPN auth: use only CA cert authenticate with username and password."), KVpncEnum::debug);
            } else {
                profileData->setUseOnlyCaCertAndUserAuth(false);

            }
        } else {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN auth: do not authenticate with username and password."), KVpncEnum::debug);

            profileData->setAuthWithUsernameAndPassword(false);
            profileData->setUseOnlyCaCertAndUserAuth(false);
        }

        if (newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox->isChecked()) {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN auth: use special authentication algorithm: %1." , newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText()), KVpncEnum::debug);
            profileData->setUseAuthenticationAlgorithm(true);
            profileData->setAuthenticationAlgorithm(newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText());
        } else {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("OpenVPN auth: do not use special authentication algorithm."), KVpncEnum::debug);
            profileData->setUseAuthenticationAlgorithm(false);
        }

        profileData->setAuthenticationAlgorithm(newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText());
        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("OpenVPN auth: use authentication method: %1." , profileData->getAuthenticationAlgorithm()), KVpncEnum::debug);


    } else if (currentpage == newprofilewizardpptppage) {

        msg = i18n("These fields must be filled in:\n");
        profileData->setAllowStatefulMode(newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->isChecked());
        profileData->setUseNoIpDefault(newprofilewizardpptppagecontent->UseNoIpDefaultCheckbox->isChecked());
        profileData->setDisableMPPEComp(newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked());
        profileData->setRequireMppe(newprofilewizardpptppagecontent->RequireMppeCheckbox->isChecked());
        profileData->setRefuse128BitEncryption(newprofilewizardpptppagecontent->Refuse128BitEncryptionCheckbox->isChecked());
        profileData->setRefuse40BitEncryption(newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->isChecked());
        profileData->setDisableMPPEComp(newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked());
        profileData->setUseNoBsdComp(newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->isChecked());
        profileData->setUseNoDeflate(newprofilewizardpptppagecontent->UseNoDeflateCheckbox->isChecked());
        profileData->setDisableHeaderCompression(newprofilewizardpptppagecontent->DisableHeaderCompressionCheckbox->isChecked());
        profileData->setDisableMagicNumberNegotiation(newprofilewizardpptppagecontent->DisableMagicNumberNegotiationCheckbox->isChecked());
        profileData->setDisableIpx(newprofilewizardpptppagecontent->DisableIpxCheckbox->isChecked());
        profileData->setDisableAddressControlCompression(newprofilewizardpptppagecontent->DisableAddressControlCompressionCheckbox->isChecked());
        profileData->setDisableProtocolFieldCompression(newprofilewizardpptppagecontent->DisableProtocolFieldCompressionCheckbox->isChecked());
        profileData->setRequireEap(newprofilewizardpptppagecontent->RequireEapCheckbox->isChecked());

        if (newprofilewizardpptppagecontent->DnsServerCheckbox->isChecked()) {
            profileData->setUseDnsServer(true);
            profileData->setDnsServer(newprofilewizardpptppagecontent->DnsServerLineedit->text());

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Using custom DNS server: %1." , QString(profileData->getDnsServer())), KVpncEnum::debug);
        } else {
            profileData->setUseDnsServer(false);
        }

        if (newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox ->isChecked()) {
            profileData->setUseSearchDomainInResolvConf(true);
            profileData->setSearchDomainInResolvConf(newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->text());

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Using custom DNS search domain: %1." , QString(profileData->getSearchDomainInResolvConf())), KVpncEnum::debug);
        } else {
            profileData->setUseSearchDomainInResolvConf(false);
        }

        int authMethodIndex = newprofilewizardpptppagecontent->AuthMethodComboBox->currentIndex();
        switch (authMethodIndex) {
        case VpnAccountData::chap:
            profileData->setAuthMethod("chap");
            break;
        case VpnAccountData::pap:
            profileData->setAuthMethod("pap");
            break;
        case VpnAccountData::mschap:
            profileData->setAuthMethod("mschap");
            break;
        case VpnAccountData::mschap_v2:
            profileData->setAuthMethod("mschap_v2");
            break;
        }

        if (GlobalConfig->KvpncDebugLevel > 0)
            GlobalConfig->appendLogEntry(i18n("Using auth method: %1." , QString(profileData->getAuthMethod())), KVpncEnum::debug);

        newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
        newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
        newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
        newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
        newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->hide();
        newprofilewizardnetworkcontent->RemoteNetworkGroupBox->hide();

        insertPage(newprofilewizarduserpage, "<b>" + i18n("User settings") + "</b>", indexOf(currentpage) + 1);

    } else if (currentpage == newprofilewizardvtunpage) {
        msg = i18n("These fields must be filled in:\n");
        profileData->setUseLocalPort(newprofilewizardvtunpagecontent->PortCheckbox->isChecked());
        profileData->setLocalPort(newprofilewizardvtunpagecontent->PortSpinbox->value());

        if (newprofilewizardvtunpagecontent->PortCheckbox->isChecked()) {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Vtun: use user-defined port: %1." , QString().setNum(newprofilewizardvtunpagecontent->PortSpinbox->value())), KVpncEnum::debug);
        }

        if (newprofilewizardvtunpagecontent->VtunProfileLineEdit->text().isEmpty()) {
            KMessageBox::error(this, i18n("No profile name entered."), i18n("No profile name"));
            ok = false;
            msg += "- " + i18n("Vtun profile name") + "\n";
            GlobalConfig->appendLogEntry(i18n("No profile name entered."), KVpncEnum::error);
        } else
            profileData->setVtunProfile(newprofilewizardvtunpagecontent->VtunProfileLineEdit->text());
    } else if (currentpage == newprofilewizardsshpage) {
        msg = i18n("These fields must be filled in:\n");
        profileData->setUseRemotePort(newprofilewizardsshpagecontent->UseUserdefinedRemotePortCheckBox->isChecked());
        profileData->setRemotePort(newprofilewizardsshpagecontent->UserdefinedRemotePortSpinBox->value());

        if (newprofilewizardsshpagecontent->UseUserdefinedRemotePortCheckBox->isChecked()) {
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use user-defined port: %1.", QString(QString().setNum(newprofilewizardsshpagecontent->UserdefinedRemotePortSpinBox->value()))), KVpncEnum::debug);
        }

        // password or key auth
        if (newprofilewizardsshpagecontent->AuthPassRadioButton->isChecked()) {
            profileData->setAuthWithUsernameAndPassword(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use user password authentication.") , KVpncEnum::debug);
        } else {
            profileData->setAuthWithUsernameAndPassword(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use key authentication.") , KVpncEnum::debug);
        }

        profileData->setPreSharedKeyFile(newprofilewizardsshpagecontent->CostumkeyURLRequester->url().path());

        if (newprofilewizardsshpagecontent->CostumKeyRadioButton->isChecked()) {
            profileData->setPskIsInFile(newprofilewizardsshpagecontent->CostumKeyRadioButton->isChecked());
            profileData->setPreSharedKeyFile(newprofilewizardsshpagecontent->CostumkeyURLRequester->url().path());
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use custom key: %1.", QString(newprofilewizardsshpagecontent->CostumkeyURLRequester->url().path())) , KVpncEnum::debug);
        } else {
            profileData->setPreSharedKey(newprofilewizardsshpagecontent->SshKeyComboBox->currentText());
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use auto-detected key: %1." , QString(newprofilewizardsshpagecontent->SshKeyComboBox->currentText())) , KVpncEnum::debug);
        }

        if (newprofilewizardsshpagecontent->UseSshConfigRemoteScriptCheckBox->isChecked() && !newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text().isEmpty()) {
            profileData->setUseSshConfigRemoteScript(true);
            profileData->setSshConfigRemoteScript(newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text());

            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("SSH: use ssh config remote script: %1." , QString(newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text())) , KVpncEnum::debug);

        } else
            profileData->setUseSshConfigRemoteScript(false);

        if (newprofilewizardsshpagecontent->UseSshConfigRemoteScriptCheckBox->isChecked() && newprofilewizardsshpagecontent->SshConfigRemoteScriptLineEdit->text().isEmpty()) {
            ok = false;
            msg += "- " + i18n("Special server certificate") + "\n";
            GlobalConfig->appendLogEntry(i18n("%1 cannot be empty." , QString("ssh config remote script")), KVpncEnum::error);
        }

    } else if (currentpage == newprofilewizardvirtualipaddresspage) {
        msg = i18n("These fields must be filled in:\n");
        bool IPOk = true;
        QString wrongAddress = "";
        ok = true;



        if (profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() &&  !profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->text().isEmpty()) {
            QString LocalVirtualIp = profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(LocalVirtualIp) == false) {
                //    KMessageBox::error ( this, i18n( "No valid IP address for local IP address entered." ), i18n( "No Valid IP Address" ) );
                IPOk = false;
                wrongAddress = i18n("local IP address");
                ok = false;
            } else {
                profileData->setLocalVirtualIP(LocalVirtualIp);
            }
        } else {
            msg += "- " + i18n("local IP address for virtual IP") + "\n";
            ok = false;
            IPOk = false;
        }

        if (profileData->getConnectionType() != VpnAccountData::openvpn || profileData->getConnectionType() != VpnAccountData::ssh) {
            if (profileData->getTunnelDeviceType() == "tun") {
                if (profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() && !profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text().isEmpty()) {
                    QString RemoteVirtualIp = profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text();
                    if (Utils(GlobalConfig).isValidIPv4Address(RemoteVirtualIp) == false) {

                        IPOk = false;
                        ok = false;
                        if (wrongAddress == "")
                            wrongAddress = i18n("remote IP address");
                        else
                            wrongAddress = i18n("local and remote IP address");
                    } else {
                        profileData->setRemoteVirtualIP(RemoteVirtualIp);
                    }
                } else {
                    msg += "- " + i18n("remote IP address for virtual IP") + "\n";
                    ok = false;
                    IPOk = false;

                }
            }
            if (profileData->getTunnelDeviceType() == "tap") {
                QString RemoteVirtualIp = profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->text();
                if (Utils(GlobalConfig).isValidIPv4Netmask(RemoteVirtualIp) == false) {
                    KMessageBox::error(this, i18n("No valid netmask entered."), i18n("No valid netmask"));
                    IPOk = false;
                } else {
                    profileData->setRemoteVirtualIP(RemoteVirtualIp);
                }
            }
        }


        if (profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked() && IPOk) {
            profileData->setUseVirtualIP(profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked());

            if (profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked()) {

                if (profileData->getTunnelDeviceType() == "tun") {
                    if (GlobalConfig->KvpncDebugLevel > 0)
                        GlobalConfig->appendLogEntry(i18n("Using virtual IP addresses (local: %1, remote: %2): ", QString(profileData->getLocalVirtualIP()),  profileData->getRemoteVirtualIP()), KVpncEnum::debug);
                }
                if (profileData->getTunnelDeviceType() == "tap") {
                    if (GlobalConfig->KvpncDebugLevel > 0)
                        GlobalConfig->appendLogEntry(i18n("Using virtual IP address (local: %1, netmask: %2): " , QString(profileData->getLocalVirtualIP()), profileData->getRemoteVirtualIP()), KVpncEnum::debug);
                }
            } else {
                if (GlobalConfig->KvpncDebugLevel > 0)
                    GlobalConfig->appendLogEntry(i18n("Not using virtual IP addresses."), KVpncEnum::debug);
            }
        } else {
            if (wrongAddress != "")
                KMessageBox::error(this, i18n("No valid IP address for %1 entered." , wrongAddress), i18n("No Valid IP Address"));
            profileData->setUseVirtualIP(false);
        }

        if (!profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked())
            ok = true;

    } else if (currentpage == newprofilewizardpskpage) {
        msg = i18n("These fields must be filled in:\n");
        if (newprofilewizardpskcontent->CheckSavePsk->isChecked()) {
            if (!newprofilewizardpskcontent->PskInFileCheckBox->isChecked()) {
                profileData->setSavePsk(true);
                profileData->setPskIsInFile(false);
                if (!newprofilewizardpskcontent->PSKLineEdit->text().isEmpty()) {
                    profileData->setPreSharedKey(newprofilewizardpskcontent->PSKLineEdit->text());
                } else {
                    msg += "- " + i18n("Pre shared key") + "\n";
                    ok = false;
                }
            } else {
                profileData->setSavePsk(true);
                profileData->setPskIsInFile(true);
                if (!newprofilewizardpskcontent->PSKFileURLRequester->url().toLocalFile().isEmpty()) {
                    profileData->setPreSharedKey(newprofilewizardpskcontent->PSKLineEdit->text());
                } else {
                    ok = false;
                    msg += "- " + i18n("Pre shared key file") + "\n";
                }
            }

        } else {
            profileData->setSavePsk(false);
        }

        if (newprofilewizardpskcontent->PskInFileCheckBox->isChecked()) {
            profileData->setSavePsk(newprofilewizardpskcontent->CheckSavePsk->isChecked());
            if (!newprofilewizardpskcontent->PSKFileURLRequester->url().toLocalFile().isEmpty()) {
                profileData->setPreSharedKeyFile(newprofilewizardpskcontent->PSKFileURLRequester->url().toLocalFile());
            } else {
                ok = false;
                msg += "- " + i18n("Pre shared key file") + "\n";
            }
        }
        if (newprofilewizardpskcontent->CheckSavePsk->isChecked())
            profileData->setPreSharedKey(newprofilewizardpskcontent->PSKLineEdit->text());
        else
            profileData->setPreSharedKey("");

        profileData->setPreSharedKey(newprofilewizardpskcontent->PSKLineEdit->text());

    } else if (currentpage == newprofilewizardcertpage) {

        profileData->setSpecialRemoteID(newprofilewizardcertcontent->RemoteIDLineEdit->text());
        profileData->setUseSpecialRemoteID(newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked());
        profileData->setX509Certificate(newprofilewizardcertcontent->x509certURLRequester->url().path());
        profileData->setCaCertificate(newprofilewizardcertcontent->CaCertpathURLRequester->url().path());
        profileData->setCertPath(newprofilewizardcertcontent->certpathURLRequester->url().path());
        profileData->setPrivateKey(newprofilewizardcertcontent->privkeypathURLRequester->url().path());
        profileData->setPrivateKeyPass(newprofilewizardcertcontent->PrivkeyPasswordEdit->text());
        profileData->setX509Certificate(newprofilewizardcertcontent->x509certURLRequester->url().path());
        profileData->setCertPath(newprofilewizardcertcontent->certpathURLRequester->url().path());
        profileData->setUseSpecialServerCertificate(newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked());
        profileData->setSpecialServerCertificate(newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url().path());

        if (!newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty())
            profileData->setSavePrivateKeyPassword(true);
        else
            profileData->setSavePrivateKeyPassword(false);

        msg = i18n("These fields must be filled in:\n");

        if (newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked()) {
            if (newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url().path().isEmpty()) {
                ok = false;
                msg += "- " + i18n("special server certificate") + "\n";
                //     KMessageBox::error ( this, i18n( "Special server certificate cannot be empty." ), i18n( "No Server Certificate" ) );
                GlobalConfig->appendLogEntry(i18n("Special server certificate cannot be empty.") , KVpncEnum::error);
            }
        }

        if (newprofilewizardcertcontent->CaCertpathURLRequester->url().isEmpty()) {
            ok = false;
            msg += "- " + i18n("CA certificate") + "\n";
            GlobalConfig->appendLogEntry(i18n("CA Certificate cannot be empty.") , KVpncEnum::error);
        }

        if (!newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked()) {
            if ((!profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->x509certURLRequester->url().path().isEmpty()) || (profileData->getConnectionType() == VpnAccountData::ciscoorig && newprofilewizardcertcontent->x509certURLRequester->url().path().isEmpty())) {
                ok = false;
                msg += "- " + i18n("certificate") + "\n";
                GlobalConfig->appendLogEntry(i18n("Certificate cannot be empty.") , KVpncEnum::error);
            }

            if (!profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->privkeypathURLRequester->url().path().isEmpty()) {
                ok = false;
                msg += "- " + i18n("path to private key") + "\n";
                GlobalConfig->appendLogEntry(i18n("Path to private key cannot be empty.") , KVpncEnum::error);
            }
//    if ( ! ( profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ) && !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty() )
//    {
//     if ( Utils ( GlobalConfig ).getNeedsPassphrase ( newprofilewizardcertcontent->privkeypathURLRequester->url().path() ) )
//     {
//      ok = false;
//      msg += "- " + i18n ( "Private key password, private key needs passphrase." ) + "\n";
//      GlobalConfig->appendLogEntry ( i18n ( "Private key password cannot be empty because private key is protected with a passphrase." ) , KVpncEnum::error );
//     }
//    }

        } else {
            if (newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().isEmpty() || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText().isEmpty())
                nextButton()->setEnabled(false);
            else
                nextButton()->setEnabled(true);
        }
        if (newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked()) {
            if (newprofilewizardcertcontent->RemoteIDLineEdit->text().isEmpty()) {
                ok = false;
                msg += "- " + i18n("Special remote ID") + "\n";
                //     KMessageBox::error ( this, i18n( "Special server certificate cannot be empty." ), i18n( "No Server Certificate" ) );
                GlobalConfig->appendLogEntry(i18n("Special remote ID cannot be empty.") , KVpncEnum::error);
            }
        }


        if (newprofilewizardcertcontent->UseSmartcardCheckBox->isEnabled() && newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked()) {
            if (!newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().isEmpty())
                profileData->setPkcs11Slot(newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText());
            else {
                KMessageBox::error(this, i18n("Slot at smartcard cannot be empty."), i18n("No smartcard slot"));
                //    GlobalConfig->appendLogEntry( i18n( "Slot at smartcard cannot be empty." ) ,KVpncEnum::error);
                ok = false;
            }
            if (!newprofilewizardcertcontent->Pkcs11IdComboBox->currentText().isEmpty())
                profileData->setPkcs11Id(newprofilewizardcertcontent->Pkcs11IdComboBox->currentText());
            else {
                KMessageBox::error(this, i18n("ID for certificate at smartcard cannot be empty."), i18n("No certificate ID"));
                //    GlobalConfig->appendLogEntry( i18n( "ID for certificate at smartcard cannot be empty." ) ,KVpncEnum::error);
                ok = false;
            }
            QString Pkcs11SlotType = newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->currentText();
            if (Pkcs11SlotType == i18n("ID"))
                profileData->setPkcs11SlotType("id");
            else if (Pkcs11SlotType == i18n("Name"))
                profileData->setPkcs11SlotType("name");
            else
                profileData->setPkcs11SlotType("label");

            QString Pkcs11IdType = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentText();
            if (Pkcs11IdType == i18n("ID"))
                profileData->setPkcs11IdType("id");
            else if (Pkcs11IdType == i18n("Label"))
                profileData->setPkcs11IdType("label");
            else
                profileData->setPkcs11IdType("subject");

            QString Pkcs11SignMode = newprofilewizardcertcontent->Pkcs11SignModeComboBox->currentText();
            if (Pkcs11SignMode == i18n("auto"))
                profileData->setPkcs11SignMode("auto");
            else if (Pkcs11SignMode == i18n("sign"))
                profileData->setPkcs11SignMode("sign");
            else if (Pkcs11SignMode == i18n("recover"))
                profileData->setPkcs11SignMode("recover");
            else
                profileData->setPkcs11SignMode("any");

            if (newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked()) {
                if (!newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty())
                    profileData->setPkcs11Providers(newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().path());
                else {
                    KMessageBox::error(this, i18n("Library path to lib for use with smartcard cannot be empty."), i18n("No providers lib"));
                    //    GlobalConfig->appendLogEntry( i18n( "Library path to lib for use with smartcard cannot be empty." ) ,KVpncEnum::error);
                    ok = false;
                }
            }
            profileData->setUsePkcs11Providers(newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked());
        }

    } else if (currentpage == newprofilewizarduserpage) {
        msg = i18n("These fields must be filled in:\n");
        if (newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty()) {
            ok = false;
            msg += "- " + i18n("Username") + "\n";
            GlobalConfig->appendLogEntry(i18n("Username is empty."), KVpncEnum::error);
        } else {
            profileData->setUserName(newprofilewizarduserpagecontent->UsernameLineEdit->text());
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("User options: username: %1" , profileData->getUserName()), KVpncEnum::debug);
        }

        if (!newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty()) {
            profileData->setUserPassword(newprofilewizarduserpagecontent->PasswordEdit->text());

        } else {
            if (newprofilewizarduserpagecontent->CheckUserPass->isChecked()) {
                ok = false;
                msg += "- " + i18n("Password") + "\n";
                GlobalConfig->appendLogEntry(i18n("Password is empty but you have checked to store it."), KVpncEnum::error);
            }
        }
        profileData->setUserPassword(newprofilewizarduserpagecontent->PasswordEdit->text());
        profileData->setSaveUserPassword(newprofilewizarduserpagecontent->CheckUserPass->isChecked());

        profileData->setNtDomainName(newprofilewizarduserpagecontent->NtDomainNameLineedit->text());


        if (profileData->getConnectionType() == VpnAccountData::cisco || profileData->getConnectionType() == VpnAccountData::pptp ||
                profileData->getConnectionType() == VpnAccountData::l2tpd_racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan
           ) {
            if (newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked()) {
                if (newprofilewizarduserpagecontent->NtDomainNameLineedit->text().isEmpty()) {
                    ok = false;
                    msg += "- " + i18n("NT domain name") + "\n";
                    GlobalConfig->appendLogEntry(i18n("NT domain name is empty but you have checked to specify one."), KVpncEnum::error);
                } else {
                    profileData->setNtDomainName(newprofilewizarduserpagecontent->NtDomainNameLineedit->text());
                    profileData->setUseNtDomainName(true);
                    if (GlobalConfig->KvpncDebugLevel > 0)
                        GlobalConfig->appendLogEntry(i18n("User options: NT domain name: %1" , profileData->getNtDomainName()), KVpncEnum::debug);
                }
            } else {
                profileData->setUseNtDomainName(false);
            }
        }
    } else if (currentpage == newprofilewizardnetworkpage) {
        msg = i18n("These fields must be filled in:\n");
        bool validAddr = true;
        if ((profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
                profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon)) {
            if (newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->isChecked()) {
                if (!newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().isEmpty()) {
                    if (newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().contains('.', Qt::CaseInsensitive) != 3) {
                        KMessageBox::error(this, i18n("No IP address entered."), i18n("No IP Address"));
                        validAddr = false;
                        return ;
                    } else {
                        QString addr = newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text();
                        int part0 = addr.section('.', 0, 0).toInt();
                        int part1 = addr.section('.', 1, 1).toInt();
                        int part2 = addr.section('.', 2, 2).toInt();
                        int part3 = addr.section('.', 3, 3).toInt();

                        /*
                           LogOutput->append ("part0: "+QString().setNum(part0));
                           LogOutput->append ("part1: "+QString().setNum(part1));
                           LogOutput->append ("part2: "+QString().setNum(part2));
                           LogOutput->append ("part3: "+QString().setNum(part3));
                        */

                        if ((part0 < 1 || part0 > 254) || (part1 < 0 || part1 > 254) || (part2 < 0 || part2 > 254) || (part3 < 0 || part3 > 254)) {
                            KMessageBox::error(this, i18n("Invalid values in IP address (remote net)."), i18n("Invalid Values in IP Address"));
                            GlobalConfig->appendLogEntry(i18n("Invalid values in IP address (remote net).") , KVpncEnum::error);
                            validAddr = false;
                            return ;
                        }

                        if (validAddr == true) {
                            if (GlobalConfig->KvpncDebugLevel > 0)
                                GlobalConfig->appendLogEntry(i18n("Use remote network: %1/%2" , QString(addr), QString(newprofilewizardnetworkcontent->RemoteNetMaskComboBox->currentText())), KVpncEnum::debug);
                            profileData->setUseRemoteNetwork(true);
                            profileData->setRemoteNetAddr(addr);
                            profileData->setRemoteNetMask(newprofilewizardnetworkcontent->RemoteNetMaskComboBox->currentText());
                        }

                    }
                } else {
                    ok = false;
                    msg += "- " + i18n("Remote network") + "\n";
                    GlobalConfig->appendLogEntry(i18n("Remote network is empty."), KVpncEnum::error);
                }
            }
        }
        profileData->setNetworkDevice(newprofilewizardnetworkcontent->NetworkDeviceComboBox->currentText());

        profileData->setMtu(newprofilewizardnetworkcontent->MtuSpinbox->value());
        if (newprofilewizardnetworkcontent->MtuCheckbox->isChecked()) {
            profileData->setUseMtu(true);
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network options: use own MTU size: %1" , profileData->getMtu()) , KVpncEnum::debug);
        } else
            profileData->setUseMtu(false);

        profileData->setMru(newprofilewizardnetworkcontent->MruSpinbox->value());
        if (newprofilewizardnetworkcontent->MruCheckbox->isChecked()) {
            profileData->setUseMru(true);
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network options: use own MRU size: %1" , profileData->getMtu()) , KVpncEnum::debug);
        } else
            profileData->setUseMru(false);

        if (profileData->getConnectionType() == VpnAccountData::ssh) {
            profileData->setTunnelDeviceType(newprofilewizardnetworkcontent->TunnelDeviceTypeComboBox->currentText());
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network options: Tunnel device type: %1" , QString(profileData->getTunnelDeviceType())) , KVpncEnum::debug);

            tunnelDeviceTypeChanged(profileData->getTunnelDeviceType());
        }

    } else if (currentpage == newprofilewizardnetworkroutepage) {
        msg = i18n("These fields must be filled in:\n");

        if (newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentIndex() == 1) {
            profileData->setReplaceDefaultRoute(true);

            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network route options: replace default route") , KVpncEnum::debug);
        } else {
            profileData->setReplaceDefaultRoute(false);
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network route options: do not replace default route")  , KVpncEnum::debug);
        }

        profileData->setUseAdditionalNetworkRoutes(newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked());

        if (newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() && newprofilewizardnetworkroutecontent->NetworkListView->topLevelItemCount() > 0) {
            if (GlobalConfig->KvpncDebugLevel > 1)
                GlobalConfig->appendLogEntry(i18n("Network route options: use additional network routes") , KVpncEnum::debug);

            QStringList AdditionalNetworkRoutes;
            QTreeWidgetItemIterator it(newprofilewizardnetworkroutecontent->NetworkListView);
            while (*it) {
                // example entry:
                // <network>/<netmask>#<gateway>
                QString network = QString((*it)->text(0) + "/" + (*it)->text(1));
                network.append("#");
                network.append((*it)->text(2));       // gateway
                network.append("#");
                network.append((*it)->text(3));       // interface
                AdditionalNetworkRoutes.append(network);

                if (GlobalConfig->KvpncDebugLevel > 1)
                    GlobalConfig->appendLogEntry(i18n("Network route options: additional network: %1/%2 gw %3 %4" , (*it)->text(0) , (*it)->text(1) , (*it)->text(2) , (*it)->text(3)) , KVpncEnum::debug);
                ++it;
            }
            profileData->setAdditionalNetworkRoutes(AdditionalNetworkRoutes);
        }

    } else if (currentpage == newprofilewizardnatpage) {
        profileData->setUseUdp(newprofilewizardnatcontent->UseUdpCheckbox->isChecked());
        profileData->setUseUdpPort(newprofilewizardnatcontent->UdpPortCheckbox->isChecked());
        profileData->setUdpPort(newprofilewizardnatcontent->UdpPortSpinbox->value());
        if (GlobalConfig->KvpncDebugLevel > 0) {
            if (profileData->getUseUdp())
                GlobalConfig->appendLogEntry(i18n("NAT settings: use NAT."), KVpncEnum::debug);
            else
                GlobalConfig->appendLogEntry(i18n("NAT settings: use no NAT."), KVpncEnum::debug);

            if (profileData->getUseUdpPort())
                GlobalConfig->appendLogEntry(i18n("NAT settings: use user-defined Port: %1." , QString().setNum(profileData->getUdpPort())), KVpncEnum::debug);
        }


    } else if (currentpage == newprofilewizardconnectoptionspage) {
        connectaftercreating = newprofilewizardconnectoptionscontent->ConnectAfterCreatingProfileCheckBox->isChecked();

        if (GlobalConfig->KvpncDebugLevel > 0)
            if (connectaftercreating)
                GlobalConfig->appendLogEntry(i18n("Connect options: connecting to profile \"%1\" after creating it." , profileData->getName()) , KVpncEnum::debug);

    } else if (currentpage == newprofilewizardconnectionstatuscheckpage) {
        msg = i18n("These fields must be filled in:\n");
        if (newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked()) {
            profileData->setUseConnectionStatusCheck(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: use connection status check."), KVpncEnum::debug);
        } else {
            profileData->setUseConnectionStatusCheck(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: do not use connection status check."), KVpncEnum::debug);
        }

        if (newprofilewizardconnectionstatuscheckcontent->DoReconnectAfterConnectionLostCheckBox->isChecked()) {
            profileData->setDoReconnectAfterConnectionLost(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: reconnect after connection is lost."), KVpncEnum::debug);
        } else {
            profileData->setDoReconnectAfterConnectionLost(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: do not reconnect after connection is lost."), KVpncEnum::debug);
        }

        if (newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked()) {
            profileData->setDoPingIP(true);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: ping user-defined IP address."), KVpncEnum::debug);
        } else {
            profileData->setDoPingIP(false);
            if (GlobalConfig->KvpncDebugLevel > 0)
                GlobalConfig->appendLogEntry(i18n("Connection status check: do not ping user-defined IP address."), KVpncEnum::debug);
        }

        profileData->setConnectionStatusInterval(newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value());
        profileData->setConnectionStatusCheckSuccessCount(newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value());

        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("Connection status check: use connection interval: %1." , QString().setNum(newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value())), KVpncEnum::debug);
            GlobalConfig->appendLogEntry(i18n("Connection status check: success count: %1" , QString().setNum(newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value())), KVpncEnum::debug);
        }

        if (newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked()) {
            if (newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked()) {
                if (!newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text().isEmpty()) {
                    if (Utils(GlobalConfig).isValidIPv4Address(newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text()))
                        profileData->setPingHostIP(newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text());
                    else {
                        ok = false;
                        msg = i18n("The value of the user-defined IP address is not a valid IP address.");
                    }
                } else {
                    ok = false;
                    msg += i18n("user-defined IP for ping") + "\n";
                }
            }
        }
    } else if (currentpage == endpage) {}
    if (ok) {
        previouspage = currentpage;
        Q3Wizard::next();
    } else {
        KMessageBox::error(this, msg);
    }
}

void NewProfileWizard::back()
{
    /*
    currentpage=previouspage;
    //  showPage(previouspage);

    if ( currentpage == page1 )
    {
     // nothing here
    }
    else if ( currentpage == newprofilewizardgeneralpage )
    {
     newprofilewizardgeneralpagecontent->NameLineEdit->setText(profileData->getName());
     newprofilewizardgeneralpagecontent->gatewayLineEdit->setText(profileData->getGateway());
     newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText(profileData->getDescription());
    }
    else if ( currentpage == newprofilewizardtypeselectionpage )
    {
     if ( profileData->getConnectionType() == VpnAccountData::cisco )
      newprofilewizardtypeselectionpagecontent->CiscoRadioButton->setChecked(true);
     else if ( profileData->getConnectionType() == VpnAccountData::freeswan  ||
        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
      newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
     else if ( profileData->getConnectionType() == VpnAccountData::racoon  || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon)
      newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
     else if ( profileData->getConnectionType() == VpnAccountData::pptp )
      newprofilewizardtypeselectionpagecontent->PptpRadioButton->setChecked(true);
     else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
      newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->setChecked(true);
    }
    else if ( currentpage == newprofilewizardciscoselectionpage )
    {}
    else if ( currentpage == newprofilewizardciscomanuallypage )
    {
     newprofilewizardciscomanuallypagecontent->IDLineEdit->setText(profileData->getGateway());
     newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->setChecked(profileData->getAllowEmptyGroupPassword());
     newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->setText(profileData->getPreSharedKey());
     profileData->setID(newprofilewizardciscomanuallypagecontent->IDLineEdit->text());

     insertPage ( newprofilewizardciscoselectionpage, "<b>"+ i18n("Cisco selection")+"</b>", 2 );

    }
    else if ( currentpage == newprofilewizardracoonpage )
    {
     newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentItem(profileData->getHashAlgo());

     insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
     insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
     insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
     insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("OpenVPN settings")+"</b>"  , 5 );
     insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
    }
    else if ( currentpage == newprofilewizardfreeswanpage )
    {
     insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
     insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
     insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  , 4 );
     insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
     insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  5 );
    }
    else if ( currentpage == newprofilewizardopenvpnpage )
    {
     newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentItem(profileData->getTunnelDeviceType() );
     newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setCurrentItem(profileData->getNsCertType());
     newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentItem(profileData->getTunnelDeviceType() );
     newprofilewizardopenvpnpagecontent->UseRedirectGatewayCheckBox->setChecked(profileData->getUseRedirectGateway() );

     newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setCurrentItem(profileData->getUserdefiniedCipher());
     newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked(profileData->getUseUserdefiniedCipher());
     newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked(profileData->getUseTlsAuth());
     newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setUrl(profileData->getTlsAuthFile());

     profileData->setUseTlsRemoteHost( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked());
     profileData->setTlsRemoteHost( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text());

     profileData->setUseHttpProxy( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() );
     profileData->setHttpProxy( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text( ) );
     profileData->setHttpProxyPort( newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value( ) );
     profileData->setHttpProxyTimeout( newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value() );

     insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
     insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
     insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("Ipsec settings")  ,  4 );
     insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
     insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
    }
    else if ( currentpage == newprofilewizardpptppage )
    {
     insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
     insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
     insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("Ipsec settings")  ,  4 );
     insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
     insertPage ( newprofilewizardopenvpnpage,   "<b>"+i18n("OpenVPN settings")+"</b>", 6 );
    }
    else if ( currentpage == newprofilewizarduserpage )
    {
     newprofilewizarduserpagecontent->UsernameLineEdit->setText(profileData->getUserName());
     newprofilewizarduserpagecontent->PasswordEdit->setText(profileData->getUserPassword() );
     newprofilewizarduserpagecontent->CheckUserPass->setChecked(profileData->getSaveUserPassword());
    }
    else if ( currentpage == newprofilewizardnetworkpage )
    {
     newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->setText(profileData->getRemoteNetAddr() );
     newprofilewizardnetworkcontent->RemoteNetMaskComboBox->setCurrentItem(profileData->getRemoteNetMask());
     newprofilewizardnetworkcontent->NetworkDeviceComboBox->setCurrentItem(profileData->getNetworkDevice());
    }
    else if ( currentpage == newprofilewizardnatpage )
    {
     newprofilewizardnatcontent->UseUdpCheckbox->setChecked(profileData->getUseUdp());
     newprofilewizardnatcontent->UdpPortCheckbox->setChecked(profileData->getUseUdpPort ());
     newprofilewizardnatcontent->UdpPortSpinbox->setValue(profileData->getUdpPort());
    }
    */
    Q3Wizard::back();
}

QString NewProfileWizard::getName()
{
    return profileData->getName();
}

bool NewProfileWizard::getFinished()
{
    return finished;
}

// void NewProfileDialog::reject()
// {
//
// }

void NewProfileWizard::showPage(QWidget* page)
{
    currentpage = page;
    Q3Wizard::showPage(page);


    // FIXME set currentpage at back()
    //backButton()->setEnabled(false);

    helpButton() ->setEnabled(false);

    if (page == endpage) {
        finishButton() ->setEnabled(true);
        finishButton() ->setFocus();
    }
}

void NewProfileWizard::dataChanged(const QString &)
{
    //     if ( !firstName->text().isEmpty() &&
    //          !lastName->text().isEmpty() &&
    //          !email->text().isEmpty() )
    //         nextButton()->setEnabled(true);
    //     else
    //         nextButton()->setEnabled(false);
}

void NewProfileWizard::userdefinedOpenvpnPortToggeled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked())
        newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled(true);
    else
        newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled(false);
}

void NewProfileWizard::nsCertTypeOpenvpnToggled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->isChecked())
        newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled(true);
    else
        newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled(false);
}

void NewProfileWizard::pskIsInFileToggled(bool)
{
    if (newprofilewizardpskcontent->PskInFileCheckBox->isChecked()) {
        newprofilewizardpskcontent->LabelPskFile->setEnabled(true);
        newprofilewizardpskcontent->PSKFileURLRequester->setEnabled(true);
        newprofilewizardpskcontent->LabelPsk->setEnabled(false);
        newprofilewizardpskcontent->PSKLineEdit->setEnabled(false);
    } else {
        newprofilewizardpskcontent->LabelPskFile->setEnabled(false);
        newprofilewizardpskcontent->PSKFileURLRequester->setEnabled(false);
        newprofilewizardpskcontent->LabelPsk->setEnabled(true);
        newprofilewizardpskcontent->PSKLineEdit->setEnabled(true);
    }
}

void NewProfileWizard::useUdpToggled(bool)
{
    if (newprofilewizardnatcontent->UseUdpCheckbox->isChecked()) {
        newprofilewizardnatcontent->UdpPortCheckbox->setEnabled(true);
        newprofilewizardnatcontent->UdpPortSpinbox->setEnabled(true);
    } else {
        newprofilewizardnatcontent->UdpPortCheckbox->setEnabled(false);
        newprofilewizardnatcontent->UdpPortSpinbox->setEnabled(false);
    }
}

void NewProfileWizard::udpPortToggled(bool)
{
    if (newprofilewizardnatcontent->UdpPortCheckbox->isChecked()) {
        newprofilewizardnatcontent->UdpPortSpinbox->setEnabled(true);
    } else {
        newprofilewizardnatcontent->UdpPortSpinbox->setEnabled(false);
    }
}

void NewProfileWizard::pingIpAfterConnectToggled(bool)
{
    if (newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked())
        newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled(true);
    else
        newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled(false);
}

void NewProfileWizard::useUserdefiniedCipherToggled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked())
        newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled(true);
    else
        newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled(false);
}

void NewProfileWizard::useSpecialRemoteIDToggled(bool)
{
    if (newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked())
        newprofilewizardcertcontent->RemoteIDLineEdit->setEnabled(true);
    else
        newprofilewizardcertcontent->RemoteIDLineEdit->setEnabled(false);
}

void NewProfileWizard::useSpecialServerCertificateToggled(bool)
{
    if (newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked()) {
        newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled(true);
    } else {
        newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled(false);
    }
}

void NewProfileWizard::useTlsAuthToggled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox ->isChecked()) {
        newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled(true);
        newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled(true);
    } else {
        newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled(false);
        newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled(false);
    }
}

void NewProfileWizard::useHttpProxyToggeled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked()) {
        newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled(true);
        newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled(true);
        newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled(true);
        newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled(true);
        newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled(true);
        newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled(true);
    } else {
        newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled(false);
        newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled(false);
        newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled(false);
        newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled(false);
        newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled(false);
        newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled(false);
    }
}

void NewProfileWizard::useTlsRemoteHostToggled(bool)
{
    if (newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked())
        newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled(true);
    else
        newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled(false);
}

void NewProfileWizard::connectionStatusCheckToggled(bool)
{
    if (!newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked()) {
        newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled(false);
        newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled(false);
    } else {
        newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled(true);
        newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled(true);
    }
}

bool NewProfileWizard::importProfile(VpnAccountData::ConnectionType ConnType)
{
    // FIXME make dlg dynamiclly

    bool success = true;

    if (ConnType == VpnAccountData::cisco || ConnType == VpnAccountData::ciscoorig) {
        ImportProfileDialog dlg(GlobalConfig, this, i18n("Import Cisco PCF profile"), "");
        dlg.exec();
        importOK = dlg.importOk;
        if (importOK) {
            profileData = dlg.acc;
            KMessageBox::information(0, i18n("Import of \"%1\" was successful." ,   profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) was successful." ,   profileData->getName() ,    QString("PCF")), KVpncEnum::info);
        } else {
            KMessageBox::sorry(0, i18n("Import of \"%1\" has been failed." ,   profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) has been failed." ,   profileData->getName() ,   QString("PCF")), KVpncEnum::error);
            success = false;
        }
    }
    if (ConnType == VpnAccountData::openvpn) {
        ImportOpenvpnProfileDialog dlg(GlobalConfig, this, i18n("Import OpenVPN profile"), "");
        dlg.exec();
        importOK = dlg.importOk;
        if (importOK) {
            profileData = dlg.acc;
            KMessageBox::information(0, i18n("Import of \"%1\" was successful." ,   profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) was successful." ,   profileData->getName() ,   QString("OpenVPN")), KVpncEnum::info);
        } else {
            KMessageBox::sorry(0, i18n("Import of \"%1\" has been failed." ,   profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) has been failed." ,   profileData->getName() ,   QString("OpenVPN")), KVpncEnum::error);
            success = false;
        }
    }
    if (ConnType == VpnAccountData::freeswan) {
        ImportIpsecProfileDialog dlg(GlobalConfig, this, i18n("Import IPSec profile"), "");
        dlg.setWindowTitle(i18n("Import IPSec config"));
        dlg.exec();
        importOK = dlg.importOk;
        if (importOK) {
            profileData = dlg.acc;
            KMessageBox::information(0, i18n("Import of \"%1\" was successful.", profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) was successful." , profileData->getName() , QString("IPSec")), KVpncEnum::info);
        } else {
            KMessageBox::sorry(0, i18n("Import of \"%1\" has been failed." , profileData->getName()));
            GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) has been failed." , profileData->getName() , QString("IPsec")), KVpncEnum::error);
            success = false;
        }
    }

    return success;

}

bool NewProfileWizard::importCertificate()
{
    bool success = true;

    newprofilewizardcertcontent->CaCertpathURLRequester->clear();
    newprofilewizardcertcontent->certpathURLRequester->clear();
    newprofilewizardcertcontent->PrivkeyPasswordEdit->clear();
    ImportCertificateDialog dlg(this, i18n("Import Certificate...").toAscii(), GlobalConfig);

    if (profileData->getConnectionType() == VpnAccountData::freeswan ||
            profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
        dlg.main->ImporttypeComboBox->setCurrentItem(i18n("P12: freeswan"));
        dlg.typeToggeled(ImportCertificateDialog::pkcs12_freeswan);
    } else if (profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon) {
        dlg.main->ImporttypeComboBox->setCurrentItem(i18n("P12: racoon"));
        dlg.main->PrivateKeyPassGroupBox->setEnabled(false);
        dlg.typeToggeled(ImportCertificateDialog::pkcs12_racoon);
    } else if (profileData->getConnectionType() == VpnAccountData::openvpn) {
        dlg.main->ImporttypeComboBox->setCurrentItem(i18n("OpenVPN"));
        dlg.typeToggeled(ImportCertificateDialog::pkcs12_openvpn);
        dlg.main->RacoonCertificatePathUrlrequester->setEnabled(true);
        dlg.main->RacoonCertificatePathUrlrequester->setUrl(profileData->getCertPath());
        dlg.main->PrivateKeyPassGroupBox->setEnabled(true);
        dlg.main->PrivateKeyPasswordEdit->setEnabled(true);
        dlg.main->PrivateKeyAgainPasswordEdit->setEnabled(true);
    } else if (profileData->getConnectionType() == VpnAccountData::ciscoorig) {
        dlg.main->ImporttypeComboBox->setCurrentItem(i18n("Cisco (proprietary)"));
        dlg.typeToggeled(ImportCertificateDialog::cisco);
        dlg.main->RacoonCertificatePathUrlrequester->setEnabled(false);
        //   dlg.main->RacoonCertificatePathUrlrequester->hide();
        dlg.main->PrivateKeyPassGroupBox->setEnabled(true);
        dlg.main->PrivateKeyPasswordEdit->setEnabled(true);
        dlg.main->PrivateKeyAgainPasswordEdit->setEnabled(true);
    }


    dlg.exec();
    importOK = dlg.importOk;
    QString filename = dlg.filename;
    if (importOK) {
        QString certpath = dlg.certpath;
        QString CertFullPath = dlg.CertFullPath;
        QString CaCertFullPath = dlg.CaCertFullPath;
        QString importpassword = dlg.main->ImportPasswordEdit->text();
        QString privatekeypassword = dlg.main->PrivateKeyPasswordEdit->text();
        QString certificate = QString("mykeys_" + dlg.certName + ".pem");
        QString privatekey = QString(dlg.certName + ".pem");

        QString certpostfix = "";
        QString privatepostfix = "";
        if (profileData->getConnectionType() == VpnAccountData::freeswan ||
                profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
            certpostfix = "certs/";
            privatepostfix = "private/";
        }

        newprofilewizardcertcontent->CaCertpathURLRequester->setUrl(CaCertFullPath);


        if (profileData->getConnectionType() == VpnAccountData::openvpn)
            newprofilewizardcertcontent->PrivkeyPasswordEdit->setText(importpassword);
        else
            newprofilewizardcertcontent->PrivkeyPasswordEdit->setText(privatekeypassword);

        if (profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
                profileData->getConnectionType() == VpnAccountData::racoon)
            newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(false);


        newprofilewizardcertcontent->certpathURLRequester->setUrl(certpath);

        if (profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
                profileData->getConnectionType() == VpnAccountData::racoon) {
            newprofilewizardcertcontent->privkeypathURLRequester->setUrl(certpath + "/" + certpostfix + certificate);
            newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(false);
        } else
            newprofilewizardcertcontent->privkeypathURLRequester->setUrl(certpath + "/" + privatepostfix + privatekey);
        newprofilewizardcertcontent->x509certURLRequester->setUrl(certpath + "/" + certpostfix + certificate);

        KMessageBox::information(0, i18n("Import of \"%1\" was successful." ,   filename));
        GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) was successful." ,   filename ,   "P12 certificate"), KVpncEnum::info);
    } else {
        GlobalConfig->appendLogEntry(i18n("Import of \"%1\" (%2) has been failed." ,   filename ,   "P12 certificate"), KVpncEnum::info);
        success = false;
    }
    return success;
}

void NewProfileWizard::authenticateWithUsernameAndPasswordToggled(bool)
{
    if (newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked())
        newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled(true);
    else
        newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled(false);
}

void NewProfileWizard::pskInputToggled(const QString&)
{
    if (!newprofilewizardpskcontent->PSKLineEdit->text().isEmpty())
        newprofilewizardpskcontent->CheckSavePsk->setChecked(true);
    else
        newprofilewizardpskcontent->CheckSavePsk->setChecked(false);
}

void NewProfileWizard::userpassToggled(const QString&)
{
    if (!newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty())
        newprofilewizarduserpagecontent->CheckUserPass->setChecked(true);
    else
        newprofilewizarduserpagecontent->CheckUserPass->setChecked(false);
}

void NewProfileWizard::usernameToggled(const QString&)
{
    //  if (newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty())
    //   newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(true);
    //  else
    //   newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(false);
}

void NewProfileWizard::pskToggled(const QString&)
{
    if (!newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text().isEmpty())
        newprofilewizardciscomanuallypagecontent->CheckSavePsk->setChecked(true);
    else
        newprofilewizardciscomanuallypagecontent->CheckSavePsk->setChecked(false);
}

void NewProfileWizard::useRightNextHopToggled(bool)
{
    if (newprofilewizardfreeswanpagecontent->UseRightNextHopCheckBox->isChecked())
        newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->setEnabled(true);
    else
        newprofilewizardfreeswanpagecontent->RightNextHopLineEdit->setEnabled(false);
}

void NewProfileWizard::useLeftNextHopToggled(bool)
{
    if (newprofilewizardfreeswanpagecontent->UseLeftNextHopCheckBox->isChecked())
        newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->setEnabled(true);
    else
        newprofilewizardfreeswanpagecontent->LeftNextHopLineEdit->setEnabled(false);
}

void NewProfileWizard::additionalNetworkRoutesToggled(bool)
{
    if (newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked()) {
        newprofilewizardnetworkroutecontent->NetworkListView->setEnabled(true);
        newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled(true);
        newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled(true);
    } else {
        newprofilewizardnetworkroutecontent->NetworkListView->setEnabled(false);
        newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled(false);
        newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled(false);
    }
}

void NewProfileWizard::delNetworkRouteClicked()
{
    if (newprofilewizardnetworkroutecontent->NetworkListView->topLevelItemCount() > 0 && newprofilewizardnetworkroutecontent->NetworkListView->currentItem() != 0) {
        QTreeWidgetItem* item = newprofilewizardnetworkroutecontent->NetworkListView->currentItem();
        QString Network = item->text(0);
        QString Netmask = item->text(1);
        int result = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the network \"%1/%2\"?" ,   Network ,   Netmask), i18n("Delete?"));
        //LogOutput->append( "Result: "+ QString().setNum(result) ) ;
        if (result == 3) {  // Yes
            newprofilewizardnetworkroutecontent->NetworkListView->removeChild((QObject *)item);
        }
    }
}

void NewProfileWizard::addNetworkRouteClicked()
{
    AddNetworkRouteDialog dlg(this, i18n("Add Network Route..."));


    dlg.InterfaceComboBox->insertItem(0, "default");    // interface where default route points

    //FIXME
    dlg.InterfaceComboBox->insertItem(1, "eth0");
    dlg.InterfaceComboBox->insertItem(2, "eth1");
    dlg.InterfaceComboBox->insertItem(3, "eth2");
    dlg.InterfaceComboBox->insertItem(4, "ipsec0");
    dlg.InterfaceComboBox->insertItem(5, "tun0");
    dlg.InterfaceComboBox->insertItem(6, "ppp0");

    if (dlg.exec()) {
        QString gateway = dlg.getGateway();
        QString interface = dlg.getInterface();
        if (!dlg.getUseGateway())
            gateway = "-";
        if (!dlg.getUseInterface())
            interface = "-";
        QList<QTreeWidgetItem *> items;
        QStringList values;
        values << dlg.getNetwork() << dlg.getNetmask() << gateway << interface;
        items.append(new QTreeWidgetItem((QTreeWidget*)0, values));
        newprofilewizardnetworkroutecontent->NetworkListView->insertTopLevelItems(0, items);
    }
}

void NewProfileWizard::domainNameToggled(bool)
{
    if (newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked())
        newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled(true);
    else
        newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled(false);
}

void NewProfileWizard::useSmartcardToggled(bool)
{
    if (newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked()) {
        newprofilewizardcertcontent->SmartcardGroupBox->setEnabled(true);
        newprofilewizardcertcontent->x509certURLRequester->setEnabled(false);
        newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(false);
        newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(false);
        newprofilewizardcertcontent->LabelCertificate->setEnabled(false);
        newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(false);
        newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(false);
        newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(false);

//   newprofilewizardcertcontent->CertificateGroupBox->setEnabled(false);


//   if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
//   {
//    ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
//    if ( GlobalConfig->programsInPath )
//    {
//     IpsecToolInfo.addSearchPath( "/sbin" );
//     IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
//     IpsecToolInfo.addSearchPath( "/usr/sbin" );
//     IpsecToolInfo.addSearchPath( "/bin" );
//     IpsecToolInfo.addSearchPath( "/usr/local/bin" );
//     IpsecToolInfo.addSearchPath( "/usr/bin" );
//    }
//    IpsecToolInfo.collectToolInfo();
//    if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free", Qt::CaseInsensitive))
//     KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.", QString(IpsecToolInfo.Version.section(' ',0,0))),i18n("Unsupported IPSec version"));
//   }

    } else {
        newprofilewizardcertcontent->SmartcardGroupBox->setEnabled(false);
        newprofilewizardcertcontent->x509certURLRequester->setEnabled(true);
        newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled(true);
        newprofilewizardcertcontent->privkeypathURLRequester->setEnabled(true);
        newprofilewizardcertcontent->LabelCertificate->setEnabled(true);
        newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled(true);
        newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled(true);

//   newprofilewizardcertcontent->CertificateGroupBox->setEnabled(true);
    }
}

void NewProfileWizard::useSmartcardOnCertFormateToggled(bool)
{
    if (newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked()) {
        newprofilewizardp12certselectioncontent->P12Group->setEnabled(false);
//   if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
//   {
//    ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
//    if ( GlobalConfig->programsInPath )
//    {
//     IpsecToolInfo.addSearchPath( "/sbin" );
//     IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
//     IpsecToolInfo.addSearchPath( "/usr/sbin" );
//     IpsecToolInfo.addSearchPath( "/bin" );
//     IpsecToolInfo.addSearchPath( "/usr/local/bin" );
//     IpsecToolInfo.addSearchPath( "/usr/bin" );
//    }
//    IpsecToolInfo.collectToolInfo();
//    if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free", Qt::CaseInsensitive))
//     KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.", QString(IpsecToolInfo.Version.section(' ',0,0))),i18n("Unsupported IPSec version"));
//   }
    } else {
        newprofilewizardp12certselectioncontent->P12Group->setEnabled(true);
    }
}

void NewProfileWizard::usePkcs11ProvidersToggled(bool)
{
    if (newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked())
        newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled(true);
    else
        newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled(false);
}

void NewProfileWizard::idTypeToggled()
{
    //  if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentIndex() == 0)
    //   newprofilewizardcertcontent->IdLabel->setText(i18n("ID"));
    //  else if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentIndex() == 1)
    //   newprofilewizardcertcontent->IdLabel->setText(i18n("Label"));
    //  else
    //   newprofilewizardcertcontent->IdLabel->setText(i18n("Description"));
}

void NewProfileWizard::detectPkcs11Ids()
{
    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));
    newprofilewizardcertcontent->Pkcs11IdComboBox->clear();

    QString Pkcs11IdTypeTmp = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentText().toLower();
    if (GlobalConfig->KvpncDebugLevel > 1) {
        GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1", Pkcs11IdTypeTmp),
                                     KVpncEnum::debug);
    }

    QString ProviderLib = "";
    if (newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().toLocalFile().isEmpty())
        ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().toLocalFile();

    // we have to split slot id and name ("0 : foobar") => 0
    QString Pkcs11Slot = newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().section(':', 0, 0).trimmed();

    QStringList Pkcs11Ids = Utils(GlobalConfig).getSmartcardCertsFromSlot(Pkcs11Slot, Pkcs11IdTypeTmp, ProviderLib);
    int Pkcs11IdIdx = 0;
    for (QStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it) {
        newprofilewizardcertcontent->Pkcs11IdComboBox->insertItem(Pkcs11IdIdx, QString(*it));
        Pkcs11IdIdx++;
    }

    if (newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() == "" || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() == "")
        nextButton()->setEnabled(false);
    else
        nextButton()->setEnabled(true);

    GlobalConfig->appPointer->restoreOverrideCursor();
}

void NewProfileWizard::detectPkcs11Slots()
{
    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));
    newprofilewizardcertcontent->Pkcs11SlotComboBox->clear();
    QString ProviderLib = "";
    if (newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().toLocalFile().isEmpty())
        ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().toLocalFile();
    QStringList Pkcs11Slots = Utils(GlobalConfig).getSmartcardSlots(ProviderLib);
    int Pkcs11SlotIdx = 0;
    for (QStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it) {
        newprofilewizardcertcontent->Pkcs11SlotComboBox->insertItem(Pkcs11SlotIdx, QString(*it));
        Pkcs11SlotIdx++;
    }

    if (!Pkcs11Slots.isEmpty())
        newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(true);
    if (newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() == "" || newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() == "")
        nextButton()->setEnabled(false);  // Next
    else
        nextButton()->setEnabled(true);  // Next

    GlobalConfig->appPointer->restoreOverrideCursor();
}

void NewProfileWizard::mtuToggled(bool)
{
    if (newprofilewizardnetworkcontent->MtuCheckbox->isChecked())
        newprofilewizardnetworkcontent->MtuSpinbox->setEnabled(true);
    else
        newprofilewizardnetworkcontent->MtuSpinbox->setEnabled(false);
}

void NewProfileWizard::mruToggled(bool)
{
    if (newprofilewizardnetworkcontent->MruCheckbox->isChecked())
        newprofilewizardnetworkcontent->MruSpinbox->setEnabled(true);
    else
        newprofilewizardnetworkcontent->MruSpinbox->setEnabled(false);
}

void NewProfileWizard::useVirtualIpAddressToggled(bool)
{
    if (profilenetworkvirtualipoptionscontent->UseVirtualIPCheckBox->isChecked()) {
        profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->setEnabled(true);
        profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->setEnabled(true);
    } else {
        profilenetworkvirtualipoptionscontent->LocalVirtualIpEdit->setEnabled(false);
        profilenetworkvirtualipoptionscontent->RemoteVirtualIpLineEdit->setEnabled(false);
    }
}

void NewProfileWizard::localIDTypeToggled(const QString& text)
{
    if (text == "asn1dn") {
        newprofilewizardracoonpagecontent->LocalIDLineEdit->setDisabled(true);
        newprofilewizardracoonpagecontent->LocalIDLabel->setDisabled(true);
    } else {
        newprofilewizardracoonpagecontent->LocalIDLineEdit->setDisabled(false);
        newprofilewizardracoonpagecontent->LocalIDLabel->setDisabled(false);
    }
}

void NewProfileWizard::localIDTypeIpsecToggled(const QString& text)
{
    if (text == "asn1dn") {
        newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setDisabled(true);
        newprofilewizardfreeswanpagecontent->LocalIDLabel->setDisabled(true);
    } else {
        newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setDisabled(false);
        newprofilewizardfreeswanpagecontent->LocalIDLabel->setDisabled(false);
    }
}

void NewProfileWizard::usePortToggled(bool)
{
    if (newprofilewizardvtunpagecontent->PortCheckbox->isChecked())
        newprofilewizardvtunpagecontent->PortSpinbox->setEnabled(true);
    else
        newprofilewizardvtunpagecontent->PortSpinbox->setEnabled(false);
}

void NewProfileWizard::useAuthenticationAlgorithmToggled(bool)
{
    if (newprofilewizardopenvpnauthpagecontent->UseAuthenticationAlgorithmCheckBox->isChecked())
        newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox ->setEnabled(true);
    else
        newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->setEnabled(false);
}

void NewProfileWizard::useRemoteNetworkToggled(bool)
{
    if (newprofilewizardnetworkcontent->UseRemoteNetworkCheckBox->isChecked())
        newprofilewizardnetworkcontent->RemoteNetworkGroupBox ->setEnabled(true);
    else
        newprofilewizardnetworkcontent->RemoteNetworkGroupBox->setEnabled(false);
}

void NewProfileWizard::useIkeToggled(bool)
{
    if (newprofilewizardfreeswanpagecontent->UseCustomIkeCheckBox->isChecked())
        newprofilewizardfreeswanpagecontent->IkeGroupBox->setEnabled(true);
    else
        newprofilewizardfreeswanpagecontent->IkeGroupBox->setEnabled(false);
}

void NewProfileWizard::useEspToogled(bool)
{
    if (newprofilewizardfreeswanpagecontent->UseCustomEspCheckBox->isChecked())
        newprofilewizardfreeswanpagecontent->EspGroupBox->setEnabled(true);
    else
        newprofilewizardfreeswanpagecontent->EspGroupBox->setEnabled(false);
}

void NewProfileWizard::remoteIDTypeToggled(const QString& text)
{
    if (text == "asn1dn") {
        newprofilewizardracoonpagecontent->RemoteIDLineEdit->setDisabled(true);
        newprofilewizardracoonpagecontent->RemoteIDLabel->setDisabled(true);
    } else {
        newprofilewizardracoonpagecontent->RemoteIDLineEdit->setDisabled(false);
        newprofilewizardracoonpagecontent->RemoteIDLabel->setDisabled(false);
    }
}

void NewProfileWizard::defaultRouteToggled(const QString& text)
{
    Q_UNUSED(text);

    if (newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentText() == i18n("Keep default route") ||
            newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentIndex() == 0) {
        KMessageBox::information(0,
                                 i18n("Additional network route is needed:"
                                      "\n\nYou have selected to keep the default route. "
                                      "You have to add additional network routes to your remote network. "
                                      "Otherwise you probably do not have access to it."),
                                 i18n("Route needed"));
    }
}

void NewProfileWizard::ikeGroupToggled(bool)
{
    if (newprofilewizardracoonpagecontent->IkeGroupCheckbox->isChecked())
        newprofilewizardracoonpagecontent->DHGroupComboBox->setEnabled(true);
    else
        newprofilewizardracoonpagecontent->DHGroupComboBox->setEnabled(false);
}

void NewProfileWizard::useXauthFreeswanToggled(bool)
{
    if (newprofilewizardfreeswanpagecontent->UseXauthCheckBox->isChecked()) {
        newprofilewizarduserpagecontent->setEnabled(true);
        newprofilewizardpskcontent->setEnabled(true);
        newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setEnabled(false);
        newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setEnabled(true);
        newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setCurrentItem("keyid");
    } else {
        newprofilewizarduserpagecontent->setEnabled(false);
        newprofilewizardpskcontent->setEnabled(false);
        newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setEnabled(true);
        newprofilewizardfreeswanpagecontent->LocalIDLineEdit->setEnabled(false);
        newprofilewizardfreeswanpagecontent->LocalIdTypeCombobox->setCurrentItem("asn1dn");
    }
}

void NewProfileWizard::useXauthRacoonToggled(bool)
{
    if (newprofilewizardracoonpagecontent->UseXauthCheckBox->isChecked()) {
        newprofilewizarduserpagecontent->setEnabled(true);
        newprofilewizardpskcontent->setEnabled(true);
        newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setEnabled(false);
        newprofilewizardracoonpagecontent->LocalIDLineEdit->setEnabled(true);
        newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setCurrentItem("keyid");
    } else {
        newprofilewizarduserpagecontent->setEnabled(false);
        newprofilewizardpskcontent->setEnabled(false);
        newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setEnabled(true);
        newprofilewizardracoonpagecontent->LocalIDLineEdit->setEnabled(false);
        newprofilewizardracoonpagecontent->LocalIdTypeCombobox->setCurrentItem("asn1dn");
    }
}

void NewProfileWizard::tunnelDeviceTypeChanged(const QString & string)
{
    if (profileData->getConnectionType() == VpnAccountData::openvpn || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        if (string.toLower() == "tun") {
            profilenetworkvirtualipoptionscontent->LabelRemoteVirtualIp->setText(i18n("Remote IP (virtual):"));
        }
        if (string.toLower() == "tap") {
            profilenetworkvirtualipoptionscontent->LabelRemoteVirtualIp->setText(i18n("Netmask for local IP address:"));
        }
    }
}

void NewProfileWizard::useDnsServerToggled(bool)
{
    if (newprofilewizardpptppagecontent->DnsServerCheckbox->isChecked())
        newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled(true);
    else
        newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled(false);
}

void NewProfileWizard::useSearchDomainInResolvConfToggled(bool)
{
    if (newprofilewizardpptppagecontent->UseSearchDomainInResolvConfCheckbox ->isChecked())
        newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->setEnabled(true);
    else
        newprofilewizardpptppagecontent->SearchDomainInResolvConfLineedit->setEnabled(false);
}
#endif
