/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "enterpassworddialog.h"
#include <qdialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qcheckbox.h>
#include "enterpassworddialog.moc"

EnterUsernamePasswordDialog::EnterUsernamePasswordDialog(QWidget *parent, const QString& caption,bool askForGrouppassword, bool askForUsername) : KDialogBase( parent, "Enter_account_data", true, caption,
		KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{

	this->askForGrouppassword = askForGrouppassword;
	this->askForUsername = askForUsername;
	
	main = new EnterUsernamePasswordDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());
	
	if (!askForGrouppassword)
	{
		main->PSKLineEdit->hide();
		main->LabelGroupPassword->hide();
	}

	if (!askForUsername)
	{
		main->UsernameEdit->hide();
		main->LabelUsername->hide();
	}

	if (!askForGrouppassword)
		main->SavePskCheckBox->hide();
	if (!askForUsername)
		main->SaveUsernameCheckBox->hide();

	main->textLabel2->setText( QString("<b><font size=\"+1\">"+i18n( "Enter account data:")+"</b></font>" ));
}

EnterUsernamePasswordDialog::~ EnterUsernamePasswordDialog()
{
	delete main;
}


void EnterUsernamePasswordDialog::accept()
{
	bool ok=true;

	QString msg="";
	if (askForGrouppassword){
		if( main->PSKLineEdit->text().isEmpty())
			msg+="\n- "+i18n("PSK");
	}

	if (askForUsername){
		if(main->UsernameEdit->text().isEmpty())
			msg+="\n- "+i18n("Username");

		if (main->PasswordEdit->text().isEmpty())
			msg+="\n- "+i18n("Password");
	}
	if (!msg.isEmpty())
	{
		KMessageBox::sorry( 0, i18n( "All fields must be filled in. Please check:\n%1").arg(msg));
		ok=false;
	}
	
	if (ok)
		QDialog::accept();


}
