/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __ToolInfo_H__
#define __ToolInfo_H__

#include <qstring.h>
#include <qprocess.h>
#include <qobject.h>
#include <qstringlist.h>

class ToolInfo : public QObject
{
	Q_OBJECT
public:
	/**
	 *  Information about a helper program
	 * @param GlobalConfig Pointer to global config
	 * @param Name Name of the tool
	 * @return None
	 */
	ToolInfo(const QString &Name);

private:
	QProcess *CollectToolInfoProcess;
	QProcess *CollectOpenvpnCapabilitiesProcess;
	QStringList SearchPathList;
	bool collectRunning;
	bool collectOpenvpnCapabilitiesRunning;

public:
	QString Name; //< Name of the tool
	QString Version; //< Version number of the tool
	QString PathToExec; //< Path to executable
	QString Capabilities;
	QString TryPath_first; //< try that path first before list
	bool collectToolInfo(); //< Collects information of the tool
	bool programsInPath;
	bool found;
	void addSearchPath(const QString &path); //< Adds a path for searching
	void removeSearchPath(const QString &path); //< Removes a path for searching
	void getOpenvpnCapabilities();


private slots:
	void readStdOutCollectToolInfo();
	void readStdErrCollectToolInfo();
	void readStdOutCollectOpenvpnCapabilies();
	void readStdErrCollectOpenvpnCapabilies();
	void processFinished();

};


#endif
