/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*   contains some code from openvpn-kde-dialogs.pl which is     *
*   written by  Alon Bar-Lev <alon.barlev@gmail.com>                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include "openvpnmanagementhandler.h"
#include <qregexp.h>
#include <qtextstream.h>
#include <kpassdlg.h>
#include <klocale.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <kinputdialog.h>
#include "kvpncconfig.h"
#include "utils.h"
#include "enterxauthinteractivepasscodedialog.h"
//END INCLUDES

OpenvpnManagementHandler::OpenvpnManagementHandler( QObject *, KVpncConfig *GlobalConfig )
{
	this->GlobalConfig = GlobalConfig;
	fInHold = false;
	connectedToManagementPort=false;
	errormsg="";

	if ( GlobalConfig->KvpncDebugLevel > 2 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: start", GlobalConfig->debug );

}

OpenvpnManagementHandler::~OpenvpnManagementHandler()
{}

void OpenvpnManagementHandler::closeConnection()
{
	disconnect( socket, SIGNAL( connected() ), this, SLOT( socketConnected() ) );
	disconnect( socket, SIGNAL( connectionClosed() ), this, SLOT( socketConnectionClosed() ) );
	disconnect( socket, SIGNAL( readyRead() ), this, SLOT( socketReadyRead() ) );
	disconnect( socket, SIGNAL( error( int ) ), this, SLOT( socketError( int ) ) );
	socket->clearPendingData();
	socket->close();
	if ( socket->state() == QSocket::Closing )
	{
		// We have a delayed close.
		connect( socket, SIGNAL( delayedCloseFinished() ),
		         SLOT( socketClosed() ) );
	}
	else
	{
		// The socket is closed.
		socketClosed();
	}
}

void OpenvpnManagementHandler::socketConnectionClosed()
{


	if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Disconnected to the OpenVPN manage port (%1)." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );
}

void OpenvpnManagementHandler::socketClosed()
{
		if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Socket to the OpenVPN manage port (%1) closed." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );
// 	emit terminate_openvpn();	
}

void OpenvpnManagementHandler::socketConnected()
{

// 	KMessageBox::error ( 0, QString("bar"), QString("foo") );
	connectedToManagementPort=true;

	if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Connected to the OpenVPN manage port (%1)." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );

}

void OpenvpnManagementHandler::socketError( int e )
{
	//         infoText->append( tr("Error number %1 occurred\n").arg(e) );
	if ( e != 0 )
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + QString().setNum( e ) , GlobalConfig->error );
}

void OpenvpnManagementHandler::sendToServer( QString cmd )
{
	// write to the server
	QTextStream os( socket );
	os << cmd << "\n";
}

void OpenvpnManagementHandler::socketReadyRead()
{
	bool abort=false;
	while ( !abort && socket->canReadLine() )
	{
		if ( socket->canReadLine() )
		{
			QString line = socket->readLine();

			// 	{
			// 			QCString s;
			// 					s.resize( socket->bytesAvailable() + 1 );
			// 					socket->readBlock( s.data(), socket->bytesAvailable() );
			// 					QString line( s );
			// 					{

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler raw: " + line, GlobalConfig->debug );

			if ( line.find( "NOOP", 0, FALSE ) > -1 )
			{
				// NOOP
			}
			// 		else if ( line.find( ">HOLD:", 0, FALSE ) > -1 ) {
			//
			// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message." ).arg("'hold'"), GlobalConfig->debug );
			//
			// 			fInHold = true;
			// 			int ret = 0;
			// 			do {
			// 				ret = KMessageBox::questionYesNo ( 0, i18n( "Release hold?" ), i18n( "OpenVPN" ) );
			// 			} while ( ret != 0 );
			//
			// 			sendToServer( "hold release\n" );
			//
			// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "hold release sent." ), GlobalConfig->debug );
			//
			// 			socket->close();
			// 			fInHold = false;
			// 		}

			else if ( line.find( "> NEED - OK:", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("'need ok'"), GlobalConfig->debug );

				QString req = line.section( QRegExp( ".*'(.*)'. * MSG:( .* )" ), 0, 0 ); // $1;
				QString msg = line.section( QRegExp( ".*'(.*)'. * MSG:( .* )" ), 1, 1 ); // $2;

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( QString("OpenvpnManagementHandler: req: ")+req+QString(", msg: ")+msg , GlobalConfig->debug );

				//TODO: look for possible messages, msg2 is the translatable msg
				QString msg2 = msg;

				int ret = KMessageBox::questionYesNo ( 0, msg2, i18n( "OpenVPN" ) );


				if ( ret == 0 )
				{

					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry( QString("OpenvpnManagementHandler: ") + QString("'needok': ok") , GlobalConfig->debug );

					sendToServer( "needok \"" + req + "\" ok\n" );
				}
				else
				{

					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry( QString("OpenvpnManagementHandler: ") +QString( "'needok': cancel") , GlobalConfig->debug );

					sendToServer( "needok \"" + req + "\" cancel\n" );
				}
				socket->close();
				// if ( line.find( " >PASSWORD:", 0, FALSE ) > -1 ) {
				//
				// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
				// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("'password'"), GlobalConfig->debug );
				//
				// 			QString req = line.section( QRegExp( ".*'(.*)'.*" ), 0, 0 ); // $1;
				// 			QCString password;
				// 			QString pass = "";
				// 			int result = KPasswordDialog::getPassword( password, QString( req + i18n( " password:" ) ) );
				// 			QTextStream os( socket );
				// 			//			os.setEncoding( QTextStream::UnicodeUTF8 );
				// 			if ( result == KPasswordDialog::Accepted ) {
				// 				if ( GlobalConfig->KvpncDebugLevel > 2 )
				// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "password got from user" ), GlobalConfig->debug );
				// 				pass = QString( password );
				//
				// 				pass = pass.remove( '\r' );
				// 				pass = pass.remove( '\n' );
				// 			} else {
				// 				pass = "";
				// 			}
				// 			sendToServer( "password \"" + req + "\" \"" + pass + "\"\n" );
			}

			else if ( line.find( "PASSWORD:Need 'Auth' username/password", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("'need username/password'"), GlobalConfig->debug );

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send username..." ), GlobalConfig->debug );

				if ( !GlobalConfig->currentProfile->getUserName().isEmpty()       /* && !GlobalConfig->currentProfile->getDontSaveUsername() */ )
				{
					if ( GlobalConfig->KvpncDebugLevel > 2 )
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: " + GlobalConfig->currentProfile->getUserName(), GlobalConfig->debug );

					sendToServer( "username Auth " + GlobalConfig->currentProfile->getUserName() + "\n" );
				}
				else
				{
					if ( GlobalConfig->TmpUsername.isEmpty() )
					{
						bool ok = false;
						QString username = KInputDialog::getText ( i18n( "User name" ), i18n( "Enter username:" ), "", &ok );
						QTextStream os( socket );
						os.setEncoding( QTextStream::UnicodeUTF8 );
						if ( ok == true && !username.isEmpty() )
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "username got from user" ), GlobalConfig->debug );
							GlobalConfig->TmpUsername = username;

							if ( GlobalConfig->KvpncDebugLevel > 5 )
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: " + GlobalConfig->TmpUsername, GlobalConfig->debug );

							sendToServer( "username Auth " + GlobalConfig->TmpUsername + "\n" );
						}
						else
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username dialog canceled and username empty, stop.", GlobalConfig->info );
							abort = true;
						}
					}
					else
					{
						if ( GlobalConfig->KvpncDebugLevel > 5 )
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: username: " + GlobalConfig->TmpUsername, GlobalConfig->debug );
						sendToServer( "username Auth " + GlobalConfig->TmpUsername + "\n" );
					}
				}
			}

			else if ( line.find( "SUCCESS: 'Auth' username entered", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("SUCCESS: 'Auth' username entered"), GlobalConfig->debug );

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send password..." ), GlobalConfig->debug );

				if ( !GlobalConfig->currentProfile->getUserPassword().isEmpty()       /* && GlobalConfig->currentProfile->getSaveUserPassword()  */ )
				{
					// 				if ( GlobalConfig->KvpncDebugLevel > 5 )
					// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: " +GlobalConfig->currentProfile->getUserPassword(), GlobalConfig->debug );

					sendToServer( "password Auth " + GlobalConfig->currentProfile->getUserPassword() + "\n" );
				}
				else
				{
					if ( GlobalConfig->TmpPassword.isEmpty() )
					{
						QCString password;
						QString pass = "";
						int result = KPasswordDialog::getPassword( password, QString( i18n( " password:" ) ) );
						QTextStream os( socket );
						//			os.setEncoding( QTextStream::UnicodeUTF8 );
						if ( result == KPasswordDialog::Accepted )
						{
							if ( GlobalConfig->KvpncDebugLevel > 2 )
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "password got from user" ), GlobalConfig->debug );
							GlobalConfig->TmpPassword = QString( password );


							// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
							// 							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: "+GlobalConfig->TmpPassword, GlobalConfig->debug );

							sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\n" );
						}
						else
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
							abort = true;
						}
					}
					else
					{
						// 						if ( GlobalConfig->KvpncDebugLevel > 5 )
						// 							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: "+GlobalConfig->TmpPassword, GlobalConfig->debug );
						sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\n" );

					}
				}
			}

			// 		else if ( line.find( "SUCCESS: 'Auth' username entered", 0, FALSE ) > -1 ) {
			//
			// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message, 2. step" ).arg("'need username/password'"), GlobalConfig->debug );
			//
			// 			if ( GlobalConfig->KvpncDebugLevel > 2 )
			// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send password..." ), GlobalConfig->debug );
			//
			// 			if (  GlobalConfig->currentProfile->getUserPassword().isEmpty() )
			// 				sendToServer( "password Auth " + GlobalConfig->TmpPassword + "\"\n" );
			// 			else
			// 				sendToServer( "password Auth " + GlobalConfig->currentProfile->getUserPassword() + "\"\n" );
			//
			// 		}

			else if ( line.find( "PASSWORD:Need 'HTTP Proxy' username/password", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("'HTTP Proxy password'"), GlobalConfig->debug );

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send HTTP Proxy username..." ), GlobalConfig->debug );

				if ( !GlobalConfig->currentProfile->getHttpProxyUser().isEmpty() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 5 )
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: HTTP proxy user: " + GlobalConfig->currentProfile->getHttpProxyUser() , GlobalConfig->debug );

					sendToServer( "username  \"HTTP Proxy\"" + GlobalConfig->currentProfile->getHttpProxyUser() + "\n" );
				}
			}

			else if ( line.find( "SUCCESS: 'HTTP Proxy' username entered", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("SUCCESS: 'HTTP Proxy' username entered"), GlobalConfig->debug );

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send HTTP Proxy password..." ), GlobalConfig->debug );

				if ( !GlobalConfig->currentProfile->getHttpProxyPass().isEmpty() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 5 )
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: HTTP proxy auth password: " + GlobalConfig->currentProfile->getHttpProxyPass(), GlobalConfig->debug );
					sendToServer( "password  \"HTTP Proxy\"" + GlobalConfig->currentProfile->getHttpProxyPass() + "\n" );
				}
				else
				{
					if ( GlobalConfig->TmpHttpProxyPassword.isEmpty() )
					{
						QCString password;
						QString pass = "";

						QTextStream os( socket );
						os.setEncoding( QTextStream::UnicodeUTF8 );

						GlobalConfig->TmpHttpProxyPassword = "";
						EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter HTTP proxy auth password" ) );
						dlg.main->DescriptionLabel->setText( i18n( "Enter HTTP proxy auth password:" ) );
						dlg.main->LabelPassword->setText( i18n( "HTTP proxy auth password:" ) );
						dlg.main->SavePasswordCheckBox->setText( i18n( "Save HTTP proxy auth password" ) );
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "HTTP proxy auth password requested...\n" ), GlobalConfig->debug );
						if ( dlg.exec() )
						{

							pass = dlg.main->PasswordEdit->text();
							if ( !pass.isEmpty() )
							{

								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "HTTP proxy auth password got from user" ), GlobalConfig->debug );

								if ( dlg.main->SavePasswordCheckBox->isChecked() )
								{
									// 								GlobalConfig->currentProfile->setSavePrivateKeyPassword(true);
									GlobalConfig->currentProfile->setHttpProxyPass ( QString( pass ) );
								}

								GlobalConfig->TmpHttpProxyPassword = QString( pass );

								if ( GlobalConfig->KvpncDebugLevel > 5 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: HTTP proxy auth password: " + GlobalConfig->TmpHttpProxyPassword, GlobalConfig->debug );

								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send HTTP proxy auth password..." ), GlobalConfig->debug );

								sendToServer( "password  \"HTTP Proxy\"" + GlobalConfig->TmpHttpProxyPassword + "\n" );
							}
							else
							{
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: HTTP proxy auth password empty, stop.", GlobalConfig->error );
								abort = true;
							}
						}
						else
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and HTTP proxy auth password empty, stop.", GlobalConfig->info );
							abort = true;
						}
					}
					else
					{
						sendToServer( "password  \"HTTP Proxy\"" + GlobalConfig->TmpHttpProxyPassword + "\n" );
						if ( GlobalConfig->KvpncDebugLevel > 5 )
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: HTTP proxy auth password: " + GlobalConfig->TmpHttpProxyPassword, GlobalConfig->debug );
							GlobalConfig->appendLogEntry( QString( "OpenvpnManagementHandler: HTTP proxy auth password string: " ) + QString( "password  \"HTTP Proxy\" " + GlobalConfig->TmpHttpProxyPassword + "\n" ), GlobalConfig->debug );
						}
					}
				}
			}

			else if ( line.find( "PASSWORD:Need 'Private Key' password", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("'private key password'"), GlobalConfig->debug );

				if ( !GlobalConfig->currentProfile->getPrivateKeyPass().isEmpty() )
				{
					// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
					// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );

					sendToServer( "password  \"Private Key\" " + GlobalConfig->currentProfile->getPrivateKeyPass() + "\n" );
				}
				else
				{
					if ( ( Utils(GlobalConfig).getNeedsPassphrase(GlobalConfig->TmpPrivateKeyPass) && GlobalConfig->TmpPrivateKeyPass.isEmpty() ) || GlobalConfig->currentProfile->getPrivateKeyPass().isEmpty() )
					{
						GlobalConfig->TmpPassword = "";
						QCString password;
						QString pass = "";

						QTextStream os( socket );
						//			os.setEncoding( QTextStream::UnicodeUTF8 );

						GlobalConfig->TmpPrivateKeyPass = "";
						EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter private key password" ) );
						dlg.main->DescriptionLabel->setText( i18n( "Enter private key password to unlock private key:" ) );
						dlg.main->LabelPassword->setText( i18n( "Private key password:" ) );
						dlg.main->SavePasswordCheckBox->setText( i18n( "Save private key password" ) );
						dlg.resize(600,200);
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "Password for private key requested...\n" ), GlobalConfig->debug );
						if ( dlg.exec() )
						{

							pass = dlg.main->PasswordEdit->text();
							if ( !pass.isEmpty() )
							{

								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "private key password got from user" ), GlobalConfig->debug );

								if ( dlg.main->SavePasswordCheckBox->isChecked() )
								{
									GlobalConfig->currentProfile->setSavePrivateKeyPassword( true );
									GlobalConfig->currentProfile->setPrivateKeyPass( QString( pass ) );
								}

								GlobalConfig->TmpPrivateKeyPass = QString( pass );

								// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
								// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );

								if ( GlobalConfig->KvpncDebugLevel > 2 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );

								sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
							}
							else
							{
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password empty, stop.", GlobalConfig->error );
								abort = true;
							}
						}
						else
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
							abort = true;
						}
					}
					else
					{
						sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
						// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
						// 					{
						// 					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );
						// 					GlobalConfig->appendLogEntry( QString("OpenvpnManagementHandler: private key password string: ") + QString("password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n"),GlobalConfig->debug);
						// 					}
					}
				}
			}

			else if ( line.find( "PASSWORD:Verification Failed: 'Private Key'", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "wrong private key password" ), GlobalConfig->debug );

				GlobalConfig->TmpPassword = "";
				QCString password;
				QString pass = "";

				QTextStream os( socket );
				//			os.setEncoding( QTextStream::UnicodeUTF8 );

				GlobalConfig->TmpPrivateKeyPass = "";
				EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter private key password" ) );
				dlg.main->DescriptionLabel->setText( i18n( "Enter private key password to unlock private key:" ) );
				dlg.main->LabelPassword->setText( i18n( "Private key password:" ) );
				dlg.main->SavePasswordCheckBox->setText( i18n( "Save private key password" ) );
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "Password for private key requested...\n" ), GlobalConfig->debug );
				if ( dlg.exec() )
				{
					pass = dlg.main->PasswordEdit->text();

					if ( !pass.isEmpty() )
					{

						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "private key password got from user" ), GlobalConfig->debug );

						if ( dlg.main->SavePasswordCheckBox->isChecked() )
						{
							GlobalConfig->currentProfile->setSavePrivateKeyPassword( true );
							GlobalConfig->currentProfile->setPrivateKeyPass( QString( pass ) );
						}

						GlobalConfig->TmpPrivateKeyPass = QString( pass );

						// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
						// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: private key password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );

						if ( GlobalConfig->KvpncDebugLevel > 2 )
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send private key password..." ), GlobalConfig->debug );

						sendToServer( "password  \"Private Key\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
					}
					else
					{
						GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password empty, stop.", GlobalConfig->error );
						abort = true;
					}
				}
				else
				{
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
					abort = true;
				}
			}

			else if ( line.find( "FATAL:script failed: shell command exited with error status", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: script exited with wrong status" , GlobalConfig->error );

				 abort = true;
			}

			else if ( line.find( "PASSWORD:Verification Failed: 'Auth'", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password verification failed!" , GlobalConfig->error );

				GlobalConfig->appendLogEntry( i18n( "Authentication failed (%1)!" ).arg( i18n( "user password" ) ) , GlobalConfig->error );

				abort = true;
			}

			else if ( line.find( "FATAL:Cannot load CA certificate file", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( i18n("OpenvpnManagementHandler: CA certifcate file could not be loaded! Please check your CA certificate file.") , GlobalConfig->error );

				GlobalConfig->appendLogEntry( i18n( "Certificate load failed (%1)!" ).arg( i18n( "CA certificate" ) ) , GlobalConfig->error );

				abort = true;
			}

			else if ( line.find( "FATAL:Message hash algorithm", 0, FALSE ) > -1 && line.find( "not found", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( i18n("OpenvpnManagementHandler: Hash algorithm %1 could not found! Please check your OpenVPN settings.").arg(line.section(' ',3,3).remove('\'')) , GlobalConfig->error );

				GlobalConfig->appendLogEntry( i18n( "Hash algorithm not found (%1)!" ).arg(line.section(' ',3,3).remove('\'') ) , GlobalConfig->error );

				abort = true;
			}

			else if ( line.find( "PASSWORD:Need 'eToken token' password", 0, FALSE ) > -1)
			{
						GlobalConfig->TmpPassword = "";
						QCString password;
						QString pass = "";

						QTextStream os( socket );
						//			os.setEncoding( QTextStream::UnicodeUTF8 );

						GlobalConfig->TmpPrivateKeyPass = "";
						EnterXauthInteractivePasscodeDialog dlg( 0, i18n( "Enter token pin" ) );
						dlg.main->DescriptionLabel->setText( i18n( "Enter eToken pin for unlocking token \"%1\":" ).arg(GlobalConfig->currentProfile->getPkcs11Id()) );
						dlg.main->LabelPassword->setText( i18n( "eToken pin:" ) );
						dlg.main->SavePasswordCheckBox->hide();
						dlg.main->adjustSize();
						dlg.adjustSize();
						if ( GlobalConfig->KvpncDebugLevel > 1 )
							GlobalConfig->appendLogEntry ( "[openvpn] " + i18n( "eToken pin for unlocking token requested...\n" ), GlobalConfig->debug );
						if ( dlg.exec() )
						{

							pass = dlg.main->PasswordEdit->text();
							if ( !pass.isEmpty() )
							{

								if ( GlobalConfig->KvpncDebugLevel > 1 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "token password got from user" ), GlobalConfig->debug );


								GlobalConfig->TmpPrivateKeyPass = QString( pass );

								// 												if ( GlobalConfig->KvpncDebugLevel > 5 )
								// 				GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: token password: " + GlobalConfig->TmpPrivateKeyPass, GlobalConfig->debug );

								if ( GlobalConfig->KvpncDebugLevel > 1 )
									GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Send token password..." ), GlobalConfig->debug );

								sendToServer( "password  \"eToken token\" " + GlobalConfig->TmpPrivateKeyPass + "\n" );
							}
							else
							{
								GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: token password empty, stop.", GlobalConfig->error );
								abort = true;
							}
						}
						else
						{
							GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: password dialog canceled and password empty, stop.", GlobalConfig->info );
							abort = true;
						}
			}

			else if ( line.find( "SUCCESS: 'eToken token' password entered, but not yet verified", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("SUCCESS for 'eToken token' password"), GlobalConfig->debug );
			}

			else if ( line.find( "Need 'token-insertion-request'", 0, FALSE ) > -1 )
			{
// 				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("token-insertion-request"), GlobalConfig->debug );
				KMessageBox::error ( 0, i18n("Token \"%1\" is not inserted!").arg(GlobalConfig->currentProfile->getPkcs11Id()), i18n("Token missing") );
				abort = true;
			}
			else if ( line.find( "SUCCESS: 'Private Key' password entered, but not yet verified", 0, FALSE ) > -1 )
			{

				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got %1 message" ).arg("SUCCESS for 'Private Key' password"), GlobalConfig->debug );
			}
			else
			{
				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "got other management message: %1" ).arg(line), GlobalConfig->debug );
			}
		}
		if (abort)
		{
			disconnect( socket, SIGNAL( connected() ), this, SLOT( socketConnected() ) );
			disconnect( socket, SIGNAL( connectionClosed() ), this, SLOT( socketConnectionClosed() ) );
			disconnect( socket, SIGNAL( readyRead() ), this, SLOT( socketReadyRead() ) );
			disconnect( socket, SIGNAL( error( int ) ), this, SLOT( socketError( int ) ) );
			socket->close();
        if ( socket->state() == QSocket::Closing ) {
            // We have a delayed close.
            connect( socket, SIGNAL(delayedCloseFinished()),
                    SLOT(socketClosed()) );
        } else {
            // The socket is closed.
            socketClosed();
				emit terminate_openvpn();	
        }
		}
	}
}

bool OpenvpnManagementHandler::isConnectedToManagementPort()
{
	return connectedToManagementPort;
}

bool OpenvpnManagementHandler::doConnect()
{


	socket = new QSocket( this );
	connect( socket, SIGNAL( connected() ), this, SLOT( socketConnected() ) );
	connect( socket, SIGNAL( hostFound() ), this, SLOT( hostFound() ) );
	connect( socket, SIGNAL( connectionClosed() ), this, SLOT( socketConnectionClosed() ) );
	connect( socket, SIGNAL( readyRead() ), this, SLOT( socketReadyRead() ) );
	connect( socket, SIGNAL( error( int ) ), this, SLOT( socketError( int ) ) );

	if ( GlobalConfig->KvpncDebugLevel > 1 )
	{
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Connecting to the OpenVPN manage port (%1)..." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );
	}

	socket->connectToHost( "127.0.0.1", GlobalConfig->OpenvpnManagementPort );

// 	for (int i=1;i <= 10;i++)
// 	{
// 		sleep(1);
// 		if (!connectedToManagementPort)
// 		{
// 		if ( GlobalConfig->KvpncDebugLevel > 1 )
// 			GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Connecting to the OpenVPN manage port (%1)..." ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug);
// 		}
// 		else
// 			return true;
// 	}

// 	return false;
	return true;
}

void OpenvpnManagementHandler::hostFound()
{
// 	KMessageBox::error ( 0, QString("bar"), QString("foo") );
	if ( GlobalConfig->KvpncDebugLevel > 1 )
	{
		GlobalConfig->appendLogEntry( "OpenvpnManagementHandler: " + i18n( "Connecting to the OpenVPN manage port (%1)... host found" ).arg( QString().setNum( GlobalConfig->OpenvpnManagementPort ) ), GlobalConfig->debug );
	}
}
