// =============================================================================
//
//      --- kvi_messagebox_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <kmessagebox.h>

#include "kvi_messagebox_kde.h"

KviMessageBox::KviMessageBox(
	const QString &caption, const QString &text, Icon icon, int button0, int button1, int button2,
	QWidget *parent, const char *name, bool modal, WFlags f)
	: QMessageBox(caption, text, icon, button0, button1, button2, parent, name, modal, f)
{
	// Nothing here
}

KviMessageBox::~KviMessageBox()
{
	// Nothing here
}

void KviMessageBox::error(const QString &text, const QString &caption, QWidget *parent)
{
	KMessageBox::error(parent, text, caption);
}

void KviMessageBox::information(const QString &text, const QString &caption, QWidget *parent)
{
	KMessageBox::information(parent, text, caption);
}

void KviMessageBox::sorry(const QString &text, const QString &caption, QWidget *parent)
{
	KMessageBox::sorry(parent, text, caption);
}

int KviMessageBox::questionYesNo(const QString &text, const QString &caption, QWidget *parent)
{
	return KMessageBox::questionYesNo(parent, text, caption);
}

int KviMessageBox::warningYesNo(const QString &text, const QString &caption, QWidget *parent)
{
	return KMessageBox::warningYesNo(parent, text, caption);
}

int KviMessageBox::warningYesNoCancel(const QString &text, const QString &caption, QWidget *parent)
{
	return KMessageBox::warningYesNoCancel(parent, text, caption);
}

#include "m_kvi_messagebox_kde.moc"
