// =============================================================================
//
//      --- kvi_mainwindow_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_mainwindow_kde.h"

KviMainWindow::KviMainWindow(QWidget *parent, const char *name)
	: KMainWindow(parent, name)
{
	// Nothing here
}

KviMainWindow::~KviMainWindow()
{
	// Nothing here
}

void KviMainWindow::showDockWindow(QDockWindow *dockWindow, Qt::Dock edge, bool nl, int index, int extraOffset)
{
	dockWindow->show();
	moveDockWindow(dockWindow, edge, nl, index, extraOffset);
}

void KviMainWindow::showDockWindow(QDockWindow *dockWindow)
{
	dockWindow->show();
}

void KviMainWindow::hideDockWindow(QDockWindow *dockWindow)
{
	dockWindow->hide();
}

QPtrListIterator<KviToolBar> KviMainWindow::toolBarIterator()
{
	QPtrList<KviToolBar> list;
	QPtrListIterator<KToolBar> iter(KMainWindow::toolBarIterator());
	for( ; iter.current(); ++iter )
		list.append((KviToolBar *) iter.current());

	return QPtrListIterator<KviToolBar> (list);
}

#include "m_kvi_mainwindow_kde.moc"
