//
//   File : optw_ircview.cpp
//   Creation date : Sat Aug 11 2001 03:29:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_ircview.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviIrcViewLookOptionsWidget::KviIrcViewLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewlook_options_widget")
{
	createLayout(4,1);

	addFontSelector(0,0,0,0,__tr2qs("Font:"),KviOption_fontIrcView);
	addColorSelector(0,1,0,1,__tr2qs("Background color:"),KviOption_colorIrcViewBackground);
	addPixmapSelector(0,2,0,2,__tr2qs("Background image:"),KviOption_pixmapIrcViewBackground);
	addColorSelector(0,3,0,3,__tr2qs("Mark Line:"),KviOption_colorIrcViewMarkLine);

	layout()->setRowStretch(2,1);
}

KviIrcViewLookOptionsWidget::~KviIrcViewLookOptionsWidget()
{
}



KviIrcViewFeaturesOptionsWidget::KviIrcViewFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewfeatures_options_widget")
{
	createLayout(10,1);

	addBoolSelector(0,0,0,0,__tr2qs("Show message icons"),KviOption_boolIrcViewShowImages);
	addBoolSelector(0,1,0,1,__tr2qs("Draw some emoticons (smileys) as pictures"),KviOption_boolDrawEmoticons);
	KviBoolSelector * b1 = addBoolSelector(0,2,0,2,__tr2qs("Show timestamp"),KviOption_boolIrcViewTimestamp);
	KviBoolSelector * b2 = addBoolSelector(0,3,0,3,__tr2qs("Use UTC time for timestamp"),KviOption_boolIrcViewTimestampUTC,KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp));
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	addBoolSelector(0,4,0,4,__tr2qs("Enable URL highlighting"),KviOption_boolIrcViewUrlHighlighting);
	addBoolSelector(0,5,0,5,__tr2qs("Use line wrap margin"),KviOption_boolIrcViewWrapMargin);
	KviUIntSelector * s = addUIntSelector(0,6,0,6,__tr2qs("Maximum buffer size:"),KviOption_uintIrcViewMaxBufferSize,32,32767,2048);
	s->setSuffix(__tr2qs(" lines"));
	s = addUIntSelector(0,7,0,7,__tr2qs("Link tooltip show delay:"),KviOption_uintIrcViewToolTipTimeoutInMsec,256,10000,1800);
	s->setSuffix(__tr2qs(" msec"));
	s = addUIntSelector(0,8,0,8,__tr2qs("Link tooltip hide delay:"),KviOption_uintIrcViewToolTipHideTimeoutInMsec,256,10000,12000);
	s->setSuffix(__tr2qs(" msec"));
	addBoolSelector(0,9,0,9,__tr2qs("Track last read text line"),KviOption_boolTrackLastReadTextViewLine);
	addRowSpacer(0,10,0,10);
}

KviIrcViewFeaturesOptionsWidget::~KviIrcViewFeaturesOptionsWidget()
{
}

#include "m_optw_ircview.moc"
