#ifndef	_CLASS_WINDOW_H_
#define	_CLASS_WINDOW_H_
//
//   File : class_window.h
//   Creation date : Tue Nov 26 21:37:48 CEST 2002 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "class_widget.h"
#include "kvi_window.h"

class KviScriptWindowWindow : public KviWindow
{
	Q_OBJECT
public:
	KviScriptWindowWindow(KviFrame * pParent,const QString &szName);
	~KviScriptWindowWindow();
protected:
	KviScriptWidgetObject * m_pCentralWidgetObject;
	QWidget * m_pCentralWidget;
public:
	void setCentralWidget(KviScriptWidgetObject *o,QWidget * w);
	void setCaptionString(const QString &s){ setFixedCaption(s); };
	virtual void resizeEvent(QResizeEvent *e);
protected slots:
	void centralWidgetObjectDestroyed();
	void centralWidgetDestroyed();
};


class KviScriptWindowObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptWindowObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptWindowObject();

	static void registerSelf();
	static void unregisterSelf();
protected:
	QWidget * m_pCentralWidget;
protected:
	virtual bool init(KviCommand *);

	bool functionSetIcon(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCentralWidget(KviCommand *,KviParameterList *,KviStr &);
	bool functionSetCaption(KviCommand *,KviParameterList *,KviStr &);
};

#endif	// !_CLASS_WINDOW_H_
