//mdm:
//   File : class_tabwidget.cpp
//   Creation date : Fri Feb 11 10:21:48 CEST 2005
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
// 
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "class_tabwidget.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

/*
	@doc:	tabwidget
	@keyterms:
		tabwidget object class,
	@title:
		tabwidget class
	@type:
		class
	@short:
		Provides a Tab Widget.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		The tabwidget class provides a stack of tabbed widgets.[br]
		Each tab is associated with a different widget (called a `page').[br]
		Only the current tab's page is shown in the page area; all the others tabs pages are hidden.[br]
		The user can show a different page by clicking on its tab.[br]
	@functions:
		!fn: $addTab(<name>,<textlabel>,[<icon>])
		Adds another page to the tab view with the text label and optional icon.
		!fn: $insertTab(<name>,<texlabel>,<number index>)
		Inserts another tab and page to the tab view with name and label-text specified.[br]
		If index is not specified, the tab is simply appended.[br]
		Otherwise the new tab is inserted at the specified position.
		!fn: $setTabToolTip(<tabname>,<tooltip>)
		Sets the tab tool tip for the tab-name to <tooltip>.
		!fn: $removeTabToolTip(<tabname>)
		Removes the tab tool tip for the tab. If the page does not have a tip, nothing happens.
		!fn: $setTabLabel(<tabname>, <label>)
		Sets the tab label for <tabname>  to label.
		!fn: $changeTab(<tabname>,<tablabel>,[<icon>])
		Defines a new label, and optional icon, for the tab .
		!fn: $setCurrentPage(<int>)
		Sets the index position of the current tab page to <int>.
		!fn: $currentPageIndex()
		Returns the current page index.
		!fn: $label(<index>)
		Retunrs the label to the <index>.
		!fn: $currentTabLabel()
		Returns the label of the current tab.
		!fn: $setMargin(<number int>)
		Sets the margin in this tab widget to <number int>.
		!fn: $margin()
		Returns the margin in this tab widget.
		!fn: $removePage(<tabname>)
		Remove the page with <tabname>. 
		!fn: $setTabPosition()
		Sets TabPosition. Valid parameters are : Top, Bottom.
		!fn: $count()
		This property holds the number of tabs in the tab bar.
		!fn: $currentChangedEvent()
		This function is invoched when the current tab was changed.[br]
		The default implementation emits the [classfnc]$currentChange[/classfnc]() signal.[br]
		[br]
		|--EXAMPLE:[br]
		|-Start:[br]
		#Let's start.[br]
		#first we'll create the main tabwidget.[br]
		%Tabwidget=$new(tabwidget)[br]
		%Tabwidget->$setToolTip("Example of TabWidget class")[br]
		%Tabwidget->$setMargin(30)[br]
		%Tabwidget->$setTabPosition(Top)[br]
		#Now we'll create the new widgets and put they in to the main tabwidget.[br]
		%firsttab=$new(widget,%Tabwidget)[br]
		%secondtab=$new(widget,%Tabwidget)[br]
		#Now we'll create the item to put in to tab's pages.[br]
		%layoutfirsttab=$new(layout,%firsttab)[br]
		%labelbt=$new(label,%firsttab)[br]
		%labelbt->$settext(Botton Tab)[br]
		%labeltt=$new(label,%firsttab)[br]
		%labeltt->$settext(Top Tab)[br]
		%buttontb=$new(button,%firsttab)[br]
		%buttontb->$settext("To &Botton")[br]
		%buttontt=$new(button,%firsttab)[br]
		%buttontt->$settext("To &Top")[br]
		#Now we'll give a layout to all items.[br]
		%layoutfirsttab->$addwidget(%labelbt,0,0)[br]
		%layoutfirsttab->$addwidget(%labeltt,0,1)[br]
		%layoutfirsttab->$addwidget(%buttontb,1,0)[br]
		%layoutfirsttab->$addwidget(%buttontt,1,1)[br]
		#Add the page to the main tab.[br]
		%Tabwidget->$addTab(%firsttab,Top&Button,33)[br]
		#Implementing the action to do when the user click the buttons.[br]
		privateimpl(%buttontb,mousepressevent)[br]
		{[br]
			%Tabwidget->$setTabPosition(Bottom)[br]
		}[br]
		privateimpl(%buttontt,mousepressevent)[br]
		{[br]
			%Tabwidget->$setTabPosition(Top)[br]
		}[br]
		[br]
		#We do the same work  with the second tab's page.[br]
		%layoutsecondtab=$new(layout,%secondtab)[br]
		%labelwp=$new(label,%secondtab)[br]
		%labelwp->$settext("Enjoy the new Class provided by")[br]
		%layoutsecondtab->$addwidget(%labelwp,0,0)[br]
		%labelwp->$setalignment("Center")[br]
		%labelgen=$new(label,%secondtab)[br]
		%labelgen->$settext(Grifisx \& Noldor)[br]
		%labelgen->$setalignment("Center")[br]
		%layoutsecondtab->$addwidget(%labelgen,1,0)[br]
		%Tabwidget->$addTab(%secondtab,&About,50)[br]
		[br]
		#Let's show our example. [br]
		%Tabwidget->$show()[br]
		|---End.[br][br]
	@signals:
		!sg: $currentChange()
		This signal is emitted by the default implementation of [classfnc]$currentChangedEvent[/classfnc]().[br]
		If you reimplement that function you will have to emit the signal manually (if you still need it).[br]
*/

static KviScriptObjectClass * g_pTabWidgetClass = 0;

static KviScriptObject * TabWidgetClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptTabWidgetObject(c, p, n);
}

KviScriptTabWidgetObject::KviScriptTabWidgetObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptTabWidgetObject::~KviScriptTabWidgetObject()
{
}

bool KviScriptTabWidgetObject::init(KviCommand *)
{
	setObject(new QTabWidget(parentScriptWidget(), name()), true);
	connect(widget(),SIGNAL(currentChanged(int)),this,SLOT(slotcurrentChanged(int)));

	return true;
}

#define tabwidgetFuncReg(__nam, __func) \
	g_pTabWidgetClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptTabWidgetObject::__func)), \
	0, true);

void KviScriptTabWidgetObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pTabWidgetClass = new KviScriptObjectClass(base, "tabwidget",
		TabWidgetClassCreateInstance, true);

	tabwidgetFuncReg("addTab", functionaddTab);
	tabwidgetFuncReg("insertTab", functioninsertTab);
	tabwidgetFuncReg("setTabToolTip", functionsetTabToolTip);
	tabwidgetFuncReg("removeTabToolTip", functionremoveTabToolTip);
	tabwidgetFuncReg("setTabLabel", functionsetTabLabel);
	tabwidgetFuncReg("changeTab", functionchangeTab);
	tabwidgetFuncReg("setCurrentPage", functionsetCurrentPage);
	tabwidgetFuncReg("currentPageIndex", functioncurrentPageIndex);
	tabwidgetFuncReg("label", functiontabLabel);
	tabwidgetFuncReg("currentTabLabel", functioncurrentTabLabel);
	tabwidgetFuncReg("setMargin", functionsetMargin);
	tabwidgetFuncReg("margin", functionmargin);
	tabwidgetFuncReg("count", functioncount);
	tabwidgetFuncReg("currentChangedEvent", functioncurrentChangedEvent);
	tabwidgetFuncReg("removePage", functionremovePage);
	tabwidgetFuncReg("setTabPosition", functionsetTabPosition);
}

void KviScriptTabWidgetObject::unregisterSelf()
{
	delete g_pTabWidgetClass;
    g_pTabWidgetClass = 0;
}

bool KviScriptTabWidgetObject::functionaddTab(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::addTab");

	KviStr * pWidget = params->safeFirst();
	KviStr * pLabel = params->safeNext();

	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget object to add (%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't add a non-widget object"));
		return c->leaveStackFrame();
	}
	QPixmap *pix=g_pIconManager->getImage(params->safeNext()->ptr());
	if (pix){
		const QIconSet *icon=new QIconSet(*pix);
		((QTabWidget *)widget())->addTab(((QWidget *)(ob->object())),*icon,pLabel->ptr());
}else{
	((QTabWidget *)widget())->addTab(((QWidget *)(ob->object())),pLabel->ptr());
}

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functioninsertTab(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::insertTab");

	KviStr * pWidget = params->safeFirst();
	KviStr * pLabel = params->safeNext();
	KviStr * pIndex = params->safeNext();

	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget object to add (%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't add a non-widget object"));
		return c->leaveStackFrame();
	}

	bool bOk;
	unsigned int uIndex = pIndex->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid index parameter (%s)"),pIndex->ptr());
		return c->leaveStackFrame();
	}

	QPixmap *pix=g_pIconManager->getImage(params->safeNext()->ptr());
	if (pix){
		const QIconSet *icon=new QIconSet(*pix);
		((QTabWidget *)widget())->insertTab(((QWidget *)(ob->object())),*icon,pLabel->ptr(),uIndex);
}else{
	((QTabWidget *)widget())->insertTab(((QWidget *)(ob->object())),pLabel->ptr(),uIndex);
}
	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functionsetCurrentPage(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setCurrentPage");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QTabWidget *)widget())->setCurrentPage(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptTabWidgetObject::functionsetTabToolTip(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::setTabToolTip");

	KviStr * pWidget = params->safeFirst();
	KviStr * pLabel = params->safeNext();
	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the object "),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't set a non-widget object"));
		return c->leaveStackFrame();
	}
	int ctrl = ((QTabWidget *)widget())->indexOf (((QWidget *)(ob->object())));
	
	if (ctrl == -1) 
	{
		c->warning(__tr("Can't find the tab "),pWidget->ptr());
		return c->leaveStackFrame();
	}
	
	((QTabWidget *)widget())->setTabToolTip(((QWidget *)(ob->object())),pLabel->ptr());

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functionremoveTabToolTip(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::removeTabToolTip");

	KviStr * pWidget = params->safeFirst();
	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the tab object "),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't set a non-widget object"));
		return c->leaveStackFrame();
	}

	((QTabWidget *)widget())->removeTabToolTip(((QWidget *)(ob->object())));

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functionsetTabLabel(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::setLabel");

	KviStr * pWidget = params->safeFirst();
	KviStr * pLabel = params->safeNext();
	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget(%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}


	((QTabWidget *)widget())->setTabLabel(((QWidget *)(ob->object())),pLabel->ptr());

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functioncurrentPageIndex(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QTabWidget *)widget())->currentPageIndex());
	return true;
}

bool KviScriptTabWidgetObject::functiontabLabel(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "tabWidget::tabLabel");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int index = p->getInt(&bOk);
	if(bOk)
	{
		QString ssss = ((QTabWidget *)widget())->label(index);
		QCString sssc = ssss.utf8();
		if(!sssc.isEmpty())
			b.append(KviStr::Format,"%s",sssc.data());
	} else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}
bool KviScriptTabWidgetObject::functioncurrentTabLabel(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "tabWidget::currentTabLabel");
	if(!widget())
	    return c->leaveStackFrame(); 
	int i = ((QTabWidget *)widget())->currentPageIndex();

	QString ssss = ((QTabWidget *)widget())->label(i);
	QCString sssc = ssss.utf8();
	if(!sssc.isEmpty())
		b.append(KviStr::Format,"%s",sssc.data());

	return c->leaveStackFrame();

}
bool KviScriptTabWidgetObject::functionchangeTab(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::changeTabLabel");

	KviStr * pWidget = params->safeFirst();
	KviStr * pLabel = params->safeNext();
	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget(%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	QPixmap *pix=g_pIconManager->getImage(params->safeNext()->ptr());
	if (pix){
		const QIconSet *icon=new QIconSet(*pix);
		((QTabWidget *)widget())->changeTab(((QWidget *)(ob->object())),*icon,pLabel->ptr());
}else{
	((QTabWidget *)widget())->changeTab(((QWidget *)(ob->object())),pLabel->ptr());
}
	return c->leaveStackFrame();

}

bool KviScriptTabWidgetObject::functionsetMargin(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"layout::setMargin");

	KviStr * pMargin = params->safeFirst();

	bool bOk;
	unsigned int uMargin = pMargin->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid marging value (%s)"),pMargin->ptr());
		return c->leaveStackFrame();
	}

	((QTabWidget *)widget())->setMargin(uMargin);

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functionmargin(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QTabWidget *)widget())->margin());
	return true;
}

bool KviScriptTabWidgetObject::functioncount(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QTabWidget *)widget())->count());
	return true;
}

bool KviScriptTabWidgetObject::functionremovePage(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::removePage");

	KviStr * pWidget = params->safeFirst();
	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the tab object "),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't set a non-widget object"));
		return c->leaveStackFrame();
	}

	((QTabWidget *)widget())->removePage(((QWidget *)(ob->object())));

	return c->leaveStackFrame();
}

bool KviScriptTabWidgetObject::functionsetTabPosition(KviCommand * c, KviParameterList * params,
	KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"tabwidget::setTabPosition");
	KviStr * pModoS = params->safeFirst();
	QString modosoS = pModoS->ptr();
	if(widget())
	{

		if(modosoS=="Top")
			((QTabWidget *)widget())->setTabPosition(QTabWidget::Top);
		if(modosoS=="Bottom")
			((QTabWidget *)widget())->setTabPosition(QTabWidget::Bottom);
	}

	return true;
}

bool KviScriptTabWidgetObject::functioncurrentChangedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"slider::currentChangedEvent");
	emitSignal("currentChanged",0,0,c);
	return c->leaveStackFrame();

}

void KviScriptTabWidgetObject::slotcurrentChanged(int i)
{
	KviStr * s = new KviStr();
	s->setNum(i);
	callEventFunction("currentChangedEvent",0,new KviParameterList(s));
}

#include "m_class_tabwidget.moc"
