//mdm :
//   File : class_popupmenu.cpp
//   Creation date : Mon Feb 01 21:30:48 CEST 2005 
//	 by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//   Lucia Papini (^ashura^)  English Translation.
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "class_popupmenu.h"
#include "kvi_error.h"

#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"


static KviScriptObjectClass * g_pPopupMenuClass = 0;

static KviScriptObject * popupmenuClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptPopupMenuObject(c, p, n);
}
/*
	@doc:	popupmenu
	@keyterms:
		popupmenu object class,
	@title:
		popupmenu class
	@type:
		class
	@short:
		Provides a popup menu.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		This widget can be used to display a popup menu.Technically, a popup menu consists of a list of menu items.[br]
		You add items with insertItem(). An item is either a string or a widget. In addition, items can have an optional icon drawn on the very left side.[br] 
	@functions:
		!fn: $insertItem(<text or widget>,[icon id])
		Inserts menu items into a popup menu with optional icon and return the popup identifier.[br]
		!fn: $insertWidget(<widget>)[br]
		Inserts widget items int a popup menu and return the popup identifier.[br]
		The widget is treats as a separator; this means that the item is not selectable and you can, for example, simply insert a label if you need a popup menu with a title.[br]
		!fn: $insertHandle(<popupmenu object>,[icon])
		Inserts a submenu with optional icon into the popup menu.[br]
		!fn: $exec([widget,x,y])
		If called without paramaters show the popup menu at the current pointer position.[br]
		With the optional parameters show the popup menu at the coordinate x,y widget parameter relative[br]
		!fn: $removeItem(<popup id>)
		Removes the menu item that has the identifier id.[br]
		!fn: $removeItemAt(<index>)
		Removes the menu item at position index.[br]
		!fn: $insertSeparator(<index>)
		Inserts a separator at position index.[br]
		If the index is negative the separator becomes the last menu item.[br]
		!fn: $activatedEvent()
		This function is called when a menu item and return the the item id.[br]
		The default implementation emits the [classfnc]$activated[/classfnc]() signal.[br]
		!fn: $highligthtedEvent()
		This function is called when a menu item is highlighted and return the item id.[br]
		The default implementation emits the [classfnc]$highlighted[/classfnc]() signal.[br]
	@signals:
		!sg: $activated()
		This signal is emitted by the default implementation of [classfnc]activatedEvent[/classfnc]().[br]
		!sg: $highlighted()
		This signal is emitted by the default implementation of [classfnc]highlightedEvent[/classfnc]().[br]
		[br]
		|-EXAMPLE POPUP MENU-|[br]
		|--Start:
		# First of all we create an array wich will be used to create random colors.[br]
		%Hex[]=$array(0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F)[br]
		[br]
		class (ws,widget)[br]
		{[br]
		#In the constructor we create everything that belong to the single widget.[br]
			constructor[br]
			{[br]
				#Geometry of the widget and setting-up of layout [br]
				$$->$setGeometry(%X,%Y,100,100)[br]
			    $$->%lay=$new(layout,$$)[br]
				#Here we generate a cicle to create our labels inside the widget.[br]
				%i=0[br]
				while (%i<10)[br]
				{[br]
					$$->%label=$new(label,$$)[br]
					$$->%label->$settext("Another class by N\&G")[br]
					#We set our foreground's coulor using the hex arrey in random way.[br]
					%color=%Hex[$rand(14)]%Hex[$rand(14)]%Hex[$rand(14)]%Hex[$rand(14)]%Hex[$rand(14)]%Hex[$rand(14)][br]
					$$->%label->$setforegroundcolor(%color)[br]
					$$->%label->$setautoresize(1)[br]
					#We add the label to the widget's layout.[br]
					$$->%lay->$addwidget($$->%label,%i,0)[br]
					%i++;[br]
				}[br]
				#We make the popupmenu relative to this widget: this is merely demonstrative.[br]
				#because it creates 25 identical popups.[br]
				$$->%Popupmenu=$new(popupmenu,$$)[br]
				#we create the label widget wich will be used as popup's title[br]
				$$->%Popuptitle=$new(label)[br]
				$$->%Popuptitle->$settext(<B><U>"Windows Options"</B></U>)[br]
				$$->%Popuptitle->$setAlignment(Center)[br]
				#and we add it.[br]
				%A=$$->%Popuptitle[br]
				$$->%Popupmenu->$insertwidget(%A)[br]
				#Here we keep the various IDs in the arrays[br]
				%Tile[%I]=$$->%Popupmenu->$insertItem("Tile",118)[br]
				%Cascade[%I]=$$->%Popupmenu->$insertItem("Cascade",115)[br]
				$$->%Popupmenu->$insertSeparator(3)[br]
				%Closeactw[%I]=$$->%Popupmenu->$insertItem("Close Active Window",08)[br]
				%Closeallw[%I]=$$->%Popupmenu->$insertItem("Close All Window",58)[br]
				$$->$show()[br]
				privateimpl($$->%Popupmenu,activatedEvent)[br]
				{[br]
					%id=$0[br]
					%i = 0[br]
					#with this cicle we control wich of the items has been called  comparing the id given back by the event with our arrays created before;[br]
					while (%i<20)[br]
					{[br]
						if (%id == %Tile[%i]) return %Workspace->$tile()[br]
						if (%id == %Cascade[%i]) return %Workspace->$cascade()[br]
						if (%id == %Closeactw[%i]) return %Workspace->$closeactivewindow()[br]
						if (%id == %Closeallw[%i]) return %Workspace->$closeallwindows()[br]  
						%i ++[br]
					}[br]
				}[br]
			}[br]
		   #we activate the popup pushing the right mouse button on the widget[br]
		  mousepressevent[br]
			{[br]
			   if ($0 == 1) $$->%Popupmenu->$exec()[br]
			}[br]
		}[br]
		%Workspace=$new(workspace)[br]
		%Workspace->$resize(640,480)[br]
		%I=0[br]
		%Cicle=1[br]
		while (%I<20)[br]
		{[br]
			%X=$rand(500)[br]
			%Y=$rand(480)[br]
			%Widget=$new(ws,%Workspace)[br]
			%I++[br]
		}[br]
		#Let's show!
		%Workspace->$show[br]
		|--End.[br][br]
*/
		
KviScriptPopupMenuObject::KviScriptPopupMenuObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptPopupMenuObject::~KviScriptPopupMenuObject()
{
}

bool KviScriptPopupMenuObject::init(KviCommand *)
{
	setObject(new QPopupMenu(parentScriptWidget(), name()), true);
	connect(widget(),SIGNAL(activated(int)),this,SLOT(slotactivated(int)));
	connect(widget(),SIGNAL(highlighted(int)),this,SLOT(slothighlighted(int)));

	return true;
}

#define PopupMenuFuncReg(__nam, __func) \
	g_pPopupMenuClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptPopupMenuObject::__func)), \
	0, true);

void KviScriptPopupMenuObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pPopupMenuClass = new KviScriptObjectClass(base, "popupmenu", 
		popupmenuClassCreateInstance, true);

	PopupMenuFuncReg("insertItem", functioninsertItem);
	PopupMenuFuncReg("insertWidget",functioninsertWidget);
	PopupMenuFuncReg("insertHandle", functioninsertHandle);
	PopupMenuFuncReg("exec", functionexec);
	PopupMenuFuncReg("removeItem",functionremoveItem);
	PopupMenuFuncReg("removeItemAt",functionremoveItemAt);
	PopupMenuFuncReg("insertSeparator", functioninsertSeparator);
//events
	PopupMenuFuncReg("activatedEvent", functionactivatedEvent);
	PopupMenuFuncReg("highligthtedEvent",functionhighlightedEvent);


}

void KviScriptPopupMenuObject::unregisterSelf()
{
	delete g_pPopupMenuClass;
    g_pPopupMenuClass = 0;
}
 
bool KviScriptPopupMenuObject::functioninsertItem(KviCommand *c, KviParameterList *p, KviStr & b)
{

        KviStr * pItem = p->safeFirst();
        QPixmap *pix = 0;

        if(!widget())return true;
        KviStr * pPix = p->safeNext();

        if(pPix) pix = g_pIconManager->getImage(pPix->ptr());

        if(pix)
                 b.append(KviStr::Format, "%d",((QPopupMenu *)widget())->insertItem(*pix,pItem->ptr()));
		else 
                 b.append(KviStr::Format, "%d",((QPopupMenu *)widget())->insertItem(pItem->ptr()));
        return c->leaveStackFrame();
      
}

bool KviScriptPopupMenuObject::functioninsertWidget(KviCommand *c, KviParameterList *p, KviStr & b)
{

        KviStr * pWidget = p->safeFirst();
       
        if(!widget())return true;
       
        
        KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
        if(!ob)
        {
			c->warning(__tr("Can't find the widget object to add (%s)"),pWidget->ptr());
			return c->leaveStackFrame();
                              
        }

        if(!ob->object())
        {
                c->warning(__tr("Invalid object"));
                return c->leaveStackFrame();
        }

        if(!ob->object()->isWidgetType())
        {
                c->warning(__tr("Can't add a non-widget object"));
                return c->leaveStackFrame();
        }
	
                ((QPopupMenu *)widget())->insertItem(((QPopupMenu  *)(ob->object())));
        return c->leaveStackFrame();
}



bool KviScriptPopupMenuObject::functioninsertHandle(KviCommand *c, KviParameterList *p, KviStr & b)
{

	KviStr * pLabel = p->safeFirst();
	KviStr * pPopmenu = p->safeNext();
	QPixmap *pix = 0;

	if(!widget())return true;
	KviStr * pPix = p->next();

	if(pPix) pix = g_pIconManager->getImage(pPix->ptr());


	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pPopmenu->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the popupmenu object to add (%s)"),pPopmenu->ptr());
		return c->leaveStackFrame();

	}
	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!(ob->object())->inherits("QPopupMenu"))
	{
		c->warning(__tr("Doesn't a popupmenu object"));
		return c->leaveStackFrame();
	}


if(pix)
	{
			b.append(KviStr::Format, "%d",((QPopupMenu *)widget())->insertItem(*pix,pLabel->ptr(),((QPopupMenu  *)(ob->object()))));
				return c->leaveStackFrame();
	} else {
			b.append(KviStr::Format, "%d",((QPopupMenu *)widget())->insertItem(pLabel->ptr(),((QPopupMenu  *)(ob->object()))));
				return c->leaveStackFrame();
	}
	

}  


bool KviScriptPopupMenuObject::functionexec(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"popupmenu::exec");
	if(!params->count())
	{
	 ((QPopupMenu *)widget())->exec(QCursor::pos());
	 return true;
	}

	KviStr * pWidget = params->safeFirst();
	KviStr * pXpos = params->safeNext();
	KviStr * pYpos = params->safeNext();

	
	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget object (%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Doesn't a widget object"));
		return c->leaveStackFrame();
	}
	

	bool bOk;
	unsigned int uYpos = pYpos->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid row parameter (%s)"),pYpos->ptr());
		return c->leaveStackFrame();
	}

	unsigned int uXpos = pXpos->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid column parameter (%s)"),pXpos->ptr());
		return c->leaveStackFrame();
	}
	((QPopupMenu *)widget())->exec(((QWidget *)(ob->object()))->mapToGlobal(QPoint(uXpos,uYpos)) );

	return c->leaveStackFrame();
}

bool KviScriptPopupMenuObject::functionremoveItem(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "popupmenu::removeItem");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QPopupMenu *)widget())->removeItem(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}
bool KviScriptPopupMenuObject::functionremoveItemAt(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "popupmenu::removeItemAt");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QPopupMenu *)widget())->removeItemAt(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}
bool KviScriptPopupMenuObject::functioninsertSeparator(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "popupmenu::insertSeparator");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QPopupMenu *)widget())->insertSeparator(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptPopupMenuObject::functionactivatedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"popupmenu::activatedEvent");
	emitSignal("activated",0,0,c);
	return c->leaveStackFrame();

}

void KviScriptPopupMenuObject::slotactivated(int i)
{
	KviStr * s = new KviStr();
	s->setNum(i);
	callEventFunction("activatedEvent",0,new KviParameterList(s));
}

bool KviScriptPopupMenuObject::functionhighlightedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"popupmenu::highlightedEvent");
	emitSignal("highlighted",0,0,c);
	return c->leaveStackFrame();

}

void KviScriptPopupMenuObject::slothighlighted(int i)
{
	KviStr * s = new KviStr();
	s->setNum(i);
	callEventFunction("highlightedEvent",0,new KviParameterList(s));
}

#include "m_class_popupmenu.moc"
