#ifndef _CLASS_LAYOUT_H_
#define _CLASS_LAYOUT_H_
//
//   File : class_layout.h
//   Creation date : Fri Now 22 2002 00:50:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_string.h"

#include "kvi_scriptobject.h"

#include <qlayout.h>

class KviScriptLayoutObject : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptLayoutObject(KviScriptObjectClass * cla,KviScriptObject * par,const char * nam);
	virtual ~KviScriptLayoutObject();
protected:

protected:
	bool functionAddWidget(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionAddMultiCellWidget(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSetRowStretch(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSetColStretch(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSetMargin(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSetSpacing(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionAddRowSpacing(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionAddColSpacing(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSetResizeMode(KviCommand *c,KviParameterList * params,KviStr &buffer);

	virtual bool init(KviCommand * c);
public:
	static void registerSelf();
	static void unregisterSelf();
};


#endif //_CLASS_LAYOUT_H_
